/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.changeset;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Line2D;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.changeset.util.DataSetChangesetBuilder;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

public class ChangesetLayer
extends Layer
implements ActionListener {
    DataSetChangesetBuilder.BoundedChangesetDataSet dataSet;
    float width;

    public ChangesetLayer(String name) {
        super(name);
    }

    public Icon getIcon() {
        return ImageProvider.get((String)"changeset_layer");
    }

    public String getToolTipText() {
        return I18n.tr((String)"Layer to draw OSM error", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer other) {
        return false;
    }

    public void setDataSet(DataSetChangesetBuilder.BoundedChangesetDataSet dataSet) {
        this.dataSet = dataSet;
        this.invalidate();
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        DataSet data = this.dataSet.getDataSet();
        Stroke stroke = g.getStroke();
        if (data == null) {
            return;
        }
        float[] dash1 = new float[]{10.0f};
        for (OsmPrimitive primitive : data.allPrimitives()) {
            Node node;
            g.setStroke(new BasicStroke(2.0f));
            if (primitive instanceof Way) {
                Way way = (Way)primitive;
                if (((String)way.getInterestingTags().get("action")).equals("create")) {
                    g.setColor(new Color(50, 214, 184));
                } else if (((String)way.getInterestingTags().get("action")).equals("delete")) {
                    g.setColor(new Color(197, 38, 63));
                } else if (((String)way.getInterestingTags().get("action")).equals("modify-old")) {
                    g.setColor(new Color(214, 138, 13));
                } else if (((String)way.getInterestingTags().get("action")).equals("modify-new")) {
                    g.setColor(new Color(229, 228, 61));
                } else if (((String)way.getInterestingTags().get("action")).equals("modify-new-rel")) {
                    g.setColor(new Color(229, 228, 61));
                    g.setStroke(new BasicStroke(1.0f, 0, 1, 10.0f, dash1, 0.0f));
                } else if (((String)way.getInterestingTags().get("action")).equals("modify-old-rel")) {
                    g.setColor(new Color(214, 138, 13));
                    g.setStroke(new BasicStroke(1.0f, 0, 1, 10.0f, dash1, 0.0f));
                } else if (((String)way.getInterestingTags().get("action")).equals("create-rel")) {
                    g.setColor(new Color(50, 214, 184));
                    g.setStroke(new BasicStroke(1.0f, 0, 1, 10.0f, dash1, 0.0f));
                } else if (((String)way.getInterestingTags().get("action")).equals("delete-rel")) {
                    g.setColor(new Color(197, 38, 63));
                    g.setStroke(new BasicStroke(1.0f, 0, 1, 10.0f, dash1, 0.0f));
                }
                List nodes = way.getNodes();
                if (nodes.size() < 2) {
                    return;
                }
                for (int i = 0; i <= way.getNodes().size() - 2; ++i) {
                    Node node1 = way.getNode(i);
                    Node node2 = way.getNode(i + 1);
                    Point pnt1 = mv.getPoint(node1.getCoor());
                    Point pnt2 = mv.getPoint(node2.getCoor());
                    g.draw(new Line2D.Double(pnt1.x, pnt1.y, pnt2.x, pnt2.y));
                }
                continue;
            }
            if (!(primitive instanceof Node) || !(node = (Node)primitive).getParentWays().isEmpty()) continue;
            if (((String)node.getInterestingTags().get("action")).equals("create")) {
                g.setColor(new Color(50, 214, 184));
            } else if (((String)node.getInterestingTags().get("action")).equals("delete")) {
                g.setColor(new Color(197, 38, 63));
            } else if (((String)node.getInterestingTags().get("action")).equals("modify-old")) {
                g.setColor(new Color(214, 138, 13));
            } else if (((String)node.getInterestingTags().get("action")).equals("modify-new")) {
                g.setColor(new Color(229, 228, 61));
            }
            Point pnt = mv.getPoint(node.getCoor());
            g.fillOval(pnt.x, pnt.y, 7, 7);
        }
        g.setStroke(stroke);
    }

    public void visitBoundingBox(BoundingXYVisitor v) {
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), Layer.SeparatorLayerAction.INSTANCE, Layer.SeparatorLayerAction.INSTANCE, new LayerListPopup.InfoAction((Layer)this)};
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JOptionPane.showConfirmDialog(null, e.getSource());
    }

    public void mergeFrom(Layer layer) {
    }
}

