/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.simplifyarea;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class SimplifyAreaPreferenceSetting
extends DefaultTabPreferenceSetting {
    static final String DIST_FACTOR = "simplify-area.dist.factor";
    static final String DIST_THRESHOLD = "simplify-area.dist.threshold";
    static final String AREA_FACTOR = "simplify-area.area.factor";
    static final String AREA_THRESHOLD = "simplify-area.area.threshold";
    static final String ANGLE_FACTOR = "simplify-area.angle.factor";
    static final String ANGLE_THRESHOLD = "simplify-area.angle.threshold";
    static final String MERGE_THRESHOLD = "simplify-area.merge.threshold";
    private final JTextField mergeThreshold = new JosmTextField(8);
    private final JTextField angleThreshold = new JosmTextField(8);
    private final JTextField angleFactor = new JosmTextField(8);
    private final JTextField areaThreshold = new JosmTextField(8);
    private final JTextField areaFactor = new JosmTextField(8);
    private final JTextField distanceThreshold = new JosmTextField(8);
    private final JTextField distanceFactor = new JosmTextField(8);

    public SimplifyAreaPreferenceSetting() {
        super("simplifyArea", I18n.tr((String)"Simplify Area", (Object[])new Object[0]), I18n.tr((String)"Node of the way (area) is removed if all of <u>Angle Weight</u>, <u>Area Weight</u> and <u>Distance Weight</u> are greater than 1. <u>Weight</u> is computed as <u>Value</u> / <u>Threshold</u>, where <u>Value</u> is one of <u>Angle</u>, <u>Area</u> and <u>Distance</u> computed from every three adjanced points of the way.<ul><li><u>Value</u> of <u>Angle</u> is angle in degrees on the second node</li><li><u>Value</u> of <u>Area</u> is area formed by triangle</li><li><u>Value</u> of the <u>Distance</u> is Cross Track Error Distance</li></ul>All three <u>Weight</u>s multiplied by its <u>Factor</u>s are summed and node of the lowest sum is removed first. Removal continues until there is no node to remove.Merge Nearby Nodes is another step of the simplification that merges adjanced nodes that are closer than <u>Threshold</u> meters.", (Object[])new Object[0]));
    }

    public void addGui(PreferenceTabbedPane gui) {
        PreferenceTabbedPane.PreferencePanel tab = gui.createPreferenceTab((TabPreferenceSetting)this);
        this.angleThreshold.setText(Config.getPref().get(ANGLE_THRESHOLD, "10"));
        tab.add((Component)new JLabel(I18n.tr((String)"Angle Threshold", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.angleThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.angleFactor.setText(Config.getPref().get(ANGLE_FACTOR, "1.0"));
        tab.add((Component)new JLabel(I18n.tr((String)"Angle Factor", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.angleFactor, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.areaThreshold.setText(Config.getPref().get(AREA_THRESHOLD, "5.0"));
        tab.add((Component)new JLabel(I18n.tr((String)"Area Threshold", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.areaThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.areaFactor.setText(Config.getPref().get(AREA_FACTOR, "1.0"));
        tab.add((Component)new JLabel(I18n.tr((String)"Area Factor", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.areaFactor, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.distanceThreshold.setText(Config.getPref().get(DIST_THRESHOLD, "3"));
        tab.add((Component)new JLabel(I18n.tr((String)"Distance Threshold", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.distanceThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.distanceFactor.setText(Config.getPref().get(DIST_FACTOR, "3"));
        tab.add((Component)new JLabel(I18n.tr((String)"Distance Factor", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.distanceFactor, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.mergeThreshold.setText(Config.getPref().get(MERGE_THRESHOLD, "0.2"));
        tab.add((Component)new JLabel(I18n.tr((String)"Merge Nearby Nodes Threshold", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.mergeThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        tab.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public boolean ok() {
        Config.getPref().put(MERGE_THRESHOLD, this.mergeThreshold.getText());
        Config.getPref().put(ANGLE_THRESHOLD, this.angleThreshold.getText());
        Config.getPref().put(ANGLE_FACTOR, this.angleFactor.getText());
        Config.getPref().put(AREA_THRESHOLD, this.areaThreshold.getText());
        Config.getPref().put(AREA_FACTOR, this.areaFactor.getText());
        Config.getPref().put(DIST_THRESHOLD, this.distanceThreshold.getText());
        Config.getPref().put(DIST_FACTOR, this.distanceFactor.getText());
        return false;
    }
}

