/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.gpsblam;

import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.visitor.BoundingXYVisitor;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListPopup;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.plugins.gpsblam.GPSBlamMarker;
import org.openstreetmap.josm.plugins.gpsblam.GPSBlamPlugin;
import org.openstreetmap.josm.tools.I18n;

class GPSBlamLayer
extends Layer {
    private final Collection<GPSBlamMarker> blamMarkers = new LinkedList<GPSBlamMarker>();
    private static final Icon ICON = new ImageIcon(Toolkit.getDefaultToolkit().createImage(GPSBlamPlugin.class.getResource("/images/gpsblam_layer.png")));

    GPSBlamLayer(String name) {
        super(name);
    }

    public Icon getIcon() {
        return ICON;
    }

    public Object getInfoComponent() {
        return this.getToolTipText();
    }

    public Action[] getMenuEntries() {
        return new Action[]{LayerListDialog.getInstance().createShowHideLayerAction(), LayerListDialog.getInstance().createDeleteLayerAction(), new LayerListPopup.InfoAction((Layer)this)};
    }

    public String getToolTipText() {
        return I18n.tr((String)"GPS Blams", (Object[])new Object[0]);
    }

    public boolean isMergable(Layer arg0) {
        return false;
    }

    public void mergeFrom(Layer arg0) {
    }

    public void paint(Graphics2D g, MapView mv, Bounds bounds) {
        for (GPSBlamMarker blamMarker : this.blamMarkers) {
            blamMarker.paint(g, mv);
        }
    }

    public void visitBoundingBox(BoundingXYVisitor arg0) {
    }

    void addBlamMarker(GPSBlamMarker blamMarker) {
        this.blamMarkers.add(blamMarker);
    }
}

