/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.MonocleSettings;
import com.sun.glass.ui.monocle.MonocleTrace;
import com.sun.glass.ui.monocle.NativePlatform;
import java.security.AccessController;

public abstract class NativePlatformFactory {
    private static NativePlatform platform;
    private static final int majorVersion = 1;
    private static final int minorVersion = 0;

    protected abstract boolean matches();

    protected abstract NativePlatform createNativePlatform();

    protected abstract int getMajorVersion();

    protected abstract int getMinorVersion();

    public static synchronized NativePlatform getNativePlatform() {
        if (platform == null) {
            String platformFactoryProperty = AccessController.doPrivileged(() -> System.getProperty("monocle.platform", "MX6,OMAP,Dispman,Android,X11,Linux,Headless"));
            String[] platformFactories = platformFactoryProperty.split(",");
            for (int i = 0; i < platformFactories.length; ++i) {
                String factoryName = platformFactories[i].trim();
                Object factoryClassName = factoryName.contains(".") ? factoryName : "com.sun.glass.ui.monocle." + factoryName + "PlatformFactory";
                if (MonocleSettings.settings.tracePlatformConfig) {
                    MonocleTrace.traceConfig("Trying platform %s with class %s", factoryName, factoryClassName);
                }
                try {
                    ClassLoader loader = NativePlatformFactory.class.getClassLoader();
                    Class<?> clazz = Class.forName((String)factoryClassName, false, loader);
                    if (!NativePlatformFactory.class.isAssignableFrom(clazz)) {
                        throw new IllegalArgumentException("Unrecognized Monocle platform: " + (String)factoryClassName);
                    }
                    NativePlatformFactory npf = (NativePlatformFactory)clazz.newInstance();
                    if (!npf.matches() || npf.getMajorVersion() != 1 || npf.getMinorVersion() != 0) continue;
                    platform = npf.createNativePlatform();
                    if (MonocleSettings.settings.tracePlatformConfig) {
                        MonocleTrace.traceConfig("Matched %s", factoryName);
                    }
                    return platform;
                }
                catch (Exception e) {
                    if (MonocleSettings.settings.tracePlatformConfig) {
                        MonocleTrace.traceConfig("Failed to create platform %s", factoryClassName);
                    }
                    e.printStackTrace();
                }
            }
            throw new UnsupportedOperationException("Cannot load a native platform from: '" + platformFactoryProperty + "'");
        }
        return platform;
    }
}

