/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.imageutils.shape;

import java.awt.geom.AffineTransform;
import org.jaitools.imageutils.shape.AbstractLiteIterator;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

public final class PackedLineIterator
extends AbstractLiteIterator {
    private AffineTransform at;
    private PackedCoordinateSequence.Double coordinates = null;
    private int currentCoord = 0;
    private boolean done = false;
    private boolean isClosed;
    private int coordinateCount;

    public PackedLineIterator(LineString ls, AffineTransform at) {
        if (at == null) {
            at = new AffineTransform();
        }
        this.at = at;
        this.coordinates = (PackedCoordinateSequence.Double)ls.getCoordinateSequence();
        this.coordinateCount = this.coordinates.size();
        this.isClosed = ls instanceof LinearRing;
    }

    public int currentSegment(float[] coords) {
        if (this.currentCoord == 0) {
            coords[0] = (float)this.coordinates.getX(0);
            coords[1] = (float)this.coordinates.getY(0);
            this.at.transform(coords, 0, coords, 0, 1);
            return 0;
        }
        if (this.currentCoord == this.coordinateCount && this.isClosed) {
            return 4;
        }
        coords[0] = (float)this.coordinates.getX(this.currentCoord);
        coords[1] = (float)this.coordinates.getY(this.currentCoord);
        this.at.transform(coords, 0, coords, 0, 1);
        return 1;
    }

    public int getWindingRule() {
        return 1;
    }

    public boolean isDone() {
        return this.done;
    }

    public void next() {
        if (this.currentCoord == this.coordinateCount - 1 && !this.isClosed || this.currentCoord == this.coordinateCount && this.isClosed) {
            this.done = true;
        } else {
            ++this.currentCoord;
        }
    }

    public int currentSegment(double[] coords) {
        System.out.println("Double!");
        return 0;
    }
}

