/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.pointinfo.catastro;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.json.Json;
import javax.json.JsonObject;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openstreetmap.josm.tools.Logging;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class CatastroRecord {
    public static final String fURL = "http://ovc.catastro.meh.es/OVCServWeb/OVCWcfLibres/OVCFotoFachada.svc/RecuperarFotoFachadaGet?ReferenciaCatastral=";
    public static final String cURL = "http://www.catastro.meh.es/";
    public static final String cSource = "Direcci\u00f3n General del Catastro";
    public static final String eURL = "https://www.verexif.com/ver.php?foto_file=&foto_url=";
    private ArrayList<JsonObject> errors;
    private ArrayList<JsonObject> coords;

    CatastroRecord() {
        this.init();
    }

    private void init() {
        this.errors = new ArrayList();
        this.coords = new ArrayList();
    }

    public void parseXML(String xmlStr) {
        this.init();
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(xmlStr.getBytes(StandardCharsets.UTF_8));
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder dBuilder = dbFactory.newDocumentBuilder();
            Document doc = dBuilder.parse(input);
            doc.getDocumentElement().normalize();
            this.parseErrors(doc);
            this.parseCoordenadas(doc);
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (Throwable)e);
        }
    }

    private void parseErrors(Document doc) {
        try {
            NodeList nList = doc.getElementsByTagName("err");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                String code = eElement.getElementsByTagName("cod").item(0).getTextContent();
                String desc = eElement.getElementsByTagName("des").item(0).getTextContent();
                JsonObject error = Json.createObjectBuilder().add("code", code).add("desc", desc).build();
                this.errors.add(error);
                Logging.info((String)("Error: (" + code + ") " + desc));
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"errors:", (Throwable)e);
        }
    }

    private void parseCoordenadas(Document doc) {
        try {
            NodeList nList = doc.getElementsByTagName("coord");
            for (int temp = 0; temp < nList.getLength(); ++temp) {
                Node nNode = nList.item(temp);
                if (nNode.getNodeType() != 1) continue;
                Element eElement = (Element)nNode;
                String ref = eElement.getElementsByTagName("pc1").item(0).getTextContent() + eElement.getElementsByTagName("pc2").item(0).getTextContent();
                String address = eElement.getElementsByTagName("ldt").item(0).getTextContent();
                JsonObject coord = Json.createObjectBuilder().add("ref", ref).add("address", address).build();
                this.coords.add(coord);
                Logging.info((String)("Referencia Catastral: " + ref));
                Logging.info((String)("Direcci\u00f3n: " + address));
            }
        }
        catch (Exception e) {
            Logging.log((Level)Level.WARNING, (String)"coordenadas:", (Throwable)e);
        }
    }

    public String getHtml() {
        StringBuilder r = new StringBuilder();
        r.append("<html><body bgcolor=\"white\" color=\"black\" ><table><tr><td>");
        r.append("<br/>");
        for (JsonObject coord : this.coords) {
            r.append("<i><u>Informaci\u00f3n de la parcela</u></i><br/>");
            r.append("<b>Referencia Catastral: </b>" + coord.getString("ref") + "<br/>");
            r.append("<b>Direcci\u00f3n: </b>" + coord.getString("address") + "<br/>");
            r.append("<b>Fotograf\u00eda de fachada:</b> <a href=\"http://ovc.catastro.meh.es/OVCServWeb/OVCWcfLibres/OVCFotoFachada.svc/RecuperarFotoFachadaGet?ReferenciaCatastral=" + coord.getString("ref") + "\">Enlace a web de Catastro</a> (<a href=\"" + eURL + fURL + coord.getString("ref") + "\">metadatos</a>)<br/><br/>");
        }
        if (this.errors.size() > 0) {
            r.append("<i><u>Errores</u></i><br/>");
        }
        for (JsonObject error : this.errors) {
            r.append("(" + error.getString("code") + ") ");
            r.append(error.getString("desc") + "<br/>");
        }
        r.append("<hr/>");
        r.append("<center><i>Fuente: <a href=\"http://www.catastro.meh.es/\">Direcci\u00f3n General del Catastro</a></i></center>");
        r.append("</td></tr></table></body></html>");
        return r.toString();
    }

    public void performAction(String act) {
    }
}

