/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.roadsigns;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.AbstractTableModel;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.util.WindowGeometry;
import org.openstreetmap.josm.gui.widgets.MultiSplitLayout;
import org.openstreetmap.josm.gui.widgets.MultiSplitPane;
import org.openstreetmap.josm.plugins.roadsigns.RoadSignsPlugin;
import org.openstreetmap.josm.plugins.roadsigns.Sign;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.OpenBrowser;
import org.openstreetmap.josm.tools.Pair;

class RoadSignInputDialog
extends ExtendedDialog {
    protected SignSelection sel;
    protected List<Sign> signs;
    protected JTable previewTable;
    protected JCheckBox addTrafficSignTag;
    protected PreviewTableModel previewModel;
    protected JPanel pnlSignSelection;
    protected JPanel pnlPossibleSigns;
    protected JPanel pnlPossibleSupplements;
    protected JEditorPane info;
    protected JScrollPane scrollInfo;
    private MultiSplitPane multiSplitPane;

    RoadSignInputDialog() {
        super((Component)MainApplication.getMainFrame(), I18n.tr((String)"Road Sign Plugin", (Object[])new Object[0]), new String[]{I18n.tr((String)"OK", (Object[])new Object[0]), I18n.tr((String)"Cancel", (Object[])new Object[0])}, false);
        this.setRememberWindowGeometry(((Object)((Object)this)).getClass().getName() + ".geometry", WindowGeometry.centerInWindow((Component)MainApplication.getMainFrame(), (Dimension)new Dimension(750, 550)));
        this.signs = RoadSignsPlugin.signs;
        this.sel = new SignSelection();
        this.setButtonIcons(new String[]{"ok.png", "cancel.png"});
        final JTabbedPane tabs = new JTabbedPane();
        tabs.add(I18n.tr((String)"signs", (Object[])new Object[0]), this.buildSignsPanel());
        AbstractAction updateAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoadSignInputDialog.this.signs = RoadSignsPlugin.signs;
                RoadSignInputDialog.this.sel = new SignSelection();
                tabs.setComponentAt(0, RoadSignInputDialog.this.buildSignsPanel());
            }
        };
        tabs.add(I18n.tr((String)"settings", (Object[])new Object[0]), new SettingsPanel(false, updateAction));
        this.setContent(tabs, false);
    }

    protected void buttonAction(int i, ActionEvent evt) {
        Collection selPrim;
        if (i == 0 && !(selPrim = MainApplication.getLayerManager().getEditDataSet().getSelected()).isEmpty()) {
            Config.getPref().putBoolean("plugin.roadsigns.addTrafficSignTag", this.addTrafficSignTag.isSelected());
            Command cmd = this.createCommand(selPrim);
            if (cmd != null) {
                UndoRedoHandler.getInstance().add(cmd);
            }
        }
        super.buttonAction(i, evt);
    }

    public void setVisible(boolean visible) {
        if (!visible && this.multiSplitPane != null) {
            MultiSplitLayout.Node model = this.multiSplitPane.getMultiSplitLayout().getModel();
            File f = new File(RoadSignsPlugin.pluginDir(), "roadsigns-layout.xml");
            try (XMLEncoder xmlenc = new XMLEncoder(new BufferedOutputStream(new FileOutputStream(f)));){
                xmlenc.writeObject(model);
            }
            catch (FileNotFoundException ex) {
                Logging.warn((String)("unable to write dialog layout: " + ex));
            }
        }
        super.setVisible(visible);
    }

    private Command createCommand(Collection<OsmPrimitive> selPrim) {
        LinkedList<ChangePropertyCommand> cmds = new LinkedList<ChangePropertyCommand>();
        for (int i = 0; i < this.previewModel.getRowCount(); ++i) {
            String key = (String)this.previewModel.getValueAt(i, 0);
            String value = (String)this.previewModel.getValueAt(i, 1);
            cmds.add(new ChangePropertyCommand(selPrim, key, value));
        }
        if (cmds.isEmpty()) {
            return null;
        }
        if (cmds.size() == 1) {
            return (Command)cmds.get(0);
        }
        return new SequenceCommand(I18n.tr((String)"Change Properties", (Object[])new Object[0]), cmds);
    }

    private JComponent buildSignsPanel() {
        FlowLayout fLayout = new FlowLayout(0);
        fLayout.setAlignOnBaseline(true);
        this.pnlSignSelection = new JPanel();
        this.pnlSignSelection.setLayout(fLayout);
        this.pnlPossibleSigns = new FixedWidthPanel();
        this.pnlPossibleSupplements = new FixedWidthPanel();
        this.fillSigns();
        this.multiSplitPane = new MultiSplitPane();
        File f = new File(RoadSignsPlugin.pluginDir(), "roadsigns-layout.xml");
        try (XMLDecoder decoder = new XMLDecoder(new BufferedInputStream(new FileInputStream(f)));){
            MultiSplitLayout.Node model = (MultiSplitLayout.Node)decoder.readObject();
            this.multiSplitPane.getMultiSplitLayout().setModel(model);
            this.multiSplitPane.getMultiSplitLayout().setFloatingDividers(false);
        }
        catch (IOException | ArrayIndexOutOfBoundsException ex) {
            MultiSplitLayout.Split modelRoot = new MultiSplitLayout.Split();
            modelRoot.setRowLayout(false);
            MultiSplitLayout.Split row1 = new MultiSplitLayout.Split();
            row1.setWeight(0.3);
            MultiSplitLayout.Leaf upperleft = new MultiSplitLayout.Leaf("upperleft");
            upperleft.setWeight(1.0);
            row1.setChildren(Arrays.asList(upperleft, new MultiSplitLayout.Divider(), new MultiSplitLayout.Leaf("upperright")));
            MultiSplitLayout.Split row2 = new MultiSplitLayout.Split();
            row2.setWeight(0.5);
            MultiSplitLayout.Leaf middleleft = new MultiSplitLayout.Leaf("middleleft");
            middleleft.setWeight(0.5);
            MultiSplitLayout.Leaf middleright = new MultiSplitLayout.Leaf("middleright");
            middleright.setWeight(0.5);
            row2.setChildren(Arrays.asList(middleleft, new MultiSplitLayout.Divider(), middleright));
            MultiSplitLayout.Leaf bottom = new MultiSplitLayout.Leaf("bottom");
            bottom.setWeight(0.2);
            modelRoot.setChildren(Arrays.asList(row1, new MultiSplitLayout.Divider(), row2, new MultiSplitLayout.Divider(), bottom));
            this.multiSplitPane.getMultiSplitLayout().setModel((MultiSplitLayout.Node)modelRoot);
        }
        this.multiSplitPane.add((Component)new JScrollPane(this.pnlSignSelection), (Object)"upperleft");
        this.multiSplitPane.add((Component)this.buildPreviewPanel(), (Object)"upperright");
        JScrollPane scroll1 = new JScrollPane(this.pnlPossibleSigns, 20, 31);
        scroll1.setPreferredSize(new Dimension(10, 10));
        this.multiSplitPane.add((Component)scroll1, (Object)"middleleft");
        JScrollPane scroll2 = new JScrollPane(this.pnlPossibleSupplements, 20, 31);
        scroll2.setPreferredSize(new Dimension(10, 10));
        this.multiSplitPane.add((Component)scroll2, (Object)"middleright");
        this.info = new JEditorPane();
        this.info.setEditable(false);
        this.info.setContentType("text/html");
        this.info.setText(" ");
        this.info.setBackground(this.getBackground());
        this.info.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e == null || e.getURL() == null) {
                    return;
                }
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    OpenBrowser.displayUrl((String)e.getURL().toString());
                }
            }
        });
        this.scrollInfo = new JScrollPane(this.info, 20, 31);
        this.multiSplitPane.add((Component)this.scrollInfo, (Object)"bottom");
        return this.multiSplitPane;
    }

    private void fillSigns() {
        this.pnlPossibleSigns.removeAll();
        this.pnlPossibleSupplements.removeAll();
        for (Sign s : this.signs) {
            JLabel lbl = new JLabel(s.getIcon());
            String tt = "<html>" + s.name;
            String ref = s.getDefaultRef();
            if (ref != null) {
                tt = tt + "  <i><small>(" + ref + ")</small></i>";
            }
            tt = tt + "</html>";
            lbl.setToolTipText(tt);
            s.label = lbl;
            lbl.addMouseListener(new SignClickListener(s));
            if (s.isSupplementing) {
                this.pnlPossibleSupplements.add(lbl);
                continue;
            }
            this.pnlPossibleSigns.add(lbl);
        }
    }

    private void updateSelectableSignsEnabledState() {
        if (this.sel.combos.isEmpty()) {
            for (Sign s : this.signs) {
                if (!s.isSupplementing) continue;
                s.label.setEnabled(true);
            }
        } else {
            Sign main = ((SignCombination)((SignSelection)this.sel).combos.getLast()).signs.getFirst().sign;
            for (Sign s : this.signs) {
                if (!s.isSupplementing) continue;
                s.label.setEnabled(main.supplements.contains(s));
            }
        }
    }

    public JComponent buildPreviewPanel() {
        JPanel previewPanel = new JPanel(new GridBagLayout());
        Object[] columnNames = new String[]{I18n.tr((String)"Key", (Object[])new Object[0]), I18n.tr((String)"Value", (Object[])new Object[0])};
        Object[][] data = new String[][]{new String[0]};
        this.previewTable = new JTable(data, columnNames){

            @Override
            public String getToolTipText(MouseEvent e) {
                int rowIndex = this.rowAtPoint(e.getPoint());
                int colIndex = this.columnAtPoint(e.getPoint());
                if (rowIndex == -1 || colIndex == -1) {
                    return null;
                }
                return (String)this.getValueAt(rowIndex, colIndex);
            }
        };
        this.previewTable.setFillsViewportHeight(true);
        this.previewTable.setRowSelectionAllowed(false);
        this.previewTable.setColumnSelectionAllowed(false);
        this.previewModel = new PreviewTableModel();
        this.previewTable.setModel(this.previewModel);
        JScrollPane scroll = new JScrollPane(this.previewTable);
        Dimension dim = new Dimension(336, 10);
        scroll.setPreferredSize(dim);
        scroll.setMinimumSize(dim);
        this.addTrafficSignTag = new JCheckBox(I18n.tr((String)"{0} tag", (Object[])new Object[]{"traffic_sign"}));
        this.addTrafficSignTag.setSelected(Config.getPref().getBoolean("plugin.roadsigns.addTrafficSignTag"));
        this.addTrafficSignTag.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RoadSignInputDialog.this.previewModel.update();
            }
        });
        previewPanel.add((Component)scroll, GBC.eol().fill());
        previewPanel.add((Component)this.addTrafficSignTag, GBC.eol());
        return previewPanel;
    }

    public static class SettingsPanel
    extends JPanel {
        private List<RoadSignsPlugin.PresetMetaData> presetsData = RoadSignsPlugin.getAvailablePresetsMetaData();
        private JComboBox<RoadSignsPlugin.PresetMetaData> selectionBox = new JComboBox<RoadSignsPlugin.PresetMetaData>(this.presetsData.toArray(new RoadSignsPlugin.PresetMetaData[0]));
        JRadioButton rbAll;
        JRadioButton rbUseful;

        SettingsPanel(boolean standalone, final Action update) {
            super(new GridBagLayout());
            String code = Config.getPref().get("plugin.roadsigns.preset.selection", null);
            if (code != null) {
                for (RoadSignsPlugin.PresetMetaData data : this.presetsData) {
                    if (!code.equals(data.code)) continue;
                    this.selectionBox.setSelectedItem(data);
                }
            }
            this.add((Component)new JLabel(I18n.tr((String)"Country preset:", (Object[])new Object[0])), GBC.std().insets(5, 5, 5, 5));
            this.add(this.selectionBox, GBC.eol().insets(0, 5, 5, 5));
            if (!standalone) {
                this.rbAll = new JRadioButton(I18n.tr((String)"Show all signs", (Object[])new Object[0]));
                this.rbUseful = new JRadioButton(I18n.tr((String)"Show a selection of the most useful signs", (Object[])new Object[0]));
                ButtonGroup grp = new ButtonGroup();
                grp.add(this.rbAll);
                grp.add(this.rbUseful);
                String filterPref = Config.getPref().get("plugin.roadsigns.preset.filter");
                if (filterPref.equals("useful")) {
                    this.rbUseful.setSelected(true);
                } else {
                    this.rbAll.setSelected(true);
                }
                JPanel pnFilter = new JPanel(new GridBagLayout());
                pnFilter.setBorder(BorderFactory.createTitledBorder(I18n.tr((String)"Filter", (Object[])new Object[0])));
                pnFilter.add((Component)this.rbAll, GBC.eop());
                pnFilter.add((Component)this.rbUseful, GBC.eop());
                this.add((Component)pnFilter, GBC.eol().insets(5, 0, 5, 5));
                JButton apply = new JButton(new AbstractAction(I18n.tr((String)"Apply", (Object[])new Object[0])){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        try {
                            this.apply();
                        }
                        catch (IOException ex) {
                            return;
                        }
                        update.actionPerformed(null);
                    }
                });
                this.add((Component)apply, GBC.eol().insets(5, 0, 5, 5));
            }
            this.add(Box.createVerticalGlue(), GBC.eol().fill());
        }

        public void apply() throws IOException {
            String filter = null;
            if (this.rbAll != null) {
                if (this.rbAll.isSelected()) {
                    filter = "all";
                } else if (this.rbUseful.isSelected()) {
                    filter = "useful";
                }
            }
            if (filter != null) {
                Config.getPref().put("plugin.roadsigns.preset.filter", filter);
            }
            RoadSignsPlugin.setSelectedPreset(this.presetsData.get(this.selectionBox.getSelectedIndex()));
        }
    }

    public static class FixedWidthPanel
    extends JPanel
    implements Scrollable {
        FixedWidthPanel() {
            super(new FlowLayout(0));
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, this.getParent().getWidth(), height);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.getWidth(), this.getPreferredHeight());
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return super.getPreferredSize();
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            int FRAC = 20;
            int inc = (orientation == 1 ? this.getParent().getHeight() : this.getParent().getWidth()) / 20;
            return Math.max(inc, 1);
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return orientation == 1 ? this.getParent().getHeight() : this.getParent().getWidth();
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        private int getPreferredHeight() {
            int prefH = 0;
            int num = this.getComponentCount();
            for (int i = 0; i < num; ++i) {
                Rectangle rect = this.getComponent(i).getBounds();
                int h = rect.y + rect.height;
                if (h <= prefH) continue;
                prefH = h;
            }
            return prefH += ((FlowLayout)this.getLayout()).getVgap();
        }
    }

    private class SignClickListener
    extends MouseAdapter {
        private Sign sign;

        SignClickListener(Sign sign) {
            this.sign = sign;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            RoadSignInputDialog.this.info.setText(this.longText());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RoadSignInputDialog.this.scrollInfo.getVerticalScrollBar().setValue(0);
                }
            });
            RoadSignInputDialog.this.sel.add(this.sign);
        }

        private String longText() {
            StringBuilder txt = new StringBuilder();
            txt.append(this.sign.long_name == null ? this.sign.name : this.sign.long_name);
            String ref = this.sign.getDefaultRef();
            if (ref != null) {
                txt.append("  <i><small>(" + ref + ")</small></i>");
            }
            if (this.sign.help != null) {
                txt.append("<p>");
                txt.append(this.sign.help);
                txt.append("</p>");
            }
            if (this.sign.wiki != null || this.sign.loc_wiki != null) {
                String link;
                String wikiPrefix = Config.getPref().get("plugin.roadsigns.wikiprefix", "https://wiki.openstreetmap.org/wiki/");
                txt.append("<p>");
                if (this.sign.loc_wiki != null) {
                    link = wikiPrefix + this.sign.loc_wiki;
                    txt.append("<a href=\"" + link + "\">" + link + "</a>");
                    txt.append("<br>");
                }
                if (this.sign.wiki != null && !this.sign.wiki.equals(this.sign.loc_wiki)) {
                    link = wikiPrefix + this.sign.wiki;
                    txt.append("<a href=\"" + link + "\">" + link + "</a>");
                }
                txt.append("</p>");
            }
            return txt.toString();
        }
    }

    public class PreviewTableModel
    extends AbstractTableModel {
        private List<String> keys = new ArrayList<String>();
        private List<String> values = new ArrayList<String>();
        int rows = 3;
        String[] header = new String[]{I18n.tr((String)"Key", (Object[])new Object[0]), I18n.tr((String)"Value", (Object[])new Object[0])};

        @Override
        public int getRowCount() {
            return this.keys.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return this.keys.get(rowIndex);
            }
            if (columnIndex == 1) {
                return this.values.get(rowIndex);
            }
            throw new IllegalArgumentException();
        }

        @Override
        public String getColumnName(int col) {
            return this.header[col];
        }

        public void update() {
            TreeMap<String, String> map = new TreeMap<String, String>();
            String traffic_sign = "";
            for (SignCombination signCombination : RoadSignInputDialog.this.sel.combos) {
                final HashMap<String, String> env = new HashMap<String, String>();
                String combo_traffic_sign = "";
                class TagEvaluater {
                    String key;
                    String default_value;
                    List<String> values = new ArrayList<String>();
                    List<String> conditions = new ArrayList<String>();

                    TagEvaluater(Sign.Tag t) {
                        this.key = t.key.evaluate(env);
                        this.default_value = t.value.evaluate(env);
                    }

                    public void append_value(String v) {
                        this.values.add(v);
                    }

                    public void condition(String c) {
                        this.conditions.add(c);
                    }

                    public Map<String, String> evaluate() {
                        String value = "";
                        if (this.values.isEmpty()) {
                            value = this.default_value;
                        } else {
                            String sep = "";
                            for (String v : this.values) {
                                value = value + sep + v;
                                sep = ";";
                            }
                        }
                        if (this.conditions.isEmpty()) {
                            return Collections.singletonMap(this.key, value);
                        }
                        HashMap<String, String> result = new HashMap<String, String>();
                        for (String c : this.conditions) {
                            result.put(this.key + ":" + c, value);
                        }
                        return result;
                    }
                }
                LinkedHashMap<String, TagEvaluater> tags = new LinkedHashMap<String, TagEvaluater>();
                for (SignWrapper sw : signCombination.signs) {
                    for (Map.Entry<String, String> entry : sw.paramValues.entrySet()) {
                        env.put(entry.getKey(), entry.getValue());
                    }
                    if (sw.sign.ref != null) {
                        sw.signRef = sw.sign.ref.evaluate(env);
                        if (combo_traffic_sign.length() != 0) {
                            combo_traffic_sign = combo_traffic_sign + ",";
                        }
                        combo_traffic_sign = sw.sign.traffic_sign_tag != null ? combo_traffic_sign + sw.sign.traffic_sign_tag.evaluate(env) : combo_traffic_sign + sw.signRef;
                    }
                    for (Sign.Tag t : sw.sign.tags) {
                        if (t.tag_ref != null) {
                            TagEvaluater te;
                            if (t.ident != null) {
                                env.put(t.ident + "_key", t.key.evaluate(env));
                                env.put(t.ident + "_value", t.value.evaluate(env));
                            }
                            if (t.append_value != null) {
                                te = (TagEvaluater)tags.get(t.tag_ref);
                                if (te == null) {
                                    System.err.println(String.format("warning: referenced tag with ident '%s' not found for appending tag %s.", t.tag_ref, t.toString()));
                                    continue;
                                }
                                te.append_value(t.append_value.evaluate(env));
                                continue;
                            }
                            if (t.condition != null) {
                                te = (TagEvaluater)tags.get(t.tag_ref);
                                if (te == null) {
                                    System.err.println(String.format("warning: referenced tag with ident '%s' not found for condition tag %s.", t.tag_ref, t.toString()));
                                    continue;
                                }
                                te.condition(t.condition.evaluate(env));
                                continue;
                            }
                            System.err.println(String.format("warning: found tag_ref but neither append_value nor condition for tag %s.", t.toString()));
                            continue;
                        }
                        if (t.ident != null) {
                            env.put(t.ident + "_key", t.key.evaluate(env));
                            env.put(t.ident + "_value", t.value.evaluate(env));
                            if (tags.get(t.ident) != null) {
                                System.err.println(String.format("warning: tag identifier %s for %s already in use. ", t.ident, t.toString()));
                            }
                            tags.put(t.ident, new TagEvaluater(t));
                            continue;
                        }
                        map.put(t.key.evaluate(env), t.value.evaluate(env));
                    }
                }
                for (TagEvaluater te : tags.values()) {
                    Map<String, String> result = te.evaluate();
                    map.putAll(result);
                }
                if (combo_traffic_sign.length() == 0) continue;
                if (traffic_sign.length() != 0) {
                    traffic_sign = traffic_sign + ";";
                }
                traffic_sign = traffic_sign + combo_traffic_sign;
            }
            if (RoadSignInputDialog.this.addTrafficSignTag.isSelected()) {
                map.put("traffic_sign", traffic_sign);
            }
            this.keys.clear();
            this.values.clear();
            for (Map.Entry entry : map.entrySet()) {
                if (((String)entry.getKey()).isEmpty() || ((String)entry.getValue()).isEmpty()) continue;
                this.keys.add((String)entry.getKey());
                this.values.add((String)entry.getValue());
            }
            this.fireTableDataChanged();
        }
    }

    public class SignWrapper {
        Sign sign;
        JLabel signIcon;
        String signRef;
        JPanel paramsPanel;
        Map<String, String> paramValues = new HashMap<String, String>();

        SignWrapper(Sign sign) {
            this.sign = sign;
            for (Sign.SignParameter p : this.sign.params) {
                this.paramValues.put(p.ident, p.getDefault());
            }
        }

        public String toString() {
            return this.sign.toString();
        }

        public JLabel getSignIcon() {
            if (this.signIcon != null) {
                return this.signIcon;
            }
            this.signIcon = new JLabel(this.sign.getIcon());
            this.signIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    RoadSignInputDialog.this.sel.remove(SignWrapper.this);
                }
            });
            return this.signIcon;
        }

        public JPanel getParamsPanel() {
            if (this.paramsPanel != null) {
                return this.paramsPanel;
            }
            this.paramsPanel = new JPanel(new GridBagLayout());
            int i = 0;
            for (final Sign.SignParameter p : this.sign.params) {
                JPanel pnlInput = new JPanel(new FlowLayout(0, 0, 0));
                switch (p.input) {
                    case COMBO: 
                    case TEXTFIELD: {
                        final JTextField tf = p.fieldWidth != null ? new JTextField(p.getDefault(), p.fieldWidth) : new JTextField(p.getDefault());
                        class TFDocumentListener
                        implements DocumentListener {
                            TFDocumentListener() {
                            }

                            @Override
                            public void insertUpdate(DocumentEvent e) {
                                this.update();
                            }

                            @Override
                            public void removeUpdate(DocumentEvent e) {
                                this.update();
                            }

                            @Override
                            public void changedUpdate(DocumentEvent e) {
                                this.update();
                            }

                            public void update() {
                                SignWrapper.this.paramValues.put(p.ident, tf.getText());
                                RoadSignInputDialog.this.previewModel.update();
                            }
                        }
                        TFDocumentListener listener = new TFDocumentListener();
                        tf.getDocument().addDocumentListener(listener);
                        JLabel lblPrefix = new JLabel(p.getPrefix());
                        JLabel lblSuffix = new JLabel(p.getSuffix());
                        pnlInput.add(lblPrefix);
                        pnlInput.add(tf);
                        pnlInput.add(lblSuffix);
                        break;
                    }
                    default: {
                        throw new RuntimeException();
                    }
                }
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridy = i++;
                gbc.anchor = 17;
                this.paramsPanel.add((Component)pnlInput, gbc);
            }
            if (i > 0) {
                this.paramsPanel.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 0));
            }
            return this.paramsPanel;
        }
    }

    public class SignCombination {
        public LinkedList<SignWrapper> signs = new LinkedList();

        SignCombination() {
        }

        public void updatePanel(JPanel panel) {
            panel.removeAll();
            panel.setLayout(new GridBagLayout());
            Border etched = BorderFactory.createEtchedBorder(0);
            Border empty = BorderFactory.createEmptyBorder(3, 3, 3, 3);
            panel.setBorder(BorderFactory.createCompoundBorder(etched, empty));
            int i = 0;
            for (SignWrapper sw : this.signs) {
                GridBagConstraints gbc = new GridBagConstraints();
                gbc.gridx = 0;
                gbc.gridy = i++;
                gbc.anchor = 11;
                panel.add((Component)sw.getSignIcon(), gbc);
                gbc.gridx = 1;
                gbc.anchor = 17;
                panel.add((Component)sw.getParamsPanel(), gbc);
            }
        }

        public void remove(int index) {
            this.signs.remove(index);
        }

        public void add(Sign sign) {
            if (!this.signs.isEmpty() && !sign.isSupplementing) {
                throw new IllegalArgumentException("any sign but the first must be a supplement sign");
            }
            SignWrapper signWrp = new SignWrapper(sign);
            this.signs.add(signWrp);
        }
    }

    public class SignSelection {
        private final LinkedList<SignCombination> combos = new LinkedList();

        public void remove(SignCombination sc) {
            int i = this.findIndex(sc);
            this.combos.remove(i);
            RoadSignInputDialog.this.previewModel.update();
            this.updatePanel(RoadSignInputDialog.this.pnlSignSelection);
        }

        public void remove(SignWrapper sw) {
            Pair<Integer, Integer> tmp = this.findIndex(sw);
            int i = (Integer)tmp.a;
            int j = (Integer)tmp.b;
            if (j == 0) {
                this.combos.remove(i);
                RoadSignInputDialog.this.previewModel.update();
                RoadSignInputDialog.this.updateSelectableSignsEnabledState();
                this.updatePanel(RoadSignInputDialog.this.pnlSignSelection);
            } else {
                this.combos.get(i).remove(j);
                RoadSignInputDialog.this.previewModel.update();
                RoadSignInputDialog.this.updateSelectableSignsEnabledState();
                this.updatePanel(RoadSignInputDialog.this.pnlSignSelection);
            }
        }

        public void add(Sign sAdd) {
            if (!sAdd.isSupplementing || this.combos.isEmpty()) {
                SignCombination combo = new SignCombination();
                this.combos.add(combo);
                combo.add(sAdd);
                RoadSignInputDialog.this.previewModel.update();
                RoadSignInputDialog.this.updateSelectableSignsEnabledState();
                this.updatePanel(RoadSignInputDialog.this.pnlSignSelection);
            } else {
                SignCombination last = this.combos.getLast();
                last.add(sAdd);
                RoadSignInputDialog.this.previewModel.update();
                this.updatePanel(RoadSignInputDialog.this.pnlSignSelection);
            }
        }

        private int findIndex(SignCombination scFind) {
            int i = 0;
            for (SignCombination sc : this.combos) {
                if (sc == scFind) {
                    return i;
                }
                ++i;
            }
            throw new AssertionError((Object)"Could not find sign combination.");
        }

        private Pair<Integer, Integer> findIndex(SignWrapper swFind) {
            int selIdx = 0;
            for (SignCombination sc : this.combos) {
                int combIdx = 0;
                for (SignWrapper sw : sc.signs) {
                    if (swFind == sw) {
                        return new Pair((Object)selIdx, (Object)combIdx);
                    }
                    ++combIdx;
                }
                ++selIdx;
            }
            throw new AssertionError((Object)"Could not find sign");
        }

        public void updatePanel(JPanel panel) {
            panel.removeAll();
            panel.setLayout(new GridBagLayout());
            GridBagConstraints gbc = new GridBagConstraints();
            gbc.anchor = 18;
            gbc.gridx = 0;
            gbc.gridy = 0;
            gbc.weightx = 0.0;
            gbc.weighty = 1.0;
            gbc.insets = new Insets(10, 10, 0, 10);
            for (SignCombination sc : this.combos) {
                JPanel pnlCombo = new JPanel(new GridBagLayout());
                sc.updatePanel(pnlCombo);
                panel.add((Component)pnlCombo, gbc);
                ++gbc.gridx;
                gbc.insets = new Insets(10, 0, 0, 10);
            }
            gbc.weightx = 1.0;
            panel.add((Component)new JLabel(""), gbc);
            panel.revalidate();
            panel.repaint();
        }
    }
}

