/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.gpsblam;

import java.awt.Point;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.data.projection.Projecting;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.ProjectionRegistry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.layer.GpxLayer;
import org.openstreetmap.josm.gui.layer.Layer;

class GPSBlamInputData
extends LinkedList<CachedLatLon> {
    private final Collection<Calendar> datesSeen = new HashSet<Calendar>();

    public int getNDays() {
        return this.datesSeen.size();
    }

    GPSBlamInputData(Point p1, Point p2, int radius) {
        List layers = MainApplication.getLayerManager().getLayers();
        Projection projection = ProjectionRegistry.getProjection();
        for (Layer l : layers) {
            if (!l.isVisible() || !(l instanceof GpxLayer)) continue;
            for (GpxTrack track : ((GpxLayer)l).data.tracks) {
                for (IGpxTrackSegment segment : track.getSegments()) {
                    for (WayPoint wayPoint : segment.getWayPoints()) {
                        double distsq;
                        double dirY;
                        if (p2.equals(p1)) {
                            CachedLatLon cll = new CachedLatLon(wayPoint.getCoor());
                            Point p = MainApplication.getMap().mapView.getPoint(cll.getEastNorth((Projecting)projection));
                            if (!(p.distance(p1) < (double)radius)) continue;
                            this.add(cll, wayPoint);
                            continue;
                        }
                        double length = Math.sqrt((p2.x - p1.x) * (p2.x - p1.x) + (p2.y - p1.y) * (p2.y - p1.y)) + 1.0E-5;
                        double dirX = (double)(p2.x - p1.x) / length;
                        double perpdirX = dirY = (double)(p2.y - p1.y) / length;
                        double perpdirY = -dirX;
                        CachedLatLon cll = new CachedLatLon(wayPoint.getCoor());
                        Point p = MainApplication.getMap().mapView.getPoint(cll.getEastNorth((Projecting)projection));
                        double pX = p.x - p1.x;
                        double pY = p.y - p1.y;
                        double pPar = pX * dirX + pY * dirY;
                        double pPerp = pX * perpdirX + pY * perpdirY;
                        double pardist = 0.0;
                        if (pPar < 0.0) {
                            pardist = -pPar;
                        } else if (pPar > length) {
                            pardist = pPar - length;
                        }
                        if (!((distsq = pardist * pardist + pPerp * pPerp) < (double)(radius * radius))) continue;
                        this.add(cll, wayPoint);
                    }
                }
            }
        }
    }

    private void add(CachedLatLon cll, WayPoint wayPoint) {
        this.add(cll);
        GregorianCalendar day = new GregorianCalendar();
        day.setTimeInMillis(wayPoint.getTimeInMillis());
        day.set(11, 0);
        day.set(12, 0);
        day.set(13, 0);
        this.datesSeen.add(day);
    }
}

