/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.editgpx.data;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimeZone;
import org.openstreetmap.josm.data.gpx.GpxTrack;
import org.openstreetmap.josm.data.gpx.IGpxTrackSegment;
import org.openstreetmap.josm.data.gpx.WayPoint;
import org.openstreetmap.josm.plugins.editgpx.data.EditGpxTrackSegment;

public class EditGpxTrack {
    private final List<EditGpxTrackSegment> segments = new ArrayList<EditGpxTrackSegment>();
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private boolean isDeleted;

    public EditGpxTrack(GpxTrack track) {
        this.attributes.putAll(track.getAttributes());
        for (IGpxTrackSegment segment : track.getSegments()) {
            this.segments.add(new EditGpxTrackSegment(segment));
        }
    }

    public List<EditGpxTrackSegment> getSegments() {
        return this.segments;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public GpxTrack createGpxTrack(boolean anonTime, double minTime) {
        ArrayList<List<WayPoint>> wayPoints = new ArrayList<List<WayPoint>>();
        SimpleDateFormat iso8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        TimeZone utc = TimeZone.getTimeZone("UTC");
        iso8601.setTimeZone(utc);
        for (EditGpxTrackSegment segment : this.segments) {
            List<WayPoint> points;
            if (segment.isDeleted() || (points = segment.getNonDeletedWaypoints()).isEmpty()) continue;
            if (anonTime) {
                for (WayPoint w : points) {
                    double t = w.getTime() - minTime;
                    w.setTimeInMillis((long)(t * 1000.0));
                    assert (w.getTime() == t);
                    if (!w.attr.containsKey("name")) continue;
                    w.attr.put("name", "anon");
                }
            }
            wayPoints.add(points);
        }
        if (anonTime && this.attributes.containsKey("name")) {
            this.attributes.put("name", "anon");
        }
        return new GpxTrack(wayPoints, this.attributes);
    }

    public void setDeleted(boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public double minNonDeletedTime() {
        boolean foundOne = false;
        double minTime = 0.0;
        for (EditGpxTrackSegment segment : this.segments) {
            if (segment.isDeleted()) continue;
            try {
                double t = segment.minNonDeletedTime();
                if (!foundOne || t < minTime) {
                    minTime = t;
                }
                foundOne = true;
            }
            catch (NoSuchElementException e) {}
        }
        if (!foundOne) {
            throw new NoSuchElementException();
        }
        return minTime;
    }
}

