/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.streetside;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.apache.commons.jcs.access.CacheAccess;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.plugins.streetside.StreetsideAbstractImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideDataListener;
import org.openstreetmap.josm.plugins.streetside.StreetsideImage;
import org.openstreetmap.josm.plugins.streetside.StreetsideLayer;
import org.openstreetmap.josm.plugins.streetside.StreetsidePlugin;
import org.openstreetmap.josm.plugins.streetside.StreetsideSequence;
import org.openstreetmap.josm.plugins.streetside.cache.CacheUtils;
import org.openstreetmap.josm.plugins.streetside.cache.Caches;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideMainDialog;
import org.openstreetmap.josm.plugins.streetside.gui.StreetsideViewerDialog;
import org.openstreetmap.josm.plugins.streetside.gui.imageinfo.ImageInfoPanel;
import org.openstreetmap.josm.plugins.streetside.utils.StreetsideProperties;

public class StreetsideData {
    private final Set<StreetsideAbstractImage> images = ConcurrentHashMap.newKeySet();
    private StreetsideAbstractImage selectedImage = null;
    private StreetsideAbstractImage highlightedImage;
    private final Set<StreetsideAbstractImage> multiSelectedImages = ConcurrentHashMap.newKeySet();
    private final List<StreetsideDataListener> listeners = new CopyOnWriteArrayList<StreetsideDataListener>();
    private final List<Bounds> bounds = new CopyOnWriteArrayList<Bounds>();

    protected StreetsideData() {
        Arrays.stream(StreetsidePlugin.getStreetsideDataListeners()).forEach(this::addListener);
        this.addListener(StreetsideViewerDialog.getInstance().getStreetsideViewerPanel());
        this.addListener(StreetsideMainDialog.getInstance());
        this.addListener(ImageInfoPanel.getInstance());
    }

    public void add(StreetsideAbstractImage image) {
        this.add(image, true);
    }

    public void add(StreetsideAbstractImage image, boolean update) {
        this.images.add(image);
        if (update) {
            StreetsideLayer.invalidateInstance();
        }
        this.fireImagesAdded();
    }

    public void addAll(Collection<? extends StreetsideAbstractImage> images) {
        this.addAll(images, true);
    }

    public void addAll(Collection<? extends StreetsideAbstractImage> newImages, boolean update) {
        this.images.addAll(newImages);
        if (update) {
            StreetsideLayer.invalidateInstance();
        }
        this.fireImagesAdded();
    }

    public final void addListener(StreetsideDataListener lis) {
        this.listeners.add(lis);
    }

    public void addMultiSelectedImage(StreetsideAbstractImage image) {
        if (!this.multiSelectedImages.contains(image)) {
            if (this.getSelectedImage() == null) {
                this.setSelectedImage(image);
            } else {
                this.multiSelectedImages.add(image);
            }
        }
        StreetsideLayer.invalidateInstance();
    }

    public void addMultiSelectedImage(Collection<StreetsideAbstractImage> images) {
        images.stream().filter(image -> !this.multiSelectedImages.contains(image)).forEach(image -> {
            if (this.getSelectedImage() == null) {
                this.setSelectedImage((StreetsideAbstractImage)image);
            } else {
                this.multiSelectedImages.add((StreetsideAbstractImage)image);
            }
        });
        StreetsideLayer.invalidateInstance();
    }

    public List<Bounds> getBounds() {
        return this.bounds;
    }

    public void removeListener(StreetsideDataListener lis) {
        this.listeners.remove(lis);
    }

    public void setHighlightedImage(StreetsideAbstractImage image) {
        this.highlightedImage = image;
    }

    public StreetsideAbstractImage getHighlightedImage() {
        return this.highlightedImage;
    }

    public Set<StreetsideAbstractImage> getImages() {
        return this.images;
    }

    public Set<StreetsideSequence> getSequences() {
        return this.images.stream().map(StreetsideAbstractImage::getSequence).collect(Collectors.toSet());
    }

    public StreetsideAbstractImage getSelectedImage() {
        return this.selectedImage;
    }

    private void fireImagesAdded() {
        this.listeners.stream().filter(Objects::nonNull).forEach(StreetsideDataListener::imagesAdded);
    }

    public void selectNext() {
        this.selectNext(StreetsideProperties.MOVE_TO_IMG.get());
    }

    public void selectNext(boolean moveToPicture) {
        StreetsideAbstractImage tempImage = this.selectedImage;
        if (this.selectedImage != null && this.selectedImage.getSequence() != null) {
            while (tempImage.next() != null) {
                if (!(tempImage = tempImage.next()).isVisible()) continue;
                this.setSelectedImage(tempImage, moveToPicture);
                break;
            }
        }
    }

    public void selectPrevious() {
        this.selectPrevious(StreetsideProperties.MOVE_TO_IMG.get());
    }

    public void selectPrevious(boolean moveToPicture) {
        if (this.selectedImage != null && this.selectedImage.getSequence() != null) {
            StreetsideAbstractImage tempImage = this.selectedImage;
            while (tempImage.previous() != null) {
                if (!(tempImage = tempImage.previous()).isVisible()) continue;
                this.setSelectedImage(tempImage, moveToPicture);
                break;
            }
        }
    }

    public void setSelectedImage(StreetsideAbstractImage image) {
        this.setSelectedImage(image, false);
    }

    public void setSelectedImage(StreetsideAbstractImage image, boolean zoom) {
        StreetsideAbstractImage oldImage = this.selectedImage;
        this.selectedImage = image;
        this.multiSelectedImages.clear();
        MapView mv = StreetsidePlugin.getMapView();
        if (image != null) {
            this.multiSelectedImages.add(image);
            if (mv != null && image instanceof StreetsideImage) {
                StreetsideImage streetsideImage = (StreetsideImage)image;
                StreetsideData.downloadSurroundingImages(streetsideImage);
            }
        }
        if (mv != null && zoom && this.selectedImage != null) {
            mv.zoomTo(this.selectedImage.getMovingLatLon());
        }
        this.fireSelectedImageChanged(oldImage, this.selectedImage);
        StreetsideLayer.invalidateInstance();
    }

    private static void downloadSurroundingImages(StreetsideImage streetsideImage) {
        MainApplication.worker.execute(() -> {
            int prefetchCount = StreetsideProperties.PRE_FETCH_IMAGE_COUNT.get();
            CacheAccess<String, BufferedImageCacheEntry> imageCache = Caches.ImageCache.getInstance().getCache();
            StreetsideAbstractImage nextImage = streetsideImage.next();
            StreetsideAbstractImage prevImage = streetsideImage.previous();
            for (int i = 0; i < prefetchCount; ++i) {
                if (nextImage != null) {
                    if (nextImage instanceof StreetsideImage && imageCache.get((Object)((StreetsideImage)nextImage).getId()) == null) {
                        CacheUtils.downloadPicture((StreetsideImage)nextImage);
                    }
                    nextImage = nextImage.next();
                }
                if (prevImage == null) continue;
                if (prevImage instanceof StreetsideImage && imageCache.get((Object)((StreetsideImage)prevImage).getId()) == null) {
                    CacheUtils.downloadPicture((StreetsideImage)prevImage);
                }
                prevImage = prevImage.previous();
            }
        });
    }

    public static void downloadSurroundingCubemaps(StreetsideImage streetsideImage) {
        MainApplication.worker.execute(() -> {
            int prefetchCount = StreetsideProperties.PRE_FETCH_IMAGE_COUNT.get();
            CacheAccess<String, BufferedImageCacheEntry> imageCache = Caches.ImageCache.getInstance().getCache();
            StreetsideAbstractImage nextImage = streetsideImage.next();
            StreetsideAbstractImage prevImage = streetsideImage.previous();
            for (int i = 0; i < prefetchCount; ++i) {
                if (nextImage != null) {
                    if (nextImage instanceof StreetsideImage && imageCache.get((Object)((StreetsideImage)nextImage).getId()) == null) {
                        CacheUtils.downloadCubemap((StreetsideImage)nextImage);
                    }
                    nextImage = nextImage.next();
                }
                if (prevImage == null) continue;
                if (prevImage instanceof StreetsideImage && imageCache.get((Object)((StreetsideImage)prevImage).getId()) == null) {
                    CacheUtils.downloadCubemap((StreetsideImage)prevImage);
                }
                prevImage = prevImage.previous();
            }
        });
    }

    private void fireSelectedImageChanged(StreetsideAbstractImage oldImage, StreetsideAbstractImage newImage) {
        this.listeners.stream().filter(Objects::nonNull).forEach(lis -> lis.selectedImageChanged(oldImage, newImage));
    }

    public Set<StreetsideAbstractImage> getMultiSelectedImages() {
        return this.multiSelectedImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImages(Collection<StreetsideAbstractImage> newImages) {
        StreetsideData streetsideData = this;
        synchronized (streetsideData) {
            this.images.clear();
            this.images.addAll(newImages);
        }
    }
}

