/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.fr.cadastre.download;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Stream;
import org.openstreetmap.josm.actions.downloadtasks.DownloadOsmTask;
import org.openstreetmap.josm.actions.downloadtasks.DownloadParams;
import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DownloadPolicy;
import org.openstreetmap.josm.data.osm.UploadPolicy;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.OsmServerReader;
import org.openstreetmap.josm.plugins.fr.cadastre.api.CadastreAPI;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreDownloadData;
import org.openstreetmap.josm.plugins.fr.cadastre.download.CadastreServerReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public class CadastreDownloadTask
extends DownloadOsmTask {
    private static final String CADASTRE_URL = "https://cadastre.data.gouv.fr/data/dgfip-pci-vecteur/latest/edigeo/feuilles";
    private final CadastreDownloadData data;

    public CadastreDownloadTask() {
        this(new CadastreDownloadData(true, true, true, true, true, true, true, true, true), true);
    }

    public CadastreDownloadTask(CadastreDownloadData data, boolean zoomToData) {
        this.data = Objects.requireNonNull(data);
        this.setZoomAfterDownload(zoomToData);
    }

    public Future<?> download(DownloadParams settings, Bounds downloadArea, ProgressMonitor progressMonitor) {
        ArrayList tasks = new ArrayList();
        try {
            for (String id : CadastreAPI.getSheets(downloadArea)) {
                String url = String.join((CharSequence)"/", CADASTRE_URL, id.substring(0, 2), id.substring(0, 5), "edigeo-" + id + ".tar.bz2");
                tasks.add(MainApplication.worker.submit((Runnable)((Object)new InternalDownloadTask(settings, url, progressMonitor, this.zoomAfterDownload))));
            }
        }
        catch (IOException e) {
            Logging.error((Throwable)e);
            new Notification(Utils.escapeReservedCharactersHTML((String)Utils.getRootCause((Throwable)e).getMessage())).setIcon(0).show();
        }
        return MainApplication.worker.submit(() -> {
            for (Future f : tasks) {
                try {
                    f.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    Logging.error((Throwable)e);
                }
            }
        });
    }

    public Future<?> loadUrl(DownloadParams settings, String url, ProgressMonitor progressMonitor) {
        this.downloadTask = new InternalDownloadTask(settings, url, progressMonitor, this.zoomAfterDownload);
        this.currentBounds = null;
        return MainApplication.worker.submit((Runnable)this.downloadTask);
    }

    public String[] getPatterns() {
        return new String[]{"https?://.*edigeo.*.tar.bz2"};
    }

    public String getTitle() {
        return I18n.tr((String)"Download cadastre data", (Object[])new Object[0]);
    }

    class InternalDownloadTask
    extends DownloadOsmTask.DownloadTask {
        private final String url;

        InternalDownloadTask(DownloadParams settings, String url, ProgressMonitor progressMonitor, boolean zoom) {
            super((DownloadOsmTask)CadastreDownloadTask.this, settings, (OsmServerReader)new CadastreServerReader(url, CadastreDownloadTask.this.data), progressMonitor, zoom);
            this.url = url;
        }

        protected CadastreDataLayer createNewLayer(DataSet dataset, Optional<String> layerName) {
            String realLayerName;
            String string = realLayerName = layerName.isPresent() ? layerName.get() : this.url.substring(this.url.lastIndexOf(47) + 1);
            if (realLayerName == null || realLayerName.isEmpty()) {
                realLayerName = this.settings.getLayerName();
            }
            if (realLayerName == null || realLayerName.isEmpty()) {
                realLayerName = OsmDataLayer.createNewName();
            }
            this.dataSet.setDownloadPolicy(DownloadPolicy.BLOCKED);
            this.dataSet.setUploadPolicy(UploadPolicy.BLOCKED);
            return new CadastreDataLayer(this.dataSet, realLayerName, null);
        }

        private Stream<CadastreDataLayer> getCadastreDataLayers() {
            return MainApplication.getLayerManager().getLayersOfType(CadastreDataLayer.class).stream();
        }

        protected long getNumModifiableDataLayers() {
            return this.getCadastreDataLayers().count();
        }

        protected CadastreDataLayer getFirstModifiableDataLayer() {
            return this.getCadastreDataLayers().findFirst().orElse(null);
        }
    }

    static class CadastreDataLayer
    extends OsmDataLayer {
        CadastreDataLayer(DataSet data, String name, File associatedFile) {
            super(data, name, associatedFile);
        }
    }
}

