/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.record.ArrayRecord;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BlankRecord;
import org.apache.poi.hssf.record.BoolErrRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CRNCountRecord;
import org.apache.poi.hssf.record.CRNRecord;
import org.apache.poi.hssf.record.CalcCountRecord;
import org.apache.poi.hssf.record.CalcModeRecord;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.ContinueRecord;
import org.apache.poi.hssf.record.DBCellRecord;
import org.apache.poi.hssf.record.DVALRecord;
import org.apache.poi.hssf.record.DVRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.DeltaRecord;
import org.apache.poi.hssf.record.DimensionsRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.ExternalNameRecord;
import org.apache.poi.hssf.record.FeatHdrRecord;
import org.apache.poi.hssf.record.FeatRecord;
import org.apache.poi.hssf.record.FilePassRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.FormulaRecord;
import org.apache.poi.hssf.record.GridsetRecord;
import org.apache.poi.hssf.record.GutsRecord;
import org.apache.poi.hssf.record.HorizontalPageBreakRecord;
import org.apache.poi.hssf.record.HyperlinkRecord;
import org.apache.poi.hssf.record.IndexRecord;
import org.apache.poi.hssf.record.IterationRecord;
import org.apache.poi.hssf.record.LabelRecord;
import org.apache.poi.hssf.record.LabelSSTRecord;
import org.apache.poi.hssf.record.MergeCellsRecord;
import org.apache.poi.hssf.record.MulBlankRecord;
import org.apache.poi.hssf.record.MulRKRecord;
import org.apache.poi.hssf.record.NameCommentRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.NumberRecord;
import org.apache.poi.hssf.record.ObjRecord;
import org.apache.poi.hssf.record.PaneRecord;
import org.apache.poi.hssf.record.PrecisionRecord;
import org.apache.poi.hssf.record.RKRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFactoryInputStream;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.RefModeRecord;
import org.apache.poi.hssf.record.RowRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.SaveRecalcRecord;
import org.apache.poi.hssf.record.SelectionRecord;
import org.apache.poi.hssf.record.SharedFormulaRecord;
import org.apache.poi.hssf.record.StringRecord;
import org.apache.poi.hssf.record.SupBookRecord;
import org.apache.poi.hssf.record.TabIdRecord;
import org.apache.poi.hssf.record.TableRecord;
import org.apache.poi.hssf.record.TextObjectRecord;
import org.apache.poi.hssf.record.UncalcedRecord;
import org.apache.poi.hssf.record.UnknownRecord;
import org.apache.poi.hssf.record.VerticalPageBreakRecord;
import org.apache.poi.hssf.record.WSBoolRecord;
import org.apache.poi.hssf.record.WindowOneRecord;
import org.apache.poi.hssf.record.WindowTwoRecord;

public final class RecordFactory {
    private static final int NUM_RECORDS = 512;
    private static final Class<?>[] CONSTRUCTOR_ARGS = new Class[]{RecordInputStream.class};
    private static final Class<? extends Record>[] recordClasses = new Class[]{ArrayRecord.class, BlankRecord.class, BOFRecord.class, BoolErrRecord.class, BoundSheetRecord.class, CalcCountRecord.class, CalcModeRecord.class, ColumnInfoRecord.class, ContinueRecord.class, CRNCountRecord.class, CRNRecord.class, DateWindow1904Record.class, DBCellRecord.class, DeltaRecord.class, DimensionsRecord.class, DVALRecord.class, DVRecord.class, EOFRecord.class, ExtendedFormatRecord.class, ExternalNameRecord.class, ExternSheetRecord.class, ExtSSTRecord.class, FeatRecord.class, FeatHdrRecord.class, FilePassRecord.class, FormatRecord.class, FormulaRecord.class, GridsetRecord.class, GutsRecord.class, HorizontalPageBreakRecord.class, HyperlinkRecord.class, IndexRecord.class, IterationRecord.class, LabelRecord.class, LabelSSTRecord.class, MergeCellsRecord.class, MulBlankRecord.class, MulRKRecord.class, NameRecord.class, NameCommentRecord.class, NumberRecord.class, ObjRecord.class, PaneRecord.class, PrecisionRecord.class, RefModeRecord.class, RKRecord.class, RowRecord.class, SaveRecalcRecord.class, SelectionRecord.class, SharedFormulaRecord.class, SSTRecord.class, StringRecord.class, SupBookRecord.class, TabIdRecord.class, TableRecord.class, TextObjectRecord.class, UncalcedRecord.class, VerticalPageBreakRecord.class, WindowOneRecord.class, WindowTwoRecord.class, WSBoolRecord.class};
    private static final Map<Integer, I_RecordCreator> _recordCreatorsById = RecordFactory.recordsToMap(recordClasses);

    public static Record[] createRecord(RecordInputStream recordInputStream) {
        Record record = RecordFactory.createSingleRecord(recordInputStream);
        if (record instanceof DBCellRecord) {
            return new Record[]{null};
        }
        if (record instanceof RKRecord) {
            return new Record[]{RecordFactory.convertToNumberRecord((RKRecord)record)};
        }
        if (record instanceof MulRKRecord) {
            return RecordFactory.convertRKRecords((MulRKRecord)record);
        }
        return new Record[]{record};
    }

    public static Record createSingleRecord(RecordInputStream recordInputStream) {
        I_RecordCreator i_RecordCreator = _recordCreatorsById.get(recordInputStream.getSid());
        if (i_RecordCreator == null) {
            return new UnknownRecord(recordInputStream);
        }
        return i_RecordCreator.create(recordInputStream);
    }

    public static NumberRecord convertToNumberRecord(RKRecord rKRecord) {
        NumberRecord numberRecord = new NumberRecord();
        numberRecord.setColumn(rKRecord.getColumn());
        numberRecord.setRow(rKRecord.getRow());
        numberRecord.setXFIndex(rKRecord.getXFIndex());
        numberRecord.setValue(rKRecord.getRKNumber());
        return numberRecord;
    }

    public static NumberRecord[] convertRKRecords(MulRKRecord mulRKRecord) {
        NumberRecord[] numberRecordArray = new NumberRecord[mulRKRecord.getNumColumns()];
        for (int i = 0; i < mulRKRecord.getNumColumns(); ++i) {
            NumberRecord numberRecord = new NumberRecord();
            numberRecord.setColumn((short)(i + mulRKRecord.getFirstColumn()));
            numberRecord.setRow(mulRKRecord.getRow());
            numberRecord.setXFIndex(mulRKRecord.getXFAt(i));
            numberRecord.setValue(mulRKRecord.getRKNumberAt(i));
            numberRecordArray[i] = numberRecord;
        }
        return numberRecordArray;
    }

    private static Map<Integer, I_RecordCreator> recordsToMap(Class<? extends Record>[] classArray) {
        HashMap<Integer, I_RecordCreator> hashMap = new HashMap<Integer, I_RecordCreator>();
        HashSet<Class<? extends Record>> hashSet = new HashSet<Class<? extends Record>>(classArray.length * 3 / 2);
        for (int i = 0; i < classArray.length; ++i) {
            short s;
            Class<? extends Record> clazz = classArray[i];
            if (!Record.class.isAssignableFrom(clazz)) {
                throw new RuntimeException("Invalid record sub-class (" + clazz.getName() + ")");
            }
            if (Modifier.isAbstract(clazz.getModifiers())) {
                throw new RuntimeException("Invalid record class (" + clazz.getName() + ") - must not be abstract");
            }
            if (!hashSet.add(clazz)) {
                throw new RuntimeException("duplicate record class (" + clazz.getName() + ")");
            }
            try {
                s = clazz.getField("sid").getShort(null);
            }
            catch (Exception exception) {
                throw new RecordFormatException("Unable to determine record types");
            }
            Integer n = s;
            if (hashMap.containsKey(n)) {
                Class<? extends Record> clazz2 = ((I_RecordCreator)hashMap.get(n)).getRecordClass();
                throw new RuntimeException("duplicate record sid 0x" + Integer.toHexString(s).toUpperCase() + " for classes (" + clazz.getName() + ") and (" + clazz2.getName() + ")");
            }
            hashMap.put(n, RecordFactory.getRecordCreator(clazz));
        }
        return hashMap;
    }

    private static I_RecordCreator getRecordCreator(Class<? extends Record> clazz) {
        try {
            Constructor<? extends Record> constructor = clazz.getConstructor(CONSTRUCTOR_ARGS);
            return new ReflectionConstructorRecordCreator(constructor);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method method = clazz.getDeclaredMethod("create", CONSTRUCTOR_ARGS);
                return new ReflectionMethodRecordCreator(method);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                throw new RuntimeException("Failed to find constructor or create method for (" + clazz.getName() + ").");
            }
        }
    }

    public static List<Record> createRecords(InputStream inputStream) throws RecordFormatException {
        Record record;
        ArrayList<Record> arrayList = new ArrayList<Record>(512);
        RecordFactoryInputStream recordFactoryInputStream = new RecordFactoryInputStream(inputStream, true);
        while ((record = recordFactoryInputStream.nextRecord()) != null) {
            arrayList.add(record);
        }
        return arrayList;
    }

    private static final class ReflectionMethodRecordCreator
    implements I_RecordCreator {
        private final Method _m;

        public ReflectionMethodRecordCreator(Method method) {
            this._m = method;
        }

        @Override
        public Record create(RecordInputStream recordInputStream) {
            Object[] objectArray = new Object[]{recordInputStream};
            try {
                return (Record)this._m.invoke(null, objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RecordFormatException("Unable to construct record instance", invocationTargetException.getTargetException());
            }
        }

        @Override
        public Class<? extends Record> getRecordClass() {
            return this._m.getDeclaringClass();
        }
    }

    private static final class ReflectionConstructorRecordCreator
    implements I_RecordCreator {
        private final Constructor<? extends Record> _c;

        public ReflectionConstructorRecordCreator(Constructor<? extends Record> constructor) {
            this._c = constructor;
        }

        @Override
        public Record create(RecordInputStream recordInputStream) {
            Object[] objectArray = new Object[]{recordInputStream};
            try {
                return this._c.newInstance(objectArray);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new RuntimeException(illegalArgumentException);
            }
            catch (InstantiationException instantiationException) {
                throw new RuntimeException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new RuntimeException(illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RecordFormatException("Unable to construct record instance", invocationTargetException.getTargetException());
            }
        }

        @Override
        public Class<? extends Record> getRecordClass() {
            return this._c.getDeclaringClass();
        }
    }

    private static interface I_RecordCreator {
        public Record create(RecordInputStream var1);

        public Class<? extends Record> getRecordClass();
    }
}

