/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.utilsplugin2.selection;

import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.HashSet;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

public class SelectWayNodesAction
extends JosmAction {
    public SelectWayNodesAction() {
        super(I18n.tr((String)"Select Way Nodes", (Object[])new Object[0]), "selectwaynodes", I18n.tr((String)"Select all nodes of a selected way.", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:selectwaynodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Select Way Nodes", (Object[])new Object[0])}), (int)78, (int)5009), true);
        this.putValue("help", HelpUtil.ht((String)"/Action/SelectWayNodes"));
    }

    public void actionPerformed(ActionEvent e) {
        HashSet<Node> selectedNodes = new HashSet<Node>();
        for (OsmPrimitive p : this.getLayerManager().getEditDataSet().getSelected()) {
            if (p instanceof Way) {
                Way w = (Way)p;
                if (!w.isUsable() || w.getNodesCount() <= 1) continue;
                for (Node n : w.getNodes()) {
                    if (n.isDisabled()) continue;
                    selectedNodes.add(n);
                }
                continue;
            }
            if (!(p instanceof Node)) continue;
            selectedNodes.add((Node)p);
        }
        this.getLayerManager().getEditDataSet().setSelected(selectedNodes);
    }

    protected void updateEnabledState() {
        this.updateEnabledStateOnCurrentSelection();
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

