/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory.epsg;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.DeferredAuthorityFactory;
import org.geotools.referencing.factory.FactoryNotFoundException;
import org.geotools.referencing.factory.PropertyCoordinateOperationAuthorityFactory;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;

public class CoordinateOperationFactoryUsingWKT
extends DeferredAuthorityFactory
implements CoordinateOperationAuthorityFactory {
    protected Citation authority;
    public static final String FILENAME = "epsg_operations.properties";
    public static final int PRIORITY = 30;
    protected final ReferencingFactoryContainer factories;
    protected final String directory;
    protected CoordinateOperationAuthorityFactory fallbackAuthorityFactory = null;
    protected boolean fallbackAuthorityFactorySearched = false;

    public CoordinateOperationFactoryUsingWKT() {
        this((Hints)null, 30);
    }

    public CoordinateOperationFactoryUsingWKT(Hints userHints) {
        this(userHints, 30);
    }

    public CoordinateOperationFactoryUsingWKT(Hints userHints, int priority) {
        super(userHints, priority);
        this.factories = ReferencingFactoryContainer.instance(userHints);
        Object directoryHint = null;
        if (userHints != null && userHints.get(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY) != null) {
            directoryHint = userHints.get(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        } else if (Hints.getSystemDefault(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY) != null) {
            directoryHint = Hints.getSystemDefault(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY);
        }
        if (directoryHint != null) {
            this.directory = directoryHint.toString();
            this.hints.put(Hints.CRS_AUTHORITY_EXTRA_DIRECTORY, this.directory);
        } else {
            this.directory = null;
        }
    }

    @Override
    public synchronized Citation getAuthority() {
        if (this.authority == null) {
            this.authority = Citations.EPSG;
        }
        return this.authority;
    }

    @Override
    protected AbstractAuthorityFactory createBackingStore() throws FactoryException {
        try {
            URL url = this.getDefinitionsURL();
            if (url == null) {
                throw new FactoryNotFoundException(Errors.format(50, FILENAME));
            }
            Iterator<? extends Identifier> ids = this.getAuthority().getIdentifiers().iterator();
            String authority = ids.hasNext() ? ids.next().getCode() : "EPSG";
            LogRecord record = Loggings.format(Level.CONFIG, 49, url.getPath(), authority);
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
            return new PropertyCoordinateOperationAuthorityFactory(this.factories, this.getAuthority(), url);
        }
        catch (IOException exception) {
            throw new FactoryException(Errors.format(28, FILENAME), exception);
        }
    }

    protected URL getDefinitionsURL() {
        try {
            File file;
            if (this.directory != null && (file = new File(this.directory, FILENAME)).isFile()) {
                return file.toURI().toURL();
            }
        }
        catch (SecurityException exception) {
            Logging.unexpectedException(LOGGER, exception);
        }
        catch (MalformedURLException exception) {
            Logging.unexpectedException(LOGGER, exception);
        }
        return this.getClass().getResource(FILENAME);
    }

    @Override
    public Set<CoordinateOperation> createFromCoordinateReferenceSystemCodes(String sourceCRS, String targetCRS) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateOperationAuthorityFactory fallback;
        Set<CoordinateOperation> coordops = super.createFromCoordinateReferenceSystemCodes(sourceCRS, targetCRS);
        if (coordops.isEmpty() && (fallback = this.getFallbackAuthorityFactory()) != null) {
            coordops = fallback.createFromCoordinateReferenceSystemCodes(sourceCRS, targetCRS);
        }
        return coordops;
    }

    @Override
    public CoordinateOperation createCoordinateOperation(String code) throws NoSuchAuthorityCodeException, FactoryException {
        CoordinateOperationAuthorityFactory fallback;
        CoordinateOperation coordop = super.createCoordinateOperation(code);
        if (coordop == null && (fallback = this.getFallbackAuthorityFactory()) != null) {
            coordop = fallback.createCoordinateOperation(code);
        }
        return coordop;
    }

    protected CoordinateOperationAuthorityFactory getFallbackAuthorityFactory() throws NoSuchAuthorityCodeException, FactoryException {
        if (!this.fallbackAuthorityFactorySearched) {
            CoordinateOperationAuthorityFactory candidate = null;
            Hints h = new Hints();
            h.put(Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, Boolean.FALSE);
            h.put(Hints.FORCE_STANDARD_AXIS_DIRECTIONS, Boolean.FALSE);
            h.put(Hints.FORCE_STANDARD_AXIS_UNITS, Boolean.FALSE);
            Set<CoordinateOperationAuthorityFactory> factories = ReferencingFactoryFinder.getCoordinateOperationAuthorityFactories(h);
            Iterator<CoordinateOperationAuthorityFactory> it = factories.iterator();
            while (it.hasNext() && (candidate = it.next()) != this) {
            }
            while (it.hasNext()) {
                candidate = it.next();
                if (candidate instanceof CoordinateOperationFactoryUsingWKT || !candidate.getAuthority().getTitle().equals(this.getAuthority().getTitle())) continue;
                this.fallbackAuthorityFactory = candidate;
                break;
            }
            this.fallbackAuthorityFactorySearched = true;
        }
        return this.fallbackAuthorityFactory;
    }
}

