/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import com.sun.media.imageioimpl.common.PackageUtil;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader;
import java.io.IOException;
import java.util.Locale;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;

public class TIFFImageReaderSpi
extends ImageReaderSpi {
    private static final String[] names = new String[]{"tif", "TIF", "tiff", "TIFF", "btiff", "BTIFF"};
    private static final String[] suffixes = new String[]{"tif", "tiff", "tf8", "btf", "TIF", "TIFF", "TF8", "BTF"};
    private static final String[] MIMETypes = new String[]{"image/tiff"};
    private static final String readerClassName = "it.geosolutions.imageioimpl.plugins.tiff.TIFFImageReader";
    private static final String[] writerSpiNames = new String[]{"it.geosolutions.imageioimpl.plugins.tiff.TIFFImageWriterSpi"};
    private boolean registered = false;

    public TIFFImageReaderSpi() {
        super("ImageIO-Ext", "1.0", names, suffixes, MIMETypes, readerClassName, STANDARD_INPUT_TYPE, writerSpiNames, false, "com_sun_media_imageio_plugins_tiff_stream_1.0", "it.geosolutions.imageioimpl.plugins.tiff.TIFFStreamMetadataFormat", null, null, true, "it_geosolutions_imageioimpl_plugins_tiff_image_1.0", "it.geosolutions.imageioimpl.plugins.tiff.TIFFImageMetadataFormat", new String[]{""}, new String[]{""});
    }

    @Override
    public String getDescription(Locale locale) {
        String desc = PackageUtil.getSpecificationTitle() + " TIFF Image Reader";
        return desc;
    }

    @Override
    public boolean canDecodeInput(Object input) throws IOException {
        if (!(input instanceof ImageInputStream)) {
            return false;
        }
        ImageInputStream stream = (ImageInputStream)input;
        byte[] b = new byte[4];
        stream.mark();
        stream.readFully(b);
        stream.reset();
        return b[0] == 73 && b[1] == 73 && b[2] == 42 && b[3] == 0 || b[0] == 77 && b[1] == 77 && b[2] == 0 && b[3] == 42 || b[0] == 73 && b[1] == 73 && b[2] == 43 && b[3] == 0 || b[0] == 77 && b[1] == 77 && b[2] == 0 && b[3] == 43;
    }

    @Override
    public ImageReader createReaderInstance(Object extension) {
        return new TIFFImageReader(this);
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        if (this.registered) {
            return;
        }
        this.registered = true;
        for (ImageReaderSpi imageReaderSpi : ImageIOUtilities.getImageReaderWriterSPI(registry, new TIFFFilter(true), "TIFF", true)) {
            if (imageReaderSpi == this) continue;
            registry.deregisterServiceProvider(imageReaderSpi);
            registry.setOrdering(category, this, imageReaderSpi);
        }
    }

    static class TIFFFilter
    implements ServiceRegistry.Filter {
        boolean isReader;

        TIFFFilter(boolean isReader) {
            this.isReader = isReader;
        }

        @Override
        public boolean filter(Object provider) {
            boolean isSupportedSpi;
            boolean bl = isSupportedSpi = this.isReader ? provider instanceof ImageReaderSpi : provider instanceof ImageWriterSpi;
            if (!isSupportedSpi) {
                return false;
            }
            ImageReaderWriterSpi spi = (ImageReaderWriterSpi)provider;
            String[] formatNames = spi.getFormatNames();
            for (int i = 0; i < formatNames.length; ++i) {
                if (!formatNames[i].equalsIgnoreCase("TIFF")) continue;
                return true;
            }
            return false;
        }
    }
}

