/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.aggregates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.record.ColumnInfoRecord;
import org.apache.poi.hssf.record.aggregates.RecordAggregate;

public final class ColumnInfoRecordsAggregate
extends RecordAggregate {
    private final List<ColumnInfoRecord> records = new ArrayList<ColumnInfoRecord>();

    public ColumnInfoRecordsAggregate() {
    }

    public ColumnInfoRecordsAggregate(RecordStream recordStream) {
        this();
        boolean bl = true;
        ColumnInfoRecord columnInfoRecord = null;
        while (recordStream.peekNextClass() == ColumnInfoRecord.class) {
            ColumnInfoRecord columnInfoRecord2 = (ColumnInfoRecord)recordStream.getNext();
            this.records.add(columnInfoRecord2);
            if (columnInfoRecord != null && CIRComparator.compareColInfos(columnInfoRecord, columnInfoRecord2) > 0) {
                bl = false;
            }
            columnInfoRecord = columnInfoRecord2;
        }
        if (this.records.size() < 1) {
            throw new RuntimeException("No column info records found");
        }
        if (!bl) {
            Collections.sort(this.records, CIRComparator.instance);
        }
    }

    public Object clone() {
        ColumnInfoRecordsAggregate columnInfoRecordsAggregate = new ColumnInfoRecordsAggregate();
        for (int i = 0; i < this.records.size(); ++i) {
            ColumnInfoRecord columnInfoRecord = this.records.get(i);
            columnInfoRecordsAggregate.records.add((ColumnInfoRecord)columnInfoRecord.clone());
        }
        return columnInfoRecordsAggregate;
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor recordVisitor) {
        int n = this.records.size();
        if (n < 1) {
            return;
        }
        ColumnInfoRecord columnInfoRecord = null;
        for (int i = 0; i < n; ++i) {
            ColumnInfoRecord columnInfoRecord2 = this.records.get(i);
            recordVisitor.visitRecord(columnInfoRecord2);
            if (columnInfoRecord != null && CIRComparator.compareColInfos(columnInfoRecord, columnInfoRecord2) > 0) {
                throw new RuntimeException("Column info records are out of order");
            }
            columnInfoRecord = columnInfoRecord2;
        }
    }

    private ColumnInfoRecord getColInfo(int n) {
        return this.records.get(n);
    }

    public ColumnInfoRecord findColumnInfo(int n) {
        int n2 = this.records.size();
        for (int i = 0; i < n2; ++i) {
            ColumnInfoRecord columnInfoRecord = this.getColInfo(i);
            if (!columnInfoRecord.containsColumn(n)) continue;
            return columnInfoRecord;
        }
        return null;
    }

    private static final class CIRComparator
    implements Comparator<ColumnInfoRecord> {
        public static final Comparator<ColumnInfoRecord> instance = new CIRComparator();

        private CIRComparator() {
        }

        @Override
        public int compare(ColumnInfoRecord columnInfoRecord, ColumnInfoRecord columnInfoRecord2) {
            return CIRComparator.compareColInfos(columnInfoRecord, columnInfoRecord2);
        }

        public static int compareColInfos(ColumnInfoRecord columnInfoRecord, ColumnInfoRecord columnInfoRecord2) {
            return columnInfoRecord.getFirstColumn() - columnInfoRecord2.getFirstColumn();
        }
    }
}

