/*
 * Decompiled with CFR 0.152.
 */
package tec.uom.se.function;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.Supplier;
import javax.measure.UnitConverter;
import tec.uom.lib.common.function.ValueSupplier;
import tec.uom.se.AbstractConverter;

public final class RationalConverter
extends AbstractConverter
implements ValueSupplier<Double>,
Supplier<Double>,
DoubleSupplier {
    private static final long serialVersionUID = 3563384008357680074L;
    private final BigInteger dividend;
    private final BigInteger divisor;

    public RationalConverter(BigInteger dividend, BigInteger divisor) {
        if (divisor.compareTo(BigInteger.ZERO) <= 0) {
            throw new IllegalArgumentException("Negative or zero divisor");
        }
        if (dividend.equals(divisor)) {
            throw new IllegalArgumentException("Would result in identity converter");
        }
        this.dividend = dividend;
        this.divisor = divisor;
    }

    public RationalConverter(long dividend, long divisor) {
        this(BigInteger.valueOf(dividend), BigInteger.valueOf(divisor));
    }

    public static RationalConverter of(BigInteger dividend, BigInteger divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public static RationalConverter of(long dividend, long divisor) {
        return new RationalConverter(dividend, divisor);
    }

    public static RationalConverter of(double dividend, double divisor) {
        return new RationalConverter(BigDecimal.valueOf(dividend).toBigInteger(), BigDecimal.valueOf(divisor).toBigInteger());
    }

    public BigInteger getDividend() {
        return this.dividend;
    }

    public BigInteger getDivisor() {
        return this.divisor;
    }

    @Override
    public double convert(double value) {
        return value * RationalConverter.toDouble(this.dividend) / RationalConverter.toDouble(this.divisor);
    }

    private static double toDouble(BigInteger integer) {
        return integer.bitLength() < 64 ? (double)integer.longValue() : integer.doubleValue();
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        BigDecimal decimalDividend = new BigDecimal(this.dividend, 0);
        BigDecimal decimalDivisor = new BigDecimal(this.divisor, 0);
        return value.multiply(decimalDividend, ctx).divide(decimalDivisor, ctx);
    }

    @Override
    public UnitConverter concatenate(UnitConverter converter) {
        if (!(converter instanceof RationalConverter)) {
            return super.concatenate(converter);
        }
        RationalConverter that = (RationalConverter)converter;
        BigInteger newDividend = this.getDividend().multiply(that.getDividend());
        BigInteger newDivisor = this.getDivisor().multiply(that.getDivisor());
        BigInteger gcd = newDividend.gcd(newDivisor);
        newDividend = newDividend.divide(gcd);
        newDivisor = newDivisor.divide(gcd);
        return newDividend.equals(BigInteger.ONE) && newDivisor.equals(BigInteger.ONE) ? IDENTITY : new RationalConverter(newDividend, newDivisor);
    }

    @Override
    public RationalConverter inverse() {
        return this.dividend.signum() == -1 ? new RationalConverter(this.getDivisor().negate(), this.getDividend().negate()) : new RationalConverter(this.getDivisor(), this.getDividend());
    }

    public final String toString() {
        return "RationalConverter(" + this.dividend + "," + this.divisor + ")";
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RationalConverter) {
            RationalConverter that = (RationalConverter)obj;
            return Objects.equals(this.dividend, that.dividend) && Objects.equals(this.divisor, that.divisor);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.dividend, this.divisor);
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public Double getValue() {
        return this.getAsDouble();
    }

    @Override
    public double getAsDouble() {
        return RationalConverter.toDouble(this.dividend) / RationalConverter.toDouble(this.divisor);
    }

    @Override
    public Double get() {
        return this.getValue();
    }
}

