/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io;

import com.sun.media.imageioimpl.common.PackageUtil;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.stream.FileCacheImageOutputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import javax.media.jai.PlanarImage;
import org.geotools.image.ImageWorker;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageIOExt {
    static Long filesystemThreshold = null;
    static File cacheDirectory = null;

    public static ImageOutputStream createImageOutputStream(RenderedImage image, Object destination) throws IOException {
        if (destination instanceof ImageOutputStream) {
            return (ImageOutputStream)destination;
        }
        if (destination instanceof OutputStream && filesystemThreshold != null && image != null) {
            OutputStream stream = (OutputStream)destination;
            long imageSize = ImageIOExt.computeImageSize(image);
            if (imageSize > filesystemThreshold) {
                File cacheDirectory = ImageIOExt.getCacheDirectory();
                return new FileCacheImageOutputStream(stream, cacheDirectory);
            }
            return new MemoryCacheImageOutputStream(stream);
        }
        return ImageIO.createImageOutputStream(destination);
    }

    public static ImageInputStream createImageInputStream(Object input) throws IOException {
        return ImageIO.createImageInputStream(input);
    }

    public static File getCacheDirectory() {
        File cacheDir = cacheDirectory;
        if (cacheDir == null) {
            cacheDir = ImageIO.getCacheDirectory();
        }
        return cacheDir;
    }

    public static void setCacheDirectory(File cache) {
        cacheDirectory = cache;
    }

    public static Long getFilesystemThreshold() {
        return filesystemThreshold;
    }

    public static void setFilesystemThreshold(Long filesystemThreshold) {
        ImageIOExt.filesystemThreshold = filesystemThreshold;
    }

    public static synchronized <T extends ImageReaderWriterSpi> void allowNativeCodec(String format, Class<T> category, boolean allowed) {
        ImageReaderWriterSpi standard = null;
        ImageReaderWriterSpi codeclib = null;
        IIORegistry registry = IIORegistry.getDefaultInstance();
        Iterator<T> it = registry.getServiceProviders(category, false);
        block0: while (it.hasNext()) {
            ImageReaderWriterSpi provider = (ImageReaderWriterSpi)it.next();
            String[] formats = provider.getFormatNames();
            for (int i = 0; i < formats.length; ++i) {
                if (!formats[i].equalsIgnoreCase(format)) continue;
                if (Classes.getShortClassName(provider).startsWith("CLib")) {
                    codeclib = provider;
                    continue block0;
                }
                standard = provider;
                continue block0;
            }
        }
        if (standard != null && codeclib != null) {
            if (allowed) {
                registry.setOrdering(category, codeclib, standard);
            } else {
                registry.setOrdering(category, standard, codeclib);
            }
        }
    }

    public static final ImageInputStreamSpi getImageInputStreamSPI(Object input) {
        return ImageIOExt.getImageInputStreamSPI(input, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ImageInputStreamSpi getImageInputStreamSPI(Object input, boolean streamCreationCheck) {
        Iterator<ImageInputStreamSpi> iter;
        try {
            iter = IIORegistry.getDefaultInstance().getServiceProviders(ImageInputStreamSpi.class, true);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        boolean usecache = ImageIO.getUseCache();
        ImageInputStreamSpi spi = null;
        while (iter.hasNext()) {
            spi = iter.next();
            if (!spi.getInputClass().isInstance(input)) continue;
            if (!streamCreationCheck) break;
            ImageInputStream stream = null;
            try {
                stream = spi.createInputStreamInstance(input, usecache, ImageIO.getCacheDirectory());
                break;
            }
            catch (IOException e) {
                ImageInputStreamSpi imageInputStreamSpi = null;
                return imageInputStreamSpi;
            }
            finally {
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable) {}
                }
            }
        }
        return spi;
    }

    public static boolean isCLibAvailable() {
        return PackageUtil.isCodecLibAvailable();
    }

    public static ImageReader getImageioReader(ImageInputStream inStream) {
        Utilities.ensureNonNull("inStream", inStream);
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        return readersIt.next();
    }

    static long computeImageSize(RenderedImage image) {
        long bits = 0L;
        int bands = image.getSampleModel().getNumBands();
        for (int i = 0; i < bands; ++i) {
            bits += (long)image.getSampleModel().getSampleSize(i);
        }
        return (long)Math.ceil((double)bits / 8.0) * (long)image.getWidth() * (long)image.getHeight();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderedImage read(Object input) throws IOException {
        IIOMetadata imageMetadata;
        Node tree;
        Node trns_rgb;
        BufferedImage bi;
        ImageReader reader;
        if (input == null) {
            throw new IllegalArgumentException("input == null!");
        }
        ImageInputStream stream = input instanceof ImageInputStream ? (ImageInputStream)input : ImageIO.createImageInputStream(input);
        if (stream == null) {
            throw new IOException("Can't create an ImageInputStream!");
        }
        Iterator<ImageReader> iter = ImageIO.getImageReaders(stream);
        if (!iter.hasNext()) {
            return null;
        }
        boolean isJdkPNGReader = "com.sun.imageio.plugins.png.PNGImageReader".equals((reader = iter.next()).getClass().getName());
        reader.setInput(stream, true, !isJdkPNGReader);
        try {
            ImageReadParam param = reader.getDefaultReadParam();
            bi = reader.read(0, param);
        }
        finally {
            reader.dispose();
            stream.close();
        }
        if (isJdkPNGReader && bi.getColorModel() instanceof ComponentColorModel && !bi.getColorModel().hasAlpha() && bi.getColorModel().getNumComponents() == 3 && (trns_rgb = ImageIOExt.getNodeFromPath(tree = (imageMetadata = reader.getImageMetadata(0)).getAsTree(imageMetadata.getNativeMetadataFormatName()), Arrays.asList("tRNS", "tRNS_RGB"))) != null) {
            NamedNodeMap attributes = trns_rgb.getAttributes();
            Integer red = ImageIOExt.getIntegerAttribute(attributes, "red");
            Integer green = ImageIOExt.getIntegerAttribute(attributes, "green");
            Integer blue = ImageIOExt.getIntegerAttribute(attributes, "blue");
            if (red != null && green != null && blue != null) {
                Color color = new Color(red, green, blue);
                ImageWorker iw = new ImageWorker(bi);
                iw.makeColorTransparent(color);
                return iw.getRenderedImage();
            }
        }
        return bi;
    }

    public static BufferedImage readBufferedImage(Object input) throws IOException {
        RenderedImage ri = ImageIOExt.read(input);
        if (ri == null) {
            return null;
        }
        if (ri instanceof BufferedImage) {
            return (BufferedImage)ri;
        }
        return PlanarImage.wrapRenderedImage(ri).getAsBufferedImage();
    }

    private static Integer getIntegerAttribute(NamedNodeMap attributes, String attributeName) {
        return Optional.ofNullable(attributes.getNamedItem(attributeName)).map(n -> n.getNodeValue()).map(s -> Integer.valueOf(s)).orElse(null);
    }

    private static Node getNodeFromPath(Node root, List<String> pathComponents) {
        if (pathComponents.isEmpty()) {
            return root;
        }
        String firstComponent = pathComponents.get(0);
        NodeList childNodes = root.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node child = childNodes.item(i);
            if (!firstComponent.equals(child.getNodeName())) continue;
            return ImageIOExt.getNodeFromPath(child, pathComponents.subList(1, pathComponents.size()));
        }
        return null;
    }
}

