/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.filter.function;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.geotools.filter.FunctionExpressionImpl;
import org.geotools.filter.capability.FunctionNameImpl;
import org.opengis.filter.capability.FunctionName;

public class JsonPointerFunction
extends FunctionExpressionImpl {
    private static final JsonToken END_OF_STREAM = null;
    private final JsonFactory factory = new JsonFactory();
    public static FunctionName NAME = new FunctionNameImpl("jsonPointer", FunctionNameImpl.parameter("result", Object.class), FunctionNameImpl.parameter("json", String.class), FunctionNameImpl.parameter("pointer", String.class));

    public JsonPointerFunction() {
        super(NAME);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object evaluate(Object object) {
        String json = this.getExpression(0).evaluate(object, String.class);
        String pointerSpec = this.getExpression(1).evaluate(object, String.class);
        JsonPointer expectedPointer = JsonPointer.compile((String)pointerSpec);
        try (JsonParser parser = this.factory.createParser(json);){
            JsonPointer pointer;
            do {
                if (parser.nextToken() == END_OF_STREAM) return null;
            } while (!(pointer = parser.getParsingContext().pathAsPointer()).equals((Object)expectedPointer) || parser.currentTokenId() == 5);
            switch (parser.currentTokenId()) {
                case 6: {
                    String string = parser.getText();
                    return string;
                }
                case 8: {
                    Float f = Float.valueOf(parser.getFloatValue());
                    return f;
                }
                case 7: {
                    Integer n = parser.getIntValue();
                    return n;
                }
                case 9: 
                case 10: {
                    Boolean bl = parser.getBooleanValue();
                    return bl;
                }
            }
            StringWriter writer = new StringWriter();
            try (JsonGenerator generator = this.factory.createGenerator((Writer)writer);){
                this.serializeContents(parser, generator);
            }
            String string = writer.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void serializeContents(JsonParser parser, JsonGenerator generator) throws IOException {
        switch (parser.currentTokenId()) {
            case 3: {
                this.serializeArray(parser, generator);
                break;
            }
            case 1: {
                this.serializeObject(parser, generator);
            }
        }
    }

    private void serializeArray(JsonParser parser, JsonGenerator generator) throws IOException {
        generator.writeStartArray();
        JsonToken token = parser.nextToken();
        while (token != END_OF_STREAM && token != JsonToken.END_ARRAY) {
            switch (parser.currentTokenId()) {
                case 6: {
                    generator.writeString(parser.getText());
                    break;
                }
                case 8: {
                    generator.writeNumber(parser.getFloatValue());
                    break;
                }
                case 7: {
                    generator.writeNumber(parser.getIntValue());
                    break;
                }
                case 9: 
                case 10: {
                    generator.writeBoolean(parser.getBooleanValue());
                    break;
                }
                default: {
                    this.serializeContents(parser, generator);
                }
            }
            token = parser.nextToken();
        }
        generator.writeEndArray();
    }

    private void serializeObject(JsonParser parser, JsonGenerator generator) throws IOException {
        generator.writeStartObject();
        JsonToken token = parser.nextToken();
        while (token != END_OF_STREAM && token != JsonToken.END_OBJECT) {
            switch (parser.currentTokenId()) {
                case 5: {
                    generator.writeFieldName(parser.getCurrentName());
                    break;
                }
                case 6: {
                    generator.writeString(parser.getText());
                    break;
                }
                case 8: {
                    generator.writeNumber(parser.getFloatValue());
                    break;
                }
                case 7: {
                    generator.writeNumber(parser.getIntValue());
                    break;
                }
                case 9: 
                case 10: {
                    generator.writeBoolean(parser.getBooleanValue());
                    break;
                }
                default: {
                    this.serializeContents(parser, generator);
                }
            }
            token = parser.nextToken();
        }
        generator.writeEndObject();
    }
}

