/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.function;

import java.math.BigDecimal;
import java.math.MathContext;
import javax.measure.UnitConverter;
import tec.units.indriya.AbstractConverter;
import tec.units.indriya.function.PiMultiplierConverter;
import tec.uom.lib.common.function.ValueSupplier;

final class PiDivisorConverter
extends AbstractConverter
implements ValueSupplier<String> {
    private static final long serialVersionUID = 5052794216568914141L;

    @Override
    public double convert(double value) {
        return value / Math.PI;
    }

    @Override
    public BigDecimal convert(BigDecimal value, MathContext ctx) throws ArithmeticException {
        int nbrDigits = ctx.getPrecision();
        if (nbrDigits == 0) {
            throw new ArithmeticException("Pi multiplication with unlimited precision");
        }
        BigDecimal pi = PiMultiplierConverter.Pi.pi(nbrDigits);
        return value.divide(pi, ctx);
    }

    @Override
    public AbstractConverter inverse() {
        return new PiMultiplierConverter();
    }

    public final String toString() {
        return "(1/\u03c0)";
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof PiDivisorConverter;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    @Override
    public boolean isLinear() {
        return true;
    }

    @Override
    public String getValue() {
        return this.toString();
    }

    @Override
    public int compareTo(UnitConverter o) {
        if (this == o) {
            return 0;
        }
        if (o instanceof ValueSupplier) {
            return this.getValue().compareTo(String.valueOf(((ValueSupplier)((Object)o)).getValue()));
        }
        return -1;
    }
}

