/*
 * Decompiled with CFR 0.152.
 */
package org.jaitools.jts;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import org.jaitools.jts.SmootherControl;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.GeometryFactory;

public abstract class AbstractSmoother {
    public static final SmootherControl DEFAULT_CONTROL = new SmootherControl(){

        public double getMinLength() {
            return 0.0;
        }

        public int getNumVertices(double length) {
            return 10;
        }
    };
    protected SmootherControl control;
    protected final GeometryFactory geomFactory;
    protected Map<Integer, WeakReference<InterpPoint[]>> lookup = new HashMap<Integer, WeakReference<InterpPoint[]>>();

    public AbstractSmoother(GeometryFactory geomFactory) {
        if (geomFactory == null) {
            throw new IllegalArgumentException("geomFactory must not be null");
        }
        this.geomFactory = geomFactory;
        this.control = DEFAULT_CONTROL;
    }

    public void setControl(SmootherControl control) {
        this.control = control == null ? DEFAULT_CONTROL : control;
    }

    protected Coordinate[] cubicBezier(Coordinate start, Coordinate end, Coordinate ctrl1, Coordinate ctrl2, int nv) {
        Coordinate[] curve = new Coordinate[nv];
        Coordinate[] buf = new Coordinate[3];
        for (int i = 0; i < buf.length; ++i) {
            buf[i] = new Coordinate();
        }
        curve[0] = new Coordinate(start);
        curve[nv - 1] = new Coordinate(end);
        InterpPoint[] ip = this.getInterpPoints(nv);
        for (int i = 1; i < nv - 1; ++i) {
            Coordinate c = new Coordinate();
            c.x = ip[i].t[0] * start.x + ip[i].t[1] * ctrl1.x + ip[i].t[2] * ctrl2.x + ip[i].t[3] * end.x;
            c.x /= ip[i].tsum;
            c.y = ip[i].t[0] * start.y + ip[i].t[1] * ctrl1.y + ip[i].t[2] * ctrl2.y + ip[i].t[3] * end.y;
            c.y /= ip[i].tsum;
            curve[i] = c;
        }
        return curve;
    }

    protected InterpPoint[] getInterpPoints(int npoints) {
        WeakReference<InterpPoint[]> ref = this.lookup.get(npoints);
        InterpPoint[] ip = null;
        if (ref != null) {
            ip = (InterpPoint[])ref.get();
        }
        if (ip == null) {
            ip = new InterpPoint[npoints];
            for (int i = 0; i < npoints; ++i) {
                double t = (double)i / (double)(npoints - 1);
                double tc = 1.0 - t;
                ip[i] = new InterpPoint();
                ip[i].t[0] = tc * tc * tc;
                ip[i].t[1] = 3.0 * tc * tc * t;
                ip[i].t[2] = 3.0 * tc * t * t;
                ip[i].t[3] = t * t * t;
                ip[i].tsum = ip[i].t[0] + ip[i].t[1] + ip[i].t[2] + ip[i].t[3];
            }
            this.lookup.put(npoints, new WeakReference<InterpPoint[]>(ip));
        }
        return ip;
    }

    protected static final class InterpPoint {
        double[] t = new double[4];
        double tsum;

        protected InterpPoint() {
        }
    }
}

