/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.geotools.geometry.GeometryFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.opengis.geometry.DirectPosition;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.geometry.MismatchedReferenceSystemException;
import org.opengis.geometry.PositionFactory;
import org.opengis.geometry.Precision;
import org.opengis.geometry.aggregate.AggregateFactory;
import org.opengis.geometry.aggregate.MultiCurve;
import org.opengis.geometry.aggregate.MultiPoint;
import org.opengis.geometry.aggregate.MultiPrimitive;
import org.opengis.geometry.aggregate.MultiSurface;
import org.opengis.geometry.complex.ComplexFactory;
import org.opengis.geometry.complex.CompositeCurve;
import org.opengis.geometry.complex.CompositePoint;
import org.opengis.geometry.complex.CompositeSurface;
import org.opengis.geometry.coordinate.GeometryFactory;
import org.opengis.geometry.coordinate.LineSegment;
import org.opengis.geometry.coordinate.LineString;
import org.opengis.geometry.coordinate.PointArray;
import org.opengis.geometry.coordinate.Polygon;
import org.opengis.geometry.coordinate.PolyhedralSurface;
import org.opengis.geometry.coordinate.Position;
import org.opengis.geometry.coordinate.Tin;
import org.opengis.geometry.primitive.Curve;
import org.opengis.geometry.primitive.CurveSegment;
import org.opengis.geometry.primitive.OrientableCurve;
import org.opengis.geometry.primitive.Point;
import org.opengis.geometry.primitive.Primitive;
import org.opengis.geometry.primitive.PrimitiveFactory;
import org.opengis.geometry.primitive.Ring;
import org.opengis.geometry.primitive.Solid;
import org.opengis.geometry.primitive.SolidBoundary;
import org.opengis.geometry.primitive.Surface;
import org.opengis.geometry.primitive.SurfaceBoundary;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.AxisDirection;
import org.opengis.referencing.cs.CoordinateSystemAxis;

public class GeometryBuilder {
    private Hints hints;
    private CoordinateReferenceSystem crs;
    private PositionFactory positionFactory;
    private PrimitiveFactory primitiveFactory;
    private AggregateFactory aggregateFactory;
    private ComplexFactory complexFactory;
    private GeometryFactory geometryFactory;

    public GeometryBuilder(CoordinateReferenceSystem crs) {
        this.crs = crs;
        this.hints = GeoTools.getDefaultHints();
        this.hints.put(Hints.CRS, crs);
        this.hints.put(Hints.GEOMETRY_VALIDATE, (Object)true);
    }

    public GeometryBuilder(String code) throws NoSuchAuthorityCodeException, FactoryException {
        this(CRS.decode(code));
    }

    public GeometryBuilder(Hints hints) {
        this.crs = (CoordinateReferenceSystem)hints.get(Hints.CRS);
        this.hints = hints;
        this.getPositionFactory();
        this.getPrecision();
        this.getPrimitiveFactory();
        this.getAggregateFactory();
        this.getGeometryFactory();
        this.getComplexFactory();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.crs;
    }

    public void setCoordinateReferenceSystem(CoordinateReferenceSystem crs) {
        if (this.crs != crs) {
            this.hints.remove(Hints.CRS);
            this.hints.put(Hints.CRS, crs);
            this.crs = crs;
            this.positionFactory = null;
            this.primitiveFactory = null;
            this.aggregateFactory = null;
            this.complexFactory = null;
            this.geometryFactory = null;
            this.getPositionFactory();
            this.getPrecision();
            this.getPrimitiveFactory();
            this.getAggregateFactory();
            this.getGeometryFactory();
            this.getComplexFactory();
        }
    }

    public Precision getPrecision() {
        return this.getPositionFactory().getPrecision();
    }

    public PositionFactory getPositionFactory() {
        if (this.positionFactory == null) {
            Object factory;
            if (this.hints.containsKey(Hints.POSITION_FACTORY) && (factory = this.hints.get(Hints.POSITION_FACTORY)) instanceof PositionFactory) {
                this.positionFactory = (PositionFactory)factory;
                return this.positionFactory;
            }
            this.positionFactory = GeometryFactoryFinder.getPositionFactory(this.hints);
        }
        return this.positionFactory;
    }

    public PrimitiveFactory getPrimitiveFactory() {
        if (this.primitiveFactory == null) {
            Object factory;
            if (this.hints.containsKey(Hints.PRIMITIVE_FACTORY) && (factory = this.hints.get(Hints.PRIMITIVE_FACTORY)) instanceof PrimitiveFactory) {
                this.primitiveFactory = (PrimitiveFactory)factory;
                return this.primitiveFactory;
            }
            this.primitiveFactory = GeometryFactoryFinder.getPrimitiveFactory(this.hints);
        }
        return this.primitiveFactory;
    }

    public AggregateFactory getAggregateFactory() {
        if (this.aggregateFactory == null) {
            Object factory;
            if (this.hints.containsKey(Hints.AGGREGATE_FACTORY) && (factory = this.hints.get(Hints.AGGREGATE_FACTORY)) instanceof AggregateFactory) {
                this.aggregateFactory = (AggregateFactory)factory;
                return this.aggregateFactory;
            }
            this.aggregateFactory = GeometryFactoryFinder.getAggregateFactory(this.hints);
        }
        return this.aggregateFactory;
    }

    public GeometryFactory getGeometryFactory() {
        if (this.geometryFactory == null) {
            Object factory;
            if (this.hints.containsKey(Hints.GEOMETRY_FACTORY) && (factory = this.hints.get(Hints.GEOMETRY_FACTORY)) instanceof GeometryFactory) {
                this.geometryFactory = (GeometryFactory)factory;
                return this.geometryFactory;
            }
            this.geometryFactory = GeometryFactoryFinder.getGeometryFactory(this.hints);
        }
        return this.geometryFactory;
    }

    public ComplexFactory getComplexFactory() {
        if (this.complexFactory == null) {
            Object factory;
            if (this.hints.containsKey(Hints.COMPLEX_FACTORY) && (factory = this.hints.get(Hints.COMPLEX_FACTORY)) instanceof ComplexFactory) {
                this.complexFactory = (ComplexFactory)factory;
                return this.complexFactory;
            }
            this.complexFactory = GeometryFactoryFinder.getComplexFactory(this.hints);
        }
        return this.complexFactory;
    }

    public DirectPosition createDirectPosition(double[] ordinates) {
        return this.getPositionFactory().createDirectPosition(ordinates);
    }

    public Position createPosition(Position position) {
        return this.getPositionFactory().createPosition(position);
    }

    public PointArray createPointArray() {
        return this.getPositionFactory().createPointArray();
    }

    public PointArray createPointArray(double[] array) {
        return this.getPositionFactory().createPointArray(array, 0, array.length / this.crs.getCoordinateSystem().getDimension());
    }

    public PointArray createPointArray(double[] array, int start, int end) {
        return this.getPositionFactory().createPointArray(array, start, end);
    }

    public PointArray createPositionList(float[] array, int start, int end) {
        return this.getPositionFactory().createPointArray(array, start, end);
    }

    public Curve createCurve(List segments) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        if (segments == null) {
            throw new NullPointerException("Segments are required to create a curve");
        }
        return this.getPrimitiveFactory().createCurve(segments);
    }

    public Curve createCurve(PointArray points, boolean closed) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        if (points == null) {
            throw new NullPointerException("Points are required to create a curve");
        }
        if (points.size() < 2) {
            throw new IllegalArgumentException("At least two points are required to create a curve");
        }
        ArrayList<CurveSegment> segmentList = new ArrayList<CurveSegment>();
        for (int i = 0; i < points.size() - 1; ++i) {
            int start = i;
            int end = i + 1;
            DirectPosition point1 = points.getDirectPosition(start, null);
            DirectPosition point2 = points.getDirectPosition(end, null);
            LineSegment segment = this.createLineSegment(point1, point2);
            segmentList.add(segment);
        }
        if (closed) {
            LineSegment first = (LineSegment)segmentList.get(0);
            LineSegment last = (LineSegment)segmentList.get(segmentList.size() - 1);
            if (!first.getStartPoint().equals(last.getEndPoint())) {
                LineSegment segment = this.createLineSegment(last.getEndPoint(), first.getStartPoint());
                segmentList.add(segment);
            }
        }
        return this.getPrimitiveFactory().createCurve(segmentList);
    }

    public Point createPoint(double ord1, double ord2) {
        return this.createPoint(new double[]{ord1, ord2});
    }

    public Point createPoint(double ord1, double ord2, double ord3) {
        return this.createPoint(new double[]{ord1, ord2, ord3});
    }

    public Point createPoint(double[] ordinates) throws MismatchedDimensionException {
        if (ordinates == null) {
            throw new NullPointerException("Ordinates required to create a point");
        }
        int dimension = this.getCoordinateReferenceSystem().getCoordinateSystem().getDimension();
        if (ordinates.length != dimension) {
            throw new MismatchedDimensionException("Create point requires " + dimension + " ordinates (" + ordinates.length + " provided");
        }
        return this.getPrimitiveFactory().createPoint(ordinates);
    }

    public Point createPoint(Position position) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        if (position == null) {
            throw new NullPointerException();
        }
        this.setCoordinateReferenceSystem(position.getDirectPosition().getCoordinateReferenceSystem());
        DirectPosition copy = this.getPositionFactory().createDirectPosition(position.getDirectPosition().getCoordinate());
        return this.getPrimitiveFactory().createPoint(copy);
    }

    public Primitive createPrimitive(Envelope envelope) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        LineSegment segment = this.processBoundsToSegment(envelope);
        this.setCoordinateReferenceSystem(envelope.getCoordinateReferenceSystem());
        return this.processSegmentToPrimitive(envelope, segment, 1);
    }

    private Primitive processSegmentToPrimitive(Envelope bounds, LineSegment segment, int dimension) {
        CoordinateSystemAxis axis = this.crs.getCoordinateSystem().getAxis(dimension);
        if (axis.getDirection() == AxisDirection.OTHER) {
            return this.processSegmentToPrimitive(bounds, segment, dimension + 1);
        }
        Ring ring = this.processBoundsToRing(bounds, segment, dimension);
        return this.processRingToPrimitive(bounds, ring, dimension + 1);
    }

    private Ring processBoundsToRing(Envelope bounds, LineSegment segment, int D) {
        DirectPosition one = this.getPositionFactory().createDirectPosition(segment.getStartPoint().getCoordinate());
        one.setOrdinate(D, bounds.getMinimum(D));
        DirectPosition two = this.getPositionFactory().createDirectPosition(segment.getEndPoint().getCoordinate());
        two.setOrdinate(D, bounds.getMinimum(D));
        DirectPosition three = this.getPositionFactory().createDirectPosition(two.getCoordinate());
        three.setOrdinate(D, bounds.getMaximum(D));
        DirectPosition four = this.getPositionFactory().createDirectPosition(one.getCoordinate());
        four.setOrdinate(D, bounds.getMaximum(D));
        LineSegment edge1 = this.getGeometryFactory().createLineSegment(one, two);
        LineSegment edge2 = this.getGeometryFactory().createLineSegment(two, three);
        LineSegment edge3 = this.getGeometryFactory().createLineSegment(three, four);
        LineSegment edge4 = this.getGeometryFactory().createLineSegment(four, one);
        ArrayList<OrientableCurve> edges = new ArrayList<OrientableCurve>();
        edges.add(this.createCurve(Arrays.asList(edge1)));
        edges.add(this.createCurve(Arrays.asList(edge2)));
        edges.add(this.createCurve(Arrays.asList(edge3)));
        edges.add(this.createCurve(Arrays.asList(edge4)));
        return this.createRing(edges);
    }

    private Primitive processRingToPrimitive(Envelope bounds, Ring ring, int dimension) {
        int D = this.crs.getCoordinateSystem().getDimension();
        if (dimension == D) {
            SurfaceBoundary boundary = this.createSurfaceBoundary(ring, Collections.EMPTY_LIST);
            return this.createSurface(boundary);
        }
        CoordinateSystemAxis axis = this.crs.getCoordinateSystem().getAxis(dimension);
        if (axis.getDirection() == AxisDirection.OTHER) {
            return this.processRingToPrimitive(bounds, ring, dimension + 1);
        }
        return this.processRingToVolumne(bounds, ring, dimension + 1);
    }

    private Primitive processRingToVolumne(Envelope bounds, Ring ring, int i) {
        throw new UnsupportedOperationException("Not yet 3D");
    }

    private LineSegment processBoundsToSegment(Envelope bounds) {
        boolean D = false;
        CoordinateReferenceSystem crs = bounds.getCoordinateReferenceSystem();
        CoordinateSystemAxis axis = crs.getCoordinateSystem().getAxis(0);
        DirectPosition positionA = this.getPositionFactory().createDirectPosition(null);
        DirectPosition positionB = this.getPositionFactory().createDirectPosition(null);
        if (axis.getDirection() != AxisDirection.OTHER) {
            positionA.setOrdinate(0, bounds.getMinimum(0));
            positionB.setOrdinate(0, bounds.getMaximum(0));
        }
        return this.getGeometryFactory().createLineSegment(positionA, positionB);
    }

    public Ring createRing(List<OrientableCurve> orientableCurves) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getPrimitiveFactory().createRing(orientableCurves);
    }

    public Solid createSolid(SolidBoundary boundary) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getPrimitiveFactory().createSolid(boundary);
    }

    public SurfaceBoundary createSurfaceBoundary(PointArray points) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        Curve curve = this.createCurve(points, true);
        return this.createSurfaceBoundary(curve);
    }

    public Surface createSurface(List surfaces) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getPrimitiveFactory().createSurface(surfaces);
    }

    public Surface createSurface(SurfaceBoundary boundary) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getPrimitiveFactory().createSurface(boundary);
    }

    public SurfaceBoundary createSurfaceBoundary(Ring exterior, List interiors) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getPrimitiveFactory().createSurfaceBoundary(exterior, interiors);
    }

    public SurfaceBoundary createSurfaceBoundary(Ring exterior) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.createSurfaceBoundary(exterior, new ArrayList());
    }

    public SurfaceBoundary createSurfaceBoundary(OrientableCurve curve) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        ArrayList<OrientableCurve> exterior = new ArrayList<OrientableCurve>(1);
        exterior.add(curve);
        Ring ring = this.createRing(exterior);
        return this.createSurfaceBoundary(ring);
    }

    public DirectPosition createDirectPosition() {
        return this.createDirectPosition(null);
    }

    public Envelope createEnvelope(DirectPosition lowerCorner, DirectPosition upperCorner) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getGeometryFactory().createEnvelope(lowerCorner, upperCorner);
    }

    public LineSegment createLineSegment(Position startPoint, Position endPoint) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getGeometryFactory().createLineSegment(startPoint, endPoint);
    }

    public LineString createLineString(List points) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getGeometryFactory().createLineString(points);
    }

    public LineString createLineString(PointArray points) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getGeometryFactory().createLineString(points);
    }

    public LineSegment createLineSegment(DirectPosition from, DirectPosition to) {
        return this.getGeometryFactory().createLineSegment(from, to);
    }

    public MultiPrimitive createMultiPrimitive() {
        return this.getGeometryFactory().createMultiPrimitive();
    }

    public Polygon createPolygon(SurfaceBoundary boundary) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getGeometryFactory().createPolygon(boundary);
    }

    public Polygon createPolygon(SurfaceBoundary boundary, Surface spanSurface) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getGeometryFactory().createPolygon(boundary, spanSurface);
    }

    public PolyhedralSurface createPolyhedralSurface(List tiles) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getGeometryFactory().createPolyhedralSurface(tiles);
    }

    public Tin createTin(Set post, Set stopLines, Set breakLines, double maxLength) throws MismatchedReferenceSystemException, MismatchedDimensionException {
        return this.getGeometryFactory().createTin(post, stopLines, breakLines, maxLength);
    }

    public CompositeCurve createCompositeCurve(List generator) {
        return this.getComplexFactory().createCompositeCurve(generator);
    }

    public CompositePoint createCompositePoint(Point generator) {
        return this.getComplexFactory().createCompositePoint(generator);
    }

    public CompositeSurface createCompositeSurface(List generator) {
        return this.getComplexFactory().createCompositeSurface(generator);
    }

    public MultiCurve createMultiCurve(Set curves) {
        return this.getAggregateFactory().createMultiCurve(curves);
    }

    public MultiPoint createMultiPoint(Set points) {
        return this.getAggregateFactory().createMultiPoint(points);
    }

    public MultiPrimitive createMultiPrimitive(Set primitives) {
        return this.getAggregateFactory().createMultiPrimitive(primitives);
    }

    public MultiSurface createMultiSurface(Set surfaces) {
        return this.getAggregateFactory().createMultiSurface(surfaces);
    }
}

