/*
 * Decompiled with CFR 0.152.
 */
package tec.units.indriya.quantity.time;

import java.math.BigDecimal;
import java.math.MathContext;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import javax.measure.IncommensurableException;
import javax.measure.Quantity;
import javax.measure.UnconvertibleException;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import javax.measure.quantity.Frequency;
import javax.measure.quantity.Time;
import tec.units.indriya.AbstractQuantity;
import tec.units.indriya.ComparableQuantity;
import tec.units.indriya.quantity.Quantities;
import tec.units.indriya.quantity.time.TimeQuantities;
import tec.units.indriya.unit.Units;

public final class TemporalQuantity
extends AbstractQuantity<Time> {
    private static final long serialVersionUID = 6835738653744691425L;
    private final TemporalUnit timeUnit;
    private final Integer value;
    private final TemporalAmount amount;

    TemporalQuantity(Integer value, TemporalUnit timeUnit) {
        super(TemporalQuantity.toUnit(timeUnit));
        this.timeUnit = timeUnit;
        this.amount = Duration.of(value.intValue(), timeUnit);
        this.value = value;
    }

    public static TemporalQuantity of(Integer number, TemporalUnit timeUnit) {
        return new TemporalQuantity(Objects.requireNonNull(number), Objects.requireNonNull(timeUnit));
    }

    public static TemporalQuantity of(Quantity<Time> quantity) {
        Quantity<Time> seconds = Objects.requireNonNull(quantity).to(Units.SECOND);
        return new TemporalQuantity(seconds.getValue().intValue(), ChronoUnit.SECONDS);
    }

    public TemporalAmount getTemporalAmount() {
        return this.amount;
    }

    public TemporalUnit getTemporalUnit() {
        return this.timeUnit;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    public Unit<Time> toUnit() {
        return TemporalQuantity.toUnit(this.timeUnit);
    }

    public Quantity<Time> toQuantity() {
        return Quantities.getQuantity(this.value, this.toUnit());
    }

    public TemporalQuantity to(TemporalUnit timeUnit) {
        Quantity<Time> time = this.toQuantity().to(TemporalQuantity.toUnit(timeUnit));
        return new TemporalQuantity(time.getValue().intValue(), timeUnit);
    }

    private static Unit<Time> toUnit(TemporalUnit timeUnit) {
        if (timeUnit instanceof ChronoUnit) {
            ChronoUnit chronoUnit = (ChronoUnit)timeUnit;
            switch (chronoUnit) {
                case MICROS: {
                    return TimeQuantities.MICROSECOND;
                }
                case MILLIS: {
                    return TimeQuantities.MILLISECOND;
                }
                case NANOS: {
                    return TimeQuantities.NANOSECOND;
                }
                case SECONDS: {
                    return Units.SECOND;
                }
                case MINUTES: {
                    return Units.MINUTE;
                }
                case HOURS: {
                    return Units.HOUR;
                }
                case DAYS: {
                    return Units.DAY;
                }
            }
            throw new IllegalArgumentException("TemporalQuantity only supports DAYS, HOURS, MICROS, MILLIS, MINUTES, NANOS, SECONDS ");
        }
        throw new IllegalArgumentException("TemporalQuantity only supports temporal units of type ChronoUnit");
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.timeUnit, this.value);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (TemporalQuantity.class.isInstance(obj)) {
            TemporalQuantity other = (TemporalQuantity)TemporalQuantity.class.cast(obj);
            return Objects.equals(this.timeUnit, other.timeUnit) && Objects.equals(this.value, other.value);
        }
        if (obj instanceof Quantity) {
            Quantity that = (Quantity)obj;
            return Objects.equals(this.getUnit(), that.getUnit()) && AbstractQuantity.Equalizer.hasEquality(this.value, that.getValue());
        }
        return super.equals(obj);
    }

    @Override
    public String toString() {
        return "Temporal unit:" + this.timeUnit + " value: " + this.value;
    }

    @Override
    public ComparableQuantity<Time> add(Quantity<Time> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return TimeQuantities.getQuantity((Integer)(this.value + that.getValue().intValue()), this.timeUnit);
        }
        Quantity<Time> converted = that.to(this.getUnit());
        return TimeQuantities.getQuantity((Integer)(this.value + converted.getValue().intValue()), this.timeUnit);
    }

    @Override
    public ComparableQuantity<Time> subtract(Quantity<Time> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return TimeQuantities.getQuantity((Integer)(this.value - that.getValue().intValue()), this.timeUnit);
        }
        Quantity<Time> converted = that.to(this.getUnit());
        return TimeQuantities.getQuantity((Integer)(this.value - converted.getValue().intValue()), this.timeUnit);
    }

    @Override
    public ComparableQuantity<?> divide(Quantity<?> that) {
        if (this.getUnit().equals(that.getUnit())) {
            return TimeQuantities.getQuantity((Integer)(this.value / that.getValue().intValue()), this.timeUnit);
        }
        Unit<?> divUnit = this.getUnit().divide(that.getUnit());
        try {
            UnitConverter conv = this.getUnit().getConverterToAny(divUnit);
            return TimeQuantities.getQuantity((Integer)(this.value / conv.convert(that.getValue()).intValue()), this.timeUnit);
        }
        catch (UnconvertibleException e) {
            e.printStackTrace();
            return TimeQuantities.getQuantity((Integer)(this.value / that.getValue().intValue()), this.timeUnit);
        }
        catch (IncommensurableException e) {
            e.printStackTrace();
            return TimeQuantities.getQuantity((Integer)(this.value / that.getValue().intValue()), this.timeUnit);
        }
    }

    @Override
    public ComparableQuantity<Time> divide(Number that) {
        return TimeQuantities.getQuantity((Integer)(this.value / that.intValue()), this.timeUnit);
    }

    @Override
    public ComparableQuantity<?> multiply(Quantity<?> multiplier) {
        if (this.getUnit().equals(multiplier.getUnit())) {
            return TimeQuantities.getQuantity((Integer)(this.value * multiplier.getValue().intValue()), this.timeUnit);
        }
        Unit<?> mulUnit = this.getUnit().multiply(multiplier.getUnit());
        try {
            UnitConverter conv = this.getUnit().getConverterToAny(mulUnit);
            return TimeQuantities.getQuantity((Integer)(this.value * conv.convert(multiplier.getValue()).intValue()), this.timeUnit);
        }
        catch (UnconvertibleException e) {
            e.printStackTrace();
            return TimeQuantities.getQuantity((Integer)(this.value * multiplier.getValue().intValue()), this.timeUnit);
        }
        catch (IncommensurableException e) {
            e.printStackTrace();
            return TimeQuantities.getQuantity((Integer)(this.value * multiplier.getValue().intValue()), this.timeUnit);
        }
    }

    @Override
    public ComparableQuantity<Time> multiply(Number multiplier) {
        return TimeQuantities.getQuantity((Integer)(this.value * multiplier.intValue()), this.timeUnit);
    }

    @Override
    public ComparableQuantity<Frequency> inverse() {
        return Quantities.getQuantity(1.0 / this.value.doubleValue(), TemporalQuantity.toUnit(this.timeUnit).inverse()).asType(Frequency.class);
    }

    @Override
    public boolean isBig() {
        return true;
    }

    @Override
    public BigDecimal decimalValue(Unit<Time> unit, MathContext ctx) throws ArithmeticException {
        return BigDecimal.valueOf(this.value.doubleValue());
    }

    @Override
    public double doubleValue(Unit<Time> unit) throws ArithmeticException {
        return this.value.doubleValue();
    }
}

