/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.referencing.factory;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Vocabulary;
import org.geotools.metadata.iso.citation.Citations;
import org.geotools.referencing.factory.AbstractAuthorityFactory;
import org.geotools.referencing.factory.AuthorityFactoryAdapter;
import org.geotools.referencing.factory.FallbackAuthorityFactory;
import org.geotools.referencing.factory.IdentifiedObjectFinder;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.FactoryRegistryException;
import org.opengis.metadata.citation.Citation;
import org.opengis.referencing.AuthorityFactory;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CRSAuthorityFactory;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CSAuthorityFactory;
import org.opengis.referencing.cs.CoordinateSystem;
import org.opengis.referencing.datum.Datum;
import org.opengis.referencing.datum.DatumAuthorityFactory;
import org.opengis.referencing.operation.CoordinateOperation;
import org.opengis.referencing.operation.CoordinateOperationAuthorityFactory;
import org.opengis.util.InternationalString;

public class ManyAuthoritiesFactory
extends AuthorityFactoryAdapter
implements CRSAuthorityFactory,
CSAuthorityFactory,
DatumAuthorityFactory,
CoordinateOperationAuthorityFactory {
    private static final Class<? extends AuthorityFactory>[] FACTORY_TYPES = new Class[]{CRSAuthorityFactory.class, DatumAuthorityFactory.class, CSAuthorityFactory.class, CoordinateOperationAuthorityFactory.class};
    private static final Class<? extends IdentifiedObject>[] OBJECT_TYPES = new Class[]{CoordinateReferenceSystem.class, Datum.class, CoordinateSystem.class, CoordinateOperation.class};
    private Collection<AuthorityFactory> factories;
    private final ThreadLocal<Boolean> inProgress = new ThreadLocal();

    public ManyAuthoritiesFactory(Collection<? extends AuthorityFactory> factories) {
        super(50);
        if (factories != null && !factories.isEmpty()) {
            for (AuthorityFactory authorityFactory : factories) {
                if (!(authorityFactory instanceof Factory)) continue;
                this.hints.putAll(((Factory)((Object)authorityFactory)).getImplementationHints());
            }
            this.factories = ManyAuthoritiesFactory.createFallbacks(factories);
        }
    }

    synchronized Collection<AuthorityFactory> getFactories() {
        return this.factories;
    }

    final synchronized void setFactories(Collection<AuthorityFactory> factories) {
        this.factories = ManyAuthoritiesFactory.createFallbacks(factories);
    }

    private static Collection<AuthorityFactory> createFallbacks(Collection<? extends AuthorityFactory> factories) {
        int authorityCount = 0;
        Citation[] authorities = new Citation[factories.size()];
        List[] factoriesByAuthority = new List[authorities.length];
        for (AuthorityFactory authorityFactory : factories) {
            ArrayList<AuthorityFactory> list;
            int authorityIndex;
            Citation authority = authorityFactory.getAuthority();
            for (authorityIndex = 0; authorityIndex < authorityCount; ++authorityIndex) {
                Citation candidate = authorities[authorityIndex];
                if (!Citations.identifierMatches(candidate, authority)) continue;
                authority = candidate;
                break;
            }
            if (authorityIndex == authorityCount) {
                authorities[authorityCount++] = authority;
                factoriesByAuthority[authorityIndex] = list = new ArrayList<AuthorityFactory>(4);
            } else {
                list = factoriesByAuthority[authorityIndex];
            }
            if (list.contains(authorityFactory)) continue;
            list.add(authorityFactory);
        }
        ArrayList<AuthorityFactory> result = new ArrayList<AuthorityFactory>();
        ArrayList<AuthorityFactory> arrayList = new ArrayList<AuthorityFactory>(4);
        for (int i = 0; i < authorityCount; ++i) {
            List list = factoriesByAuthority[i];
            while (!list.isEmpty()) {
                AuthorityFactory primary = null;
                boolean needOtherChains = false;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    AuthorityFactory fallback = (AuthorityFactory)it.next();
                    if (primary == null) {
                        primary = fallback;
                    } else if (!FallbackAuthorityFactory.chainable(primary, fallback)) {
                        needOtherChains = true;
                        continue;
                    }
                    arrayList.add(fallback);
                    if (needOtherChains) continue;
                    it.remove();
                }
                result.add(FallbackAuthorityFactory.create(arrayList));
                arrayList.clear();
            }
        }
        result.trimToSize();
        return result;
    }

    @Override
    boolean sameAuthorityCodes(AuthorityFactory factory) {
        return factory == this;
    }

    protected char getSeparator(String code) {
        code = code.trim();
        int length = code.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isLetterOrDigit(code.charAt(i))) continue;
            if (!code.regionMatches(i, "://", 0, 3)) break;
            return '/';
        }
        return ':';
    }

    private static boolean canSeparateAt(String code, int index) {
        char c;
        int i = index;
        do {
            if (--i >= 0) continue;
            return false;
        } while (Character.isWhitespace(c = code.charAt(i)));
        if (!Character.isJavaIdentifierPart(c)) {
            return false;
        }
        int length = code.length();
        i = index;
        do {
            if (++i < length) continue;
            return false;
        } while (Character.isWhitespace(c = code.charAt(i)));
        return Character.isJavaIdentifierPart(c) || c == '-';
    }

    @Override
    public Citation getVendor() {
        return Citations.GEOTOOLS;
    }

    @Override
    public Citation getAuthority() {
        return ALL;
    }

    public Set<String> getAuthorityNames() {
        HashSet<String> names = new HashSet<String>();
        Collection<AuthorityFactory> factories = this.getFactories();
        if (factories != null) {
            for (AuthorityFactory factory : factories) {
                names.add(Citations.getIdentifier(factory.getAuthority()));
            }
        }
        return names;
    }

    @Override
    public String getBackingStoreDescription() throws FactoryException {
        return null;
    }

    @Override
    Collection<? super AuthorityFactory> dependencies() {
        return this.getFactories();
    }

    private static boolean exclude(AuthorityFactory factory) {
        if (ManyAuthoritiesFactory.class.isInstance(factory)) {
            return true;
        }
        if (factory instanceof AuthorityFactoryAdapter) {
            AuthorityFactoryAdapter adapter = (AuthorityFactoryAdapter)factory;
            return ManyAuthoritiesFactory.exclude(adapter.crsFactory) || ManyAuthoritiesFactory.exclude(adapter.csFactory) || ManyAuthoritiesFactory.exclude(adapter.datumFactory) || ManyAuthoritiesFactory.exclude(adapter.operationFactory);
        }
        return false;
    }

    final void fromFactoryRegistry(String authority, Class<? extends AuthorityFactory> type, Set<AuthorityFactory> addTo) {
        for (int i = 0; i < OBJECT_TYPES.length; ++i) {
            AuthorityFactory factory;
            if (!OBJECT_TYPES[i].isAssignableFrom(type)) continue;
            try {
                factory = this.fromFactoryRegistry(authority, FACTORY_TYPES[i]);
            }
            catch (FactoryRegistryException e) {
                continue;
            }
            if (ManyAuthoritiesFactory.exclude(factory)) continue;
            addTo.add(factory);
        }
    }

    <T extends AuthorityFactory> T fromFactoryRegistry(String authority, Class<T> type) throws FactoryRegistryException {
        return null;
    }

    @Override
    final <T extends AuthorityFactory> T getAuthorityFactory(Class<T> type, String code) throws NoSuchAuthorityCodeException {
        ManyAuthoritiesFactory.ensureNonNull("code", code);
        String authority = null;
        FactoryRegistryException cause = null;
        Collection<AuthorityFactory> factories = this.getFactories();
        char separator = this.getSeparator(code);
        int split = code.lastIndexOf(separator);
        while (split >= 0) {
            block7: {
                if (ManyAuthoritiesFactory.canSeparateAt(code, split)) {
                    T factory;
                    authority = code.substring(0, split).trim();
                    if (factories != null) {
                        for (AuthorityFactory factory2 : factories) {
                            if (!type.isAssignableFrom(factory2.getClass()) || !Citations.identifierMatches(factory2.getAuthority(), authority)) continue;
                            return (T)((AuthorityFactory)type.cast(factory2));
                        }
                    }
                    try {
                        factory = this.fromFactoryRegistry(authority, type);
                    }
                    catch (FactoryRegistryException exception) {
                        cause = exception;
                        break block7;
                    }
                    if (factory != null) {
                        return (T)((AuthorityFactory)type.cast(factory));
                    }
                }
            }
            split = code.lastIndexOf(separator, split - 1);
        }
        throw this.noSuchAuthority(code, authority, cause);
    }

    private NoSuchAuthorityCodeException noSuchAuthority(String code, String authority, FactoryRegistryException cause) {
        String message;
        if (authority == null) {
            authority = Vocabulary.format(252);
            message = Errors.format(96, code);
        } else {
            message = Errors.format(180, authority);
        }
        NoSuchAuthorityCodeException exception = new NoSuchAuthorityCodeException(message, authority, code);
        exception.initCause(cause);
        return exception;
    }

    @Override
    protected AuthorityFactory getAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(AuthorityFactory.class, code);
    }

    @Override
    protected DatumAuthorityFactory getDatumAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(DatumAuthorityFactory.class, code);
    }

    @Override
    protected CSAuthorityFactory getCSAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CSAuthorityFactory.class, code);
    }

    @Override
    protected CRSAuthorityFactory getCRSAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CRSAuthorityFactory.class, code);
    }

    @Override
    protected CoordinateOperationAuthorityFactory getCoordinateOperationAuthorityFactory(String code) throws NoSuchAuthorityCodeException {
        return this.getAuthorityFactory(CoordinateOperationAuthorityFactory.class, code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getAuthorityCodes(Class<? extends IdentifiedObject> type) throws FactoryException {
        if (Boolean.TRUE.equals(this.inProgress.get())) {
            return Collections.emptySet();
        }
        LinkedHashSet<String> codes = new LinkedHashSet<String>();
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        try {
            this.inProgress.set(Boolean.TRUE);
            for (String authority : this.getAuthorityNames()) {
                authority = authority.trim();
                char separator = this.getSeparator(authority);
                StringBuilder code = new StringBuilder(authority);
                int codeBase = code.length();
                if (codeBase != 0 && code.charAt(codeBase - 1) != separator) {
                    code.append(separator);
                    codeBase = code.length();
                }
                code.append("all");
                String dummyCode = code.toString();
                block8: for (int i = 0; i < FACTORY_TYPES.length; ++i) {
                    AuthorityFactory factory;
                    if (!OBJECT_TYPES[i].isAssignableFrom(type)) continue;
                    Class<? extends AuthorityFactory> factoryType = FACTORY_TYPES[i];
                    try {
                        factory = this.getAuthorityFactory(factoryType, dummyCode);
                    }
                    catch (NoSuchAuthorityCodeException e) {
                        continue;
                    }
                    if (!done.add(factory)) continue;
                    AuthorityFactory wrapped = factory;
                    while (wrapped instanceof AuthorityFactoryAdapter) {
                        AuthorityFactoryAdapter adapter = (AuthorityFactoryAdapter)wrapped;
                        try {
                            wrapped = adapter.getAuthorityFactory(factoryType, dummyCode);
                        }
                        catch (NoSuchAuthorityCodeException exception) {
                            continue block8;
                        }
                        if (done.add(wrapped)) continue;
                        continue block8;
                    }
                    for (String candidate : factory.getAuthorityCodes(type)) {
                        if ((candidate = candidate.trim()).length() < codeBase || Character.isLetterOrDigit(candidate.charAt(codeBase - 1)) || !authority.equalsIgnoreCase(candidate.substring(0, codeBase - 1))) {
                            code.setLength(codeBase);
                            code.append(candidate);
                            candidate = code.toString();
                        }
                        codes.add(candidate);
                    }
                }
            }
        }
        finally {
            this.inProgress.remove();
        }
        return codes;
    }

    @Override
    public InternationalString getDescriptionText(String code) throws FactoryException {
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        FactoryException failure = null;
        for (int type = 0; type < FACTORY_TYPES.length; ++type) {
            AuthorityFactory factory;
            try {
                factory = this.getAuthorityFactory(FACTORY_TYPES[type], code);
            }
            catch (NoSuchAuthorityCodeException exception) {
                if (failure != null) continue;
                failure = exception;
                continue;
            }
            if (!done.add(factory)) continue;
            try {
                return factory.getDescriptionText(code);
            }
            catch (FactoryException exception) {
                if (failure != null && !(failure.getCause() instanceof FactoryRegistryException)) continue;
                failure = exception;
            }
        }
        if (failure == null) {
            failure = this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        throw failure;
    }

    @Override
    public IdentifiedObject createObject(String code) throws FactoryException {
        HashSet<AuthorityFactory> done = new HashSet<AuthorityFactory>();
        done.add(this);
        FactoryException failure = null;
        for (int type = 0; type < FACTORY_TYPES.length; ++type) {
            AuthorityFactory factory;
            try {
                factory = this.getAuthorityFactory(FACTORY_TYPES[type], code);
            }
            catch (NoSuchAuthorityCodeException exception) {
                if (failure != null) continue;
                failure = exception;
                continue;
            }
            if (!done.add(factory)) continue;
            try {
                return factory.createObject(code);
            }
            catch (FactoryException exception) {
                if (failure != null && !(failure.getCause() instanceof FactoryRegistryException)) continue;
                failure = exception;
            }
        }
        if (failure == null) {
            failure = this.noSuchAuthorityCode(IdentifiedObject.class, code);
        }
        throw failure;
    }

    @Override
    public IdentifiedObjectFinder getIdentifiedObjectFinder(Class<? extends IdentifiedObject> type) throws FactoryException {
        return new Finder(this, type);
    }

    static class Finder
    extends IdentifiedObjectFinder {
        protected Finder(ManyAuthoritiesFactory factory, Class<? extends IdentifiedObject> type) {
            super(factory, type);
        }

        final Collection<AuthorityFactory> getFactories() {
            return ((ManyAuthoritiesFactory)this.getProxy().getAuthorityFactory()).getFactories();
        }

        final IdentifiedObjectFinder next(Iterator<AuthorityFactory> it) throws FactoryException {
            while (it.hasNext()) {
                IdentifiedObjectFinder finder;
                AuthorityFactory factory = it.next();
                if (ManyAuthoritiesFactory.exclude(factory) || !(factory instanceof AbstractAuthorityFactory) || (finder = ((AbstractAuthorityFactory)factory).getIdentifiedObjectFinder(this.getProxy().getType())) == null) continue;
                finder.setFullScanAllowed(this.isFullScanAllowed());
                return finder;
            }
            return null;
        }

        @Override
        public IdentifiedObject find(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate;
            block2: {
                IdentifiedObjectFinder finder;
                candidate = this.createFromIdentifiers(object);
                if (candidate != null) {
                    return candidate;
                }
                Collection<AuthorityFactory> factories = this.getFactories();
                if (factories == null) break block2;
                Iterator<AuthorityFactory> it = factories.iterator();
                while ((finder = this.next(it)) != null && (candidate = finder.find(object)) == null) {
                }
            }
            return candidate;
        }

        @Override
        public String findIdentifier(IdentifiedObject object) throws FactoryException {
            IdentifiedObject candidate = this.createFromIdentifiers(object);
            if (candidate != null) {
                return candidate.getName().toString();
            }
            Collection<AuthorityFactory> factories = this.getFactories();
            if (factories != null) {
                IdentifiedObjectFinder finder;
                Iterator<AuthorityFactory> it = factories.iterator();
                while ((finder = this.next(it)) != null) {
                    String id = finder.findIdentifier(object);
                    if (id == null) continue;
                    return id;
                }
            }
            return null;
        }
    }
}

