/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.parameter;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.EnumeratedParameter;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.ParameterList;
import javax.media.jai.ParameterListDescriptor;
import javax.media.jai.ParameterListImpl;
import javax.media.jai.util.Range;
import org.geotools.metadata.i18n.Errors;
import org.geotools.parameter.AbstractParameter;
import org.geotools.parameter.ImagingParameter;
import org.geotools.parameter.ImagingParameterDescriptors;
import org.geotools.referencing.AbstractIdentifiedObject;
import org.geotools.util.UnmodifiableArrayList;
import org.geotools.util.Utilities;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.InvalidParameterNameException;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterNotFoundException;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;

public class ImagingParameters
extends AbstractParameter
implements ParameterValueGroup {
    private static final long serialVersionUID = 1378692626023992530L;
    public final ParameterList parameters;
    private List<GeneralParameterValue> values;

    public ImagingParameters(ImagingParameterDescriptors descriptor) {
        super(descriptor);
        this.parameters = descriptor.operation instanceof OperationDescriptor ? new ParameterBlockJAI((OperationDescriptor)descriptor.operation, descriptor.registryMode) : new ParameterListImpl(descriptor.descriptor);
    }

    public ImagingParameters(Map<String, ?> properties, ParameterList parameters) {
        super(new ImagingParameterDescriptors(properties, parameters.getParameterListDescriptor()));
        this.parameters = parameters;
        ImagingParameters.ensureNonNull("parameters", parameters);
    }

    private static boolean compatible(ParameterDescriptor descriptor, ParameterListDescriptor listDescriptor, String[] names, Class<?>[] types, String[] enumerated) {
        String name = descriptor.getName().getCode().trim();
        Class type = null;
        if (names != null) {
            for (int i = 0; i < names.length; ++i) {
                if (!name.equalsIgnoreCase(names[i])) continue;
                type = types[i];
                break;
            }
        }
        if (type == null || !type.isAssignableFrom(descriptor.getValueClass())) {
            return false;
        }
        Range range = listDescriptor.getParamValueRange(name);
        if (range != null) {
            Comparable c = descriptor.getMinimumValue();
            if (c != null && !range.contains(c)) {
                return false;
            }
            c = descriptor.getMaximumValue();
            if (c != null && !range.contains(c)) {
                return false;
            }
        }
        if (enumerated != null) {
            for (int i = 0; i < enumerated.length; ++i) {
                if (!name.equalsIgnoreCase(enumerated[i])) continue;
                EnumeratedParameter[] restrictions = listDescriptor.getEnumeratedParameterValues(name);
                Set valids = descriptor.getValidValues();
                if (valids != null && Arrays.asList(restrictions).containsAll(valids)) continue;
                return false;
            }
        }
        return true;
    }

    private GeneralParameterValue[] createElements() {
        ImagingParameterDescriptors descriptor = (ImagingParameterDescriptors)this.descriptor;
        ParameterListDescriptor listDescriptor = this.parameters.getParameterListDescriptor();
        String[] names = listDescriptor.getParamNames();
        Class[] types = listDescriptor.getParamClasses();
        String[] enumerated = listDescriptor.getEnumeratedParameterNames();
        List<GeneralParameterDescriptor> descriptors = descriptor.descriptors();
        GeneralParameterValue[] values = new GeneralParameterValue[descriptors.size()];
        for (int i = 0; i < values.length; ++i) {
            ParameterDescriptor d = (ParameterDescriptor)descriptors.get(i);
            ImagingParameter value = ImagingParameters.compatible(d, listDescriptor, names, types, enumerated) ? new ImagingParameter(d, this.parameters) : d.createValue();
            values[i] = value;
        }
        for (int j = 0; j < values.length; ++j) {
            String name = values[j].getDescriptor().getName().getCode().trim();
            for (int i = 0; i < values.length; ++i) {
                ParameterDescriptor d;
                if (i == j || !AbstractIdentifiedObject.nameMatches((IdentifiedObject)(d = (ParameterDescriptor)values[i].getDescriptor()), name)) continue;
                throw new InvalidParameterNameException(Errors.format(154, d.getName().getCode(), j, name, i), name);
            }
        }
        this.values = UnmodifiableArrayList.wrap(values);
        return values;
    }

    @Override
    public ParameterDescriptorGroup getDescriptor() {
        return (ParameterDescriptorGroup)super.getDescriptor();
    }

    @Override
    public synchronized List<GeneralParameterValue> values() {
        if (this.values == null) {
            this.createElements();
        }
        assert (((ParameterDescriptorGroup)this.descriptor).descriptors().size() == this.values.size()) : this.values;
        return this.values;
    }

    public synchronized ParameterValue parameter(String name) throws ParameterNotFoundException {
        ImagingParameters.ensureNonNull("name", name);
        name = name.trim();
        List<GeneralParameterValue> values = this.values();
        int size = values.size();
        for (int i = 0; i < size; ++i) {
            ParameterValue value = (ParameterValue)values.get(i);
            if (!AbstractIdentifiedObject.nameMatches((IdentifiedObject)value.getDescriptor(), name)) continue;
            return value;
        }
        throw new ParameterNotFoundException(Errors.format(99, name), name);
    }

    @Override
    public List<ParameterValueGroup> groups(String name) throws ParameterNotFoundException {
        throw new ParameterNotFoundException(Errors.format(99, name), name);
    }

    @Override
    public ParameterValueGroup addGroup(String name) throws ParameterNotFoundException {
        throw new ParameterNotFoundException(Errors.format(99, name), name);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (super.equals(object)) {
            ImagingParameters that = (ImagingParameters)object;
            return Utilities.equals(this.parameters, that.parameters);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() * 37 + this.parameters.hashCode();
    }

    @Override
    public synchronized ImagingParameters clone() {
        ImagingParameters copy = (ImagingParameters)super.clone();
        try {
            Method cloneMethod = this.parameters.getClass().getMethod("clone", null);
            Field paramField = ImagingParameters.class.getField("parameters");
            paramField.setAccessible(true);
            paramField.set(copy, cloneMethod.invoke((Object)this.parameters, (Object[])null));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException("Clone not supported.", exception);
        }
        if (copy.values != null) {
            GeneralParameterValue[] cloned = copy.createElements();
            assert (this.values.size() == cloned.length) : this.values;
            for (int i = 0; i < cloned.length; ++i) {
                if (cloned[i] instanceof ImagingParameter) continue;
                cloned[i] = ((ParameterValue)this.values.get(i)).clone();
            }
        }
        return copy;
    }
}

