/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties.time;

import java.awt.RenderingHints;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.gce.imagemosaic.properties.time.TimestampFileNameExtractor;
import org.geotools.util.URLs;

public class TimestampFileNameExtractorSPI
implements PropertiesCollectorSPI {
    public static final String REGEX = "regex";
    public static final String FORMAT = "format";
    public static final String FULL_PATH = "fullPath";
    public static final String REGEX_PREFIX = "regex=";
    public static final String FORMAT_PREFIX = "format=";
    public static final String FULL_PATH_PREFIX = "fullPath=";

    @Override
    public String getName() {
        return "TimestampFileNameExtractorSPI";
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public Map<RenderingHints.Key, ?> getImplementationHints() {
        return Collections.emptyMap();
    }

    @Override
    public PropertiesCollector create(Object o, List<String> propertyNames) {
        URL source = null;
        String regex = null;
        String format = null;
        boolean fullPath = false;
        if (o instanceof URL) {
            source = (URL)o;
        } else if (o instanceof File) {
            source = URLs.fileToUrl((File)o);
        } else if (o instanceof String) {
            try {
                source = new URL((String)o);
            }
            catch (MalformedURLException e) {
                String value = (String)o;
                int idx = 0;
                if (value.startsWith(REGEX_PREFIX)) {
                    String tmp = value.substring(REGEX_PREFIX.length());
                    if (tmp.contains(",format=")) {
                        idx = tmp.indexOf(",format=");
                        regex = tmp.substring(0, idx);
                        value = tmp.substring(idx + 1);
                    } else if (tmp.contains(",fullPath=")) {
                        idx = tmp.indexOf(",fullPath=");
                        regex = tmp.substring(0, idx);
                        value = tmp.substring(idx + 1);
                    } else {
                        regex = tmp;
                    }
                }
                if (value.startsWith(FORMAT_PREFIX)) {
                    if (value.contains(",fullPath=")) {
                        idx = value.indexOf(",fullPath=");
                        format = value.substring(0, idx);
                        value = value.substring(idx + 1);
                    } else {
                        format = value;
                    }
                    format = format.substring(FORMAT_PREFIX.length());
                }
                if (value.startsWith(FULL_PATH_PREFIX)) {
                    fullPath = Boolean.valueOf(value.substring(FULL_PATH_PREFIX.length()));
                }
            }
        } else {
            return null;
        }
        if (source != null) {
            Properties properties = CoverageUtilities.loadPropertiesFromURL(source);
            regex = properties.getProperty(REGEX);
            format = properties.getProperty(FORMAT);
            String fullPathParam = properties.getProperty(FULL_PATH);
            if (fullPathParam != null && fullPathParam.trim().length() > 0) {
                fullPath = Boolean.valueOf(fullPathParam);
            }
        }
        if (regex != null) {
            regex = regex.trim();
        }
        if (format != null) {
            format = format.trim();
        }
        if (regex != null) {
            return new TimestampFileNameExtractor(this, propertyNames, regex, format, fullPath);
        }
        return null;
    }
}

