/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.properties;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.gce.imagemosaic.properties.PropertiesCollector;
import org.geotools.gce.imagemosaic.properties.PropertiesCollectorSPI;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;

class FSDateExtractor
extends PropertiesCollector {
    private static final Logger LOGGER = Logging.getLogger(FSDateExtractor.class);
    private Date date = null;

    public FSDateExtractor(PropertiesCollectorSPI spi, List<String> propertyNames) {
        super(spi, propertyNames);
    }

    @Override
    public PropertiesCollector collect(File file) {
        block2: {
            try {
                BasicFileAttributes attributes = Files.readAttributes(file.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                this.date = new Date(attributes.creationTime().to(TimeUnit.MILLISECONDS));
            }
            catch (IOException e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        return this;
    }

    @Override
    public void setProperties(SimpleFeature feature) {
        if (this.date != null) {
            for (String propertyName : this.getPropertyNames()) {
                feature.setAttribute(propertyName, (Object)this.date);
            }
        }
    }

    @Override
    public void setProperties(Map<String, Object> map) {
        if (this.date != null) {
            for (String propertyName : this.getPropertyNames()) {
                map.put(propertyName, this.date);
            }
        }
    }
}

