/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.namecollector;

import java.io.File;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollector;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollectorSPI;

public class FileNameRegexNameCollectorSPI
implements CoverageNameCollectorSPI {
    public static String REGEX = "regex";

    @Override
    public CoverageNameCollector create(Object object, Map<String, String> map) {
        String regex = null;
        if (map != null && map.containsKey(REGEX) && (regex = map.get(REGEX)) != null) {
            return new FileNameRegexBasedCoverageNameCollector(regex);
        }
        throw new IllegalArgumentException("FileNameRegexNameCollectorSPI should have a defined REGEX property in the map");
    }

    static class FileNameRegexBasedCoverageNameCollector
    implements CoverageNameCollector {
        private Pattern pattern;

        public FileNameRegexBasedCoverageNameCollector(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        @Override
        public String getName(GridCoverage2DReader reader, Map<String, String> map) {
            Object source = reader.getSource();
            Utils.SourceGetter sourceGetter = new Utils.SourceGetter(source);
            File file = sourceGetter.getFile();
            if (file == null) {
                throw new IllegalArgumentException("Unable to retrieve a valid source file for the specified reader");
            }
            String baseName = FilenameUtils.getBaseName((String)file.getAbsolutePath());
            Matcher matcher = this.pattern.matcher(baseName);
            if (matcher.find()) {
                int count = matcher.groupCount();
                String match = "";
                for (int i = 1; i <= count; ++i) {
                    match = match + matcher.group(i);
                }
                return match;
            }
            throw new IllegalArgumentException("Unable to retrieve the coverageName");
        }
    }
}

