/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.granulecollector;

import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.processing.Operations;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.MosaicElement;
import org.geotools.gce.imagemosaic.Mosaicker;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.granulecollector.BaseSubmosaicProducer;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.opengis.coverage.Coverage;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

class ReprojectingSubmosaicProducer
extends BaseSubmosaicProducer {
    private final boolean dryRun;
    private final RenderingHints renderingHints;
    private final Operations operations;
    private CoordinateReferenceSystem targetCRS;
    private List<CRSBoundMosaicProducer> perMosaicProducers = new ArrayList<CRSBoundMosaicProducer>();
    private CRSBoundMosaicProducer currentSubmosaicProducer;

    ReprojectingSubmosaicProducer(RasterLayerRequest request, RasterLayerResponse response, RasterManager rasterManager, boolean dryRun) {
        super(response, dryRun);
        this.targetCRS = rasterManager.getConfiguration().getCrs();
        this.dryRun = dryRun;
        Hints hints = rasterManager.getHints();
        this.renderingHints = ReprojectingSubmosaicProducer.createRenderingHints(hints, request);
        this.operations = new Operations(this.renderingHints);
    }

    @Override
    public boolean isReprojecting() {
        return true;
    }

    private static RenderingHints createRenderingHints(Hints hints, RasterLayerRequest request) {
        RenderingHints renderHints = new RenderingHints(null);
        if (request.getInterpolation() != null) {
            renderHints.put(JAI.KEY_INTERPOLATION, request.getInterpolation());
        }
        return renderHints;
    }

    @Override
    public boolean accept(GranuleDescriptor granuleDescriptor) {
        boolean accepted;
        boolean bl = accepted = this.currentSubmosaicProducer != null && this.currentSubmosaicProducer.accept(granuleDescriptor);
        if (!accepted) {
            CoordinateReferenceSystem targetCRS = granuleDescriptor.getGranuleEnvelope().getCoordinateReferenceSystem();
            try {
                RasterLayerResponse transformedResponse = this.rasterLayerResponse.reprojectTo(granuleDescriptor);
                if (transformedResponse == null) {
                    return false;
                }
                this.currentSubmosaicProducer = new CRSBoundMosaicProducer(transformedResponse, this.dryRun, targetCRS, granuleDescriptor);
                this.perMosaicProducers.add(this.currentSubmosaicProducer);
                accepted = true;
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to setup CRS specific sub-mosaic", e);
            }
        }
        return accepted;
    }

    protected static CoordinateReferenceSystem getCRS(String granuleCRSCode) throws FactoryException {
        return CRS.decode(granuleCRSCode);
    }

    @Override
    public List<MosaicElement> createMosaic() throws IOException {
        ArrayList<MosaicElement> mosaicInputs = new ArrayList<MosaicElement>();
        for (CRSBoundMosaicProducer mosaicProducer : this.perMosaicProducers) {
            List<MosaicElement> mosaicElement = mosaicProducer.createMosaic();
            this.hasAlpha = mosaicProducer.hasAlpha();
            try {
                for (MosaicElement e : mosaicElement) {
                    MosaicElement reprojectedMosaicElement = this.reprojectMosaicElement(e, mosaicProducer);
                    mosaicInputs.add(reprojectedMosaicElement);
                }
            }
            catch (FactoryException | TransformException e) {
                throw new IllegalStateException(e);
            }
        }
        return mosaicInputs;
    }

    private MosaicElement reprojectMosaicElement(MosaicElement mosaicElement, CRSBoundMosaicProducer mosaicProducer) throws FactoryException, TransformException {
        CoordinateReferenceSystem finalCrs = mosaicProducer.getCrs();
        if (!CRS.equalsIgnoreMetadata(this.targetCRS, finalCrs)) {
            GridCoverageFactory factory = new GridCoverageFactory(null);
            MathTransform2D finalGridToWorld = mosaicProducer.rasterLayerResponse.getFinalGridToWorldCorner();
            ReferencedEnvelope submosaicBBOX = this.computeSubmosaicBoundingBox(finalGridToWorld, mosaicElement.getSource(), finalCrs);
            GridCoverage2D submosaicCoverage = this.createCoverageFromElement(mosaicElement, factory, submosaicBBOX);
            GridCoverage2D resampledCoverage = (GridCoverage2D)this.operations.resample(submosaicCoverage, this.rasterLayerResponse.getMosaicBBox(), this.rasterLayerResponse.getRequest().getInterpolation());
            RenderedImage image = this.positionInOutputMosaic(resampledCoverage);
            Geometry geometry = Utils.reprojectEnvelopeToGeometry(submosaicBBOX, this.targetCRS, this.rasterLayerResponse.getMosaicBBox());
            if (geometry != null && geometry.getNumGeometries() > 1) {
                ReferencedEnvelope resampledImageEnvelope = this.computeSubmosaicBoundingBox(this.rasterLayerResponse.getFinalGridToWorldCorner(), image, finalCrs);
                GridCoverage2D repositionedCoverage = factory.create((CharSequence)"repositioned", image, (org.opengis.geometry.Envelope)resampledImageEnvelope);
                GridCoverage2D croppedCoverage = (GridCoverage2D)this.operations.crop((Coverage)repositionedCoverage, geometry);
                image = croppedCoverage.getRenderedImage();
            }
            PlanarImage alphaBand = image.getColorModel().hasAlpha() ? new ImageWorker(image).retainLastBand().getPlanarImage() : null;
            Object property = image.getProperty("ROI");
            ROI overallROI = property instanceof ROI ? (ROI)property : null;
            return new MosaicElement(alphaBand, overallROI, image, mosaicElement.getPamDataset());
        }
        return mosaicElement;
    }

    private GridCoverage2D createCoverageFromElement(MosaicElement mosaicElement, GridCoverageFactory factory, ReferencedEnvelope submosaicBBOX) {
        RenderedImage image = mosaicElement.getSource();
        Object roiProperty = image.getProperty("ROI");
        if (!(roiProperty instanceof ROI)) {
            ROIGeometry roi = new ROIGeometry((Geometry)JTS.toGeometry(new Envelope((double)image.getMinX(), (double)(image.getMinX() + image.getWidth()), (double)image.getMinY(), (double)(image.getMinY() + image.getHeight()))));
            ImageWorker iw = new ImageWorker(image);
            iw.setROI(roi);
            image = iw.getRenderedImage();
            roiProperty = roi;
        }
        HashMap<String, Object> properties = new HashMap<String, Object>();
        CoverageUtilities.setROIProperty(properties, (ROI)roiProperty);
        return factory.create((CharSequence)"submosaic", image, submosaicBBOX, null, null, properties);
    }

    private ReferencedEnvelope computeSubmosaicBoundingBox(MathTransform2D tx, RenderedImage image, CoordinateReferenceSystem crs) throws FactoryException {
        double[] mosaicked = new double[]{image.getMinX(), image.getMinY(), image.getMinX() + image.getWidth(), image.getMinY() + image.getHeight()};
        try {
            tx.transform(mosaicked, 0, mosaicked, 0, 2);
        }
        catch (TransformException e) {
            throw new FactoryException(e);
        }
        ReferencedEnvelope submosaicBBOX = new ReferencedEnvelope(mosaicked[0], mosaicked[2], mosaicked[1], mosaicked[3], crs);
        return submosaicBBOX;
    }

    private RenderedImage positionInOutputMosaic(GridCoverage2D resampledCoverage) {
        RenderedImage image = resampledCoverage.getRenderedImage();
        AffineTransform finalRaster2Model = new AffineTransform((AffineTransform2D)resampledCoverage.getGridGeometry().getGridToCRS());
        finalRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
        AffineTransform finalWorldToGridCorner = (AffineTransform)((Object)this.rasterLayerResponse.getFinalWorldToGridCorner());
        finalRaster2Model.preConcatenate(finalWorldToGridCorner);
        RasterLayerRequest request = this.rasterLayerResponse.getRequest();
        Interpolation interpolation = request.getInterpolation();
        Rectangle2D finalLayout = ImageUtilities.layoutHelper(image, (float)finalRaster2Model.getScaleX(), (float)finalRaster2Model.getScaleY(), (float)finalRaster2Model.getTranslateX(), (float)finalRaster2Model.getTranslateY(), interpolation);
        if (finalLayout.isEmpty()) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.info("Unable to create a granuleDescriptor " + this.toString() + " due to jai scale bug creating a null source area");
            }
            return null;
        }
        RenderingHints localHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, interpolation instanceof InterpolationNearest ? Boolean.FALSE : Boolean.TRUE);
        if (XAffineTransform.isIdentity(finalRaster2Model, 1.0E-6)) {
            return image;
        }
        ImageWorker iw = new ImageWorker(image);
        Object roi = image.getProperty("ROI");
        if (roi instanceof ROI) {
            iw.setROI((ROI)roi);
        }
        iw.setRenderingHints(localHints);
        iw.affine(finalRaster2Model, interpolation, request.getBackgroundValues());
        RenderedImage renderedImage = iw.getRenderedImage();
        if (iw.getNoData() != null) {
            PlanarImage t = PlanarImage.wrapRenderedImage(renderedImage);
            t.setProperty("GC_NODATA", new NoDataContainer(iw.getNoData()));
            renderedImage = t;
        }
        return renderedImage;
    }

    private static class CRSBoundMosaicProducer
    extends BaseSubmosaicProducer {
        private final CoordinateReferenceSystem crs;

        public CRSBoundMosaicProducer(RasterLayerResponse rasterLayerResponse, boolean dryRun, CoordinateReferenceSystem targetCRS, GranuleDescriptor templateDescriptor) {
            super(rasterLayerResponse, dryRun);
            this.crs = targetCRS;
            super.accept(templateDescriptor);
        }

        @Override
        public List<MosaicElement> createMosaic() throws IOException {
            MosaicElement mosaic = new Mosaicker(this.rasterLayerResponse, this.collectGranules(), MergeBehavior.FLAT).createMosaic(false, true);
            if (mosaic == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(mosaic);
        }

        @Override
        public boolean accept(GranuleDescriptor granuleDescriptor) {
            boolean shouldAccept = false;
            CoordinateReferenceSystem granuleCRS = granuleDescriptor.getGranuleEnvelope().getCoordinateReferenceSystem();
            shouldAccept = CRS.equalsIgnoreMetadata(granuleCRS, this.crs);
            return shouldAccept && super.accept(granuleDescriptor);
        }

        public CoordinateReferenceSystem getCrs() {
            return this.crs;
        }
    }
}

