/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.granulecollector;

import java.util.logging.Level;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.granulecollector.BaseSubmosaicProducer;
import org.geotools.util.Utilities;
import org.opengis.filter.Filter;

public class DefaultSubmosaicProducer
extends BaseSubmosaicProducer {
    private final Filter granuleFilter;

    public DefaultSubmosaicProducer(RasterLayerResponse rasterLayerResponse, Filter granuleFilter, boolean dryRun) {
        super(rasterLayerResponse, dryRun);
        this.granuleFilter = granuleFilter;
    }

    @Override
    public boolean accept(GranuleDescriptor granuleDescriptor) {
        Utilities.ensureNonNull("granuleDescriptor", granuleDescriptor);
        if (this.granuleFilter.evaluate(granuleDescriptor.getOriginator())) {
            return this.acceptGranule(granuleDescriptor);
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("We filtered out the granule " + granuleDescriptor.toString());
        }
        return false;
    }
}

