/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIRaster;
import org.geotools.coverage.grid.io.footprint.SidecarFootprintProvider;
import org.geotools.feature.FeatureTypes;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class MultiLevelROIRasterProvider
implements MultiLevelROIProvider {
    static final Logger LOGGER = Logging.getLogger(SidecarFootprintProvider.class);
    private File mosaicFolder;

    public MultiLevelROIRasterProvider(File mosaicFolder) {
        this.mosaicFolder = mosaicFolder;
    }

    @Override
    public MultiLevelROI getMultiScaleROI(SimpleFeature sf) throws IOException {
        if (sf == null) {
            return null;
        }
        Object value = sf.getAttribute("location");
        if (value != null && value instanceof String) {
            String strValue = (String)value;
            File file = Utils.getFile(strValue, this.mosaicFolder);
            MultiLevelROI result = null;
            if (file.exists() && file.canRead()) {
                try {
                    int numExternalMaskOverviews;
                    int numInternalMasks;
                    int numExternalMasks;
                    int totalMasks;
                    AbstractGridFormat format = GridFormatFinder.findFormat(file, Utils.EXCLUDE_MOSAIC_HINTS);
                    AbstractGridCoverage2DReader reader = format.getReader(file);
                    DatasetLayout layout = reader.getDatasetLayout();
                    if (layout != null && (totalMasks = (numExternalMasks = layout.getNumExternalMasks() > 0 ? layout.getNumExternalMasks() : 0) + (numInternalMasks = layout.getNumInternalMasks() > 0 ? layout.getNumInternalMasks() : 0) + (numExternalMaskOverviews = layout.getNumExternalMaskOverviews() > 0 ? layout.getNumExternalMaskOverviews() : 0)) > 0) {
                        CoordinateReferenceSystem crs = reader.getCoordinateReferenceSystem();
                        SimpleFeatureType indexSchema = sf.getFeatureType();
                        if (crs != null && indexSchema != null && indexSchema.getCoordinateReferenceSystem() != null && !CRS.equalsIgnoreMetadata(crs, indexSchema.getCoordinateReferenceSystem())) {
                            ReferencedEnvelope envelope = ReferencedEnvelope.reference(reader.getOriginalEnvelope());
                            Polygon nativeFootprint = JTS.toGeometry(envelope);
                            SimpleFeatureType ftNative = FeatureTypes.transform(indexSchema, reader.getCoordinateReferenceSystem());
                            SimpleFeatureBuilder fb = new SimpleFeatureBuilder(ftNative);
                            fb.init(sf);
                            fb.set(indexSchema.getGeometryDescriptor().getLocalName(), (Object)nativeFootprint);
                            SimpleFeature nativeFeature = fb.buildFeature(sf.getID());
                            return new MultiLevelROIRaster(layout, file, nativeFeature);
                        }
                        return new MultiLevelROIRaster(layout, file, sf);
                    }
                }
                catch (Exception e) {
                    throw new IOException("Failed to load the footprint for granule " + strValue, e);
                }
            }
            return result;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Could not use the location attribute value to search for the file, the value was: " + value);
        }
        return null;
    }

    @Override
    public void dispose() {
    }
}

