/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.footprint.FootprintLoader;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.footprint.MultiLevelROIProvider;
import org.geotools.coverage.grid.io.footprint.SidecarFootprintProvider;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.MultiLevelROIGeometryOverviews;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;

public class MultiLevelROIGeometryOverviewsProvider
implements MultiLevelROIProvider {
    public static final int LOOK_FOR_OVERVIEWS = Integer.MIN_VALUE;
    public static final String OVERVIEWS_SUFFIX_FORMAT_KEY = "overviewsSuffixFormat";
    public static final String DEFAULT_OVERVIEWS_SUFFIX_FORMAT = "_%d";
    public static final boolean DEFAULT_OVERVIEWS_ROI_IN_RASTER_SPACE = false;
    public static final String OVERVIEWS_ROI_IN_RASTER_SPACE_KEY = "overviewsRoiInRasterSpace";
    public static final String FOOTPRINT_LOADER_SPI = "footprintLoaderSPI";
    public static final String OVERVIEWS_FOOTPRINT_LOADER_SPI = "overviewsFootprintLoaderSPI";
    private String overviewSuffixFormat;
    private File baseFile;
    private int numOverviews;
    private FootprintLoader footprintLoader;
    private FootprintLoader overviewsFootprintLoader;
    private SidecarFootprintProvider footprintProvider;
    private Hints hints;
    private boolean overviewsRoiInRasterSpace;

    public MultiLevelROIGeometryOverviewsProvider(File baseFile, String overviewSuffixFormat, int numOverviews, FootprintLoader footprintLoader, FootprintLoader overviewsFootprintLoader, boolean overviewsRoiInRasterSpace, Hints hints) {
        this.overviewSuffixFormat = overviewSuffixFormat;
        this.baseFile = baseFile;
        this.footprintLoader = footprintLoader;
        this.overviewsFootprintLoader = overviewsFootprintLoader;
        this.numOverviews = numOverviews;
        this.overviewsRoiInRasterSpace = overviewsRoiInRasterSpace;
        this.hints = hints;
        if (footprintLoader == null) {
            this.footprintProvider = new SidecarFootprintProvider(baseFile);
        }
    }

    @Override
    public MultiLevelROI getMultiScaleROI(SimpleFeature sf) throws IOException {
        String path = this.getPath(sf);
        String baseFullName = this.getBaseFullName(path);
        AbstractGridCoverage2DReader reader = null;
        try {
            Geometry footprint = this.loadFootprint(baseFullName, false);
            int nOverviews = this.numOverviews;
            if (this.numOverviews == Integer.MIN_VALUE) {
                File file = new File(path);
                AbstractGridFormat format = GridFormatFinder.findFormat(file, Utils.EXCLUDE_MOSAIC_HINTS);
                reader = format.getReader(file);
                DatasetLayout layout = reader.getDatasetLayout();
                int extOv = layout.getNumExternalOverviews();
                int intOv = layout.getNumInternalOverviews();
                this.numOverviews = nOverviews = (extOv > 0 ? extOv : 0) + (intOv > 0 ? intOv : 0);
            }
            ArrayList<Geometry> footprintOverviews = new ArrayList<Geometry>(nOverviews);
            for (int i = 0; i < nOverviews; ++i) {
                String pathOverview = baseFullName + String.format(this.overviewSuffixFormat, i + 1);
                Geometry overviewFootprint = this.loadFootprint(pathOverview, true);
                footprintOverviews.add(overviewFootprint);
            }
            MultiLevelROIGeometryOverviews multiLevelROIGeometryOverviews = new MultiLevelROIGeometryOverviews(footprint, footprintOverviews, this.overviewsRoiInRasterSpace, this.hints);
            return multiLevelROIGeometryOverviews;
        }
        catch (Exception e) {
            throw new IOException("Exception occurred while loading footprints ", e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private String getBaseFullName(String path) {
        String baseName = FilenameUtils.getBaseName((String)path);
        String fullPath = FilenameUtils.getFullPath((String)path);
        return fullPath + File.separatorChar + baseName;
    }

    private String getPath(SimpleFeature sf) throws IOException {
        String path = null;
        if (sf == null) {
            path = this.baseFile.getAbsolutePath();
        } else {
            Object value = sf.getAttribute("location");
            if (value != null && value instanceof String) {
                String strValue = (String)value;
                File file = Utils.getFile(strValue, this.baseFile);
                path = file.getAbsolutePath();
            }
        }
        return path;
    }

    private Geometry loadFootprint(String baseFullName, boolean isOverview) throws Exception {
        FootprintLoader loader;
        FootprintLoader footprintLoader = loader = isOverview ? this.footprintLoader : this.overviewsFootprintLoader;
        if (loader != null) {
            return loader.loadFootprint(baseFullName);
        }
        return this.footprintProvider.getFootprint(baseFullName);
    }

    private List<File> loadFootprintFiles(String baseFullName, boolean isOverview) throws IOException {
        FootprintLoader loader;
        FootprintLoader footprintLoader = loader = isOverview ? this.footprintLoader : this.overviewsFootprintLoader;
        if (loader != null) {
            return loader.getFootprintFiles(baseFullName);
        }
        return this.footprintProvider.getSidecars(baseFullName);
    }

    @Override
    public void dispose() {
    }

    @Override
    public List<File> getFootprintFiles(SimpleFeature feature) throws IOException {
        this.getMultiScaleROI(feature);
        ArrayList<File> result = new ArrayList<File>();
        String path = this.getPath(feature);
        String baseFullName = this.getBaseFullName(path);
        result.addAll(this.loadFootprintFiles(baseFullName, false));
        for (int i = 0; i < this.numOverviews; ++i) {
            String pathOverview = baseFullName + String.format(this.overviewSuffixFormat, i + 1);
            result.addAll(this.loadFootprintFiles(pathOverview, true));
        }
        return result;
    }
}

