/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.geotools.data.DataAccess;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.LockingManager;
import org.geotools.data.Query;
import org.geotools.data.ServiceInfo;
import org.geotools.data.Transaction;
import org.geotools.data.collection.DelegateFeatureReader;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.util.SoftValueHashMap;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.opengis.filter.Filter;

class DataAccessStoreWrapper
implements DataStore {
    DataAccess delegate;
    SoftValueHashMap<String, Name> NAME_CACHE = new SoftValueHashMap();

    public DataAccessStoreWrapper(DataAccess<FeatureType, Feature> delegate) {
        this.delegate = delegate;
    }

    @Override
    public ServiceInfo getInfo() {
        return this.delegate.getInfo();
    }

    @Override
    public void createSchema(SimpleFeatureType featureType) throws IOException {
        this.delegate.createSchema(featureType);
    }

    @Override
    public void updateSchema(Name typeName, SimpleFeatureType featureType) throws IOException {
        this.delegate.updateSchema(typeName, featureType);
    }

    @Override
    public void removeSchema(Name typeName) throws IOException {
        this.delegate.removeSchema(typeName);
    }

    @Override
    public List getNames() throws IOException {
        return this.delegate.getNames();
    }

    @Override
    public SimpleFeatureType getSchema(Name name) throws IOException {
        Object schema = this.delegate.getSchema(name);
        if (schema instanceof SimpleFeatureType) {
            return (SimpleFeatureType)schema;
        }
        return null;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(Name typeName) throws IOException {
        return DataUtilities.simple(this.delegate.getFeatureSource(typeName));
    }

    @Override
    public void dispose() {
        this.delegate.dispose();
    }

    @Override
    public void updateSchema(String typeName, SimpleFeatureType featureType) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        this.delegate.updateSchema(name, featureType);
    }

    @Override
    public void removeSchema(String typeName) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        this.delegate.removeSchema(name);
    }

    @Override
    public String[] getTypeNames() throws IOException {
        List<Name> names = this.delegate.getNames();
        String[] typeNames = (String[])names.stream().map(name -> name.getLocalPart()).distinct().sorted().toArray(String[]::new);
        return typeNames;
    }

    @Override
    public SimpleFeatureType getSchema(String typeName) throws IOException {
        Name name = this.getNameFromLocal(typeName);
        Object schema = this.delegate.getSchema(name);
        if (schema instanceof SimpleFeatureType) {
            return (SimpleFeatureType)schema;
        }
        return null;
    }

    @Override
    public SimpleFeatureSource getFeatureSource(String typeName) throws IOException {
        if (this.delegate instanceof DataStore) {
            return ((DataStore)this.delegate).getFeatureSource(typeName);
        }
        Name name = this.getNameFromLocal(typeName);
        return DataUtilities.simple(this.delegate.getFeatureSource(name));
    }

    private Name getNameFromLocal(String typeName) throws IOException {
        Name result = this.NAME_CACHE.get(typeName);
        if (result == null) {
            Stream stream = this.delegate.getNames().stream();
            Set names = stream.filter(name -> typeName.equals(name.getLocalPart())).collect(Collectors.toSet());
            if (names.isEmpty()) {
                throw new IOException("Could not find a type name '" + typeName + "'");
            }
            if (names.size() > 1) {
                throw new IOException("Found multiple matches for '" + typeName + "': " + names);
            }
            result = (Name)names.iterator().next();
            this.NAME_CACHE.put(typeName, result);
        }
        return result;
    }

    @Override
    public FeatureReader<SimpleFeatureType, SimpleFeature> getFeatureReader(Query query, Transaction transaction) throws IOException {
        SimpleFeatureSource fs = this.getFeatureSource(query.getTypeName());
        if (fs == null) {
            throw new IOException("Could not find feature type mentioned in query: '" + query.getTypeName() + "'");
        }
        if (fs instanceof SimpleFeatureStore) {
            ((SimpleFeatureStore)fs).setTransaction(transaction);
        }
        SimpleFeatureIterator iterator = fs.getFeatures().features();
        return new DelegateFeatureReader<SimpleFeatureType, SimpleFeature>((SimpleFeatureType)fs.getSchema(), iterator);
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Filter filter, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriter(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public FeatureWriter<SimpleFeatureType, SimpleFeature> getFeatureWriterAppend(String typeName, Transaction transaction) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public LockingManager getLockingManager() {
        return null;
    }

    public boolean wraps(DataAccess access) {
        return this.delegate == access;
    }
}

