/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.Histogram;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.ROI;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.visitor.DefaultFilterVisitor;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicDatastoreWalker;
import org.geotools.gce.imagemosaic.ImageMosaicDirectoryWalker;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicReader;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.SampleImage;
import org.geotools.gce.imagemosaic.catalog.CatalogConfigurationBean;
import org.geotools.gce.imagemosaic.catalog.index.Indexer;
import org.geotools.gce.imagemosaic.catalog.index.IndexerUtils;
import org.geotools.gce.imagemosaic.catalog.index.ObjectFactory;
import org.geotools.gce.imagemosaic.catalog.index.ParametersType;
import org.geotools.gce.imagemosaic.catalogbuilder.CatalogBuilderConfiguration;
import org.geotools.gce.imagemosaic.granulecollector.ReprojectingSubmosaicProducerFactory;
import org.geotools.geometry.jts.Decimator;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.LiteCoordinateSequence;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.image.io.ImageIOExt;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.Converters;
import org.geotools.util.Range;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;
import org.locationtech.jts.operation.overlay.snap.GeometrySnapper;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.spatial.BBOX;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Utils {
    public static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final String DATABASE_KEY = "database";
    private static final String MVCC_KEY = "MVCC";
    private static final double RESOLUTION_TOLERANCE_FACTOR = 0.01;
    public static final Hints.Key EXCLUDE_MOSAIC = new Hints.Key(Boolean.class);
    public static final Hints EXCLUDE_MOSAIC_HINTS = new Hints(EXCLUDE_MOSAIC, true);
    public static final Hints.Key CHECK_AUXILIARY_METADATA = new Hints.Key(Boolean.class);
    public static final Hints.Key AUXILIARY_FILES_PATH = new Hints.Key(String.class);
    public static final Hints.Key AUXILIARY_DATASTORE_PATH = new Hints.Key(String.class);
    public static final Hints.Key PARENT_DIR = new Hints.Key(String.class);
    public static final Hints.Key MOSAIC_READER = new Hints.Key(ImageMosaicReader.class);
    public static final String RANGE_SPLITTER_CHAR = ";";
    private static JAXBContext CONTEXT = null;
    public static final String PAM_DATASET = "PamDataset";
    static final String DEFAULT = "default";
    public static final String PROPERTIES_SEPARATOR = ";";
    private static Cache ehcache;
    public static final double[][] RGB_TO_GRAY_MATRIX;
    static final boolean OPTIMIZE_CROP;
    static final double DEFAULT_LINESTRING_DECIMATION_SPAN = 0.8;
    static final int DEFAULT_COORDS_DECIMATION_THRESHOLD = 200;
    private static final int COORDS_DECIMATION_THRESHOLD;
    private static final Logger LOGGER;
    public static final String DEFAULT_WILCARD = "*.*";
    public static final boolean DEFAULT_PATH_BEHAVIOR = false;
    private static final boolean DEFAULT_CACHING_BEHAVIOR = false;
    public static final int DEFAULT_PRIORITY = 5;
    public static final String DEFAULT_LOCATION_ATTRIBUTE = "location";
    public static final String DEFAULT_INDEX_NAME = "index";
    public static final DataStoreFactorySpi SHAPE_SPI;
    static final String DIRECT_KAKADU_PLUGIN = "it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader";
    public static final boolean DEFAULT_RECURSION_BEHAVIOR = true;
    static final Color TRANSPARENT;
    public static final boolean DEFAULT_FOOTPRINT_MANAGEMENT = true;
    public static final boolean DEFAULT_CONFIGURATION_CACHING = false;
    static final double SAMEBBOX_THRESHOLD_FACTOR = 20.0;
    public static final boolean DEFAULT_COLOR_EXPANSION_BEHAVIOR = false;
    public static final TimeZone UTC_TIME_ZONE;
    static final String DESCENDING_ORDER_IDENTIFIER = " D";
    static final String ASCENDING_ORDER_IDENTIFIER = " A";
    public static final String SCAN_FOR_TYPENAMES = "TypeNames";
    public static final String SAMPLE_IMAGE_NAME_LEGACY = "sample_image";
    public static final String SAMPLE_IMAGE_NAME = "sample_image.dat";
    public static final String BBOX = "BOUNDINGBOX";
    public static final String TIME_DOMAIN = "TIME";
    public static final String ELEVATION_DOMAIN = "ELEVATION";
    public static final String CRS_DOMAIN = "CRS";
    public static final String RESOLUTION_DOMAIN = "RESOLUTION";
    public static final String RESOLUTION_X_DOMAIN = "RESOLUTION_X";
    public static final String RESOLUTION_Y_DOMAIN = "RESOLUTION_Y";
    public static final String ADDITIONAL_DOMAIN = "ADDITIONAL";
    public static ObjectFactory OBJECT_FACTORY;
    static IOFileFilter CLEANUP_FILTER;
    static IOFileFilter MOSAIC_SUPPORT_FILES_FILTER;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createMosaic(String location, String indexName, String wildcard, boolean absolutePath, Hints hints) {
        CatalogBuilderConfiguration configuration = new CatalogBuilderConfiguration();
        configuration.setHints(hints);
        List<ParametersType.Parameter> parameterList = configuration.getIndexer().getParameters().getParameter();
        IndexerUtils.setParam(parameterList, "AbsolutePath", Boolean.toString(absolutePath));
        IndexerUtils.setParam(parameterList, "RootMosaicDirectory", location);
        IndexerUtils.setParam(parameterList, "Name", indexName);
        IndexerUtils.setParam(parameterList, "Wildcard", wildcard);
        IndexerUtils.setParam(parameterList, "IndexingDirectories", location);
        ImageMosaicEventHandlers eventHandler = new ImageMosaicEventHandlers();
        ImageMosaicConfigHandler catalogHandler = new ImageMosaicConfigHandler(configuration, eventHandler);
        ImageMosaicWalker walker = catalogHandler.isUseExistingSchema() ? new ImageMosaicDatastoreWalker(catalogHandler, eventHandler) : new ImageMosaicDirectoryWalker(catalogHandler, eventHandler);
        final LinkedList exceptions = new LinkedList();
        try {
            ImageMosaicEventHandlers.ProcessingEventListener listener = new ImageMosaicEventHandlers.ProcessingEventListener(){

                @Override
                public void exceptionOccurred(ImageMosaicEventHandlers.ExceptionEvent event) {
                    Exception t = event.getException();
                    exceptions.add(t);
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, t.getLocalizedMessage(), t);
                    }
                }

                @Override
                public void getNotification(ImageMosaicEventHandlers.ProcessingEvent event) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine(event.getMessage());
                    }
                }
            };
            eventHandler.addProcessingEventListener(listener);
            walker.run();
        }
        catch (Throwable e) {
            LOGGER.log(Level.SEVERE, "Unable to build mosaic", e);
            boolean bl = false;
            return bl;
        }
        finally {
            catalogHandler.dispose();
        }
        return exceptions.size() <= 0;
    }

    private static IOFileFilter initCleanUpFilter() {
        IOFileFilter filesFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"properties"), FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"sbn"), FileFilterUtils.suffixFileFilter((String)"sbx"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"qix"), FileFilterUtils.suffixFileFilter((String)"lyr"), FileFilterUtils.suffixFileFilter((String)"prj"), FileFilterUtils.suffixFileFilter((String)"ncx"), FileFilterUtils.suffixFileFilter((String)"gbx9"), FileFilterUtils.suffixFileFilter((String)"ncx2"), FileFilterUtils.suffixFileFilter((String)"ncx3"), FileFilterUtils.nameFileFilter((String)"error.txt"), FileFilterUtils.nameFileFilter((String)"_metadata"), FileFilterUtils.suffixFileFilter((String)SAMPLE_IMAGE_NAME), FileFilterUtils.suffixFileFilter((String)SAMPLE_IMAGE_NAME_LEGACY), FileFilterUtils.nameFileFilter((String)"error.txt.lck"), FileFilterUtils.suffixFileFilter((String)"xml"), FileFilterUtils.suffixFileFilter((String)"db")});
        return filesFilter;
    }

    private static IOFileFilter initMosaicSupportFilesFilter() {
        IOFileFilter filesFilter = FileFilterUtils.or((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.suffixFileFilter((String)"properties"), FileFilterUtils.suffixFileFilter((String)"shp"), FileFilterUtils.suffixFileFilter((String)"dbf"), FileFilterUtils.suffixFileFilter((String)"sbn"), FileFilterUtils.suffixFileFilter((String)"sbx"), FileFilterUtils.suffixFileFilter((String)"shx"), FileFilterUtils.suffixFileFilter((String)"qix"), FileFilterUtils.suffixFileFilter((String)"lyr"), FileFilterUtils.suffixFileFilter((String)"prj"), FileFilterUtils.suffixFileFilter((String)SAMPLE_IMAGE_NAME), FileFilterUtils.suffixFileFilter((String)SAMPLE_IMAGE_NAME_LEGACY), FileFilterUtils.suffixFileFilter((String)"db")});
        return filesFilter;
    }

    public static String getMessageFromException(Exception exception) {
        if (exception.getLocalizedMessage() != null) {
            return exception.getLocalizedMessage();
        }
        return exception.getMessage();
    }

    static MosaicConfigurationBean loadMosaicProperties(URL sourceURL) {
        return Utils.loadMosaicProperties(sourceURL, null);
    }

    private static MosaicConfigurationBean loadMosaicProperties(URL sourceURL, Set<String> ignorePropertiesSet) {
        File mosaicParentFolder;
        Indexer indexer;
        String noDataStr;
        String crsCode;
        String coverageNameCollectorSpi;
        String pathType;
        String attribute;
        String[] pair;
        String[] pairs;
        Properties properties;
        boolean ignoreSome;
        CatalogConfigurationBean catalogConfigurationBean;
        MosaicConfigurationBean retValue;
        block59: {
            String bboxString;
            File sourceFile;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Trying to load properties file from URL:" + sourceURL);
            }
            retValue = new MosaicConfigurationBean();
            catalogConfigurationBean = new CatalogConfigurationBean();
            retValue.setCatalogConfigurationBean(catalogConfigurationBean);
            ignoreSome = ignorePropertiesSet != null && !ignorePropertiesSet.isEmpty();
            URL propsURL = sourceURL;
            if (!sourceURL.toExternalForm().endsWith(".properties") && (propsURL = URLs.changeUrlExt(sourceURL, "properties")).getProtocol().equals("file") && !(sourceFile = URLs.urlToFile(propsURL)).exists()) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("properties file doesn't exist");
                }
                return null;
            }
            properties = CoverageUtilities.loadPropertiesFromURL(propsURL);
            if (properties == null) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Unable to load mosaic properties file");
                }
                return null;
            }
            pairs = null;
            pair = null;
            if (!(ignoreSome && ignorePropertiesSet.contains("Envelope2D") || (bboxString = properties.getProperty("Envelope2D", null)) == null)) {
                bboxString = bboxString.trim();
                try {
                    ReferencedEnvelope bbox = Utils.parseEnvelope(bboxString);
                    if (bbox != null) {
                        retValue.setEnvelope(bbox);
                    } else if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("Cannot parse imposed bbox.");
                    }
                }
                catch (Exception e) {
                    if (!LOGGER.isLoggable(Level.INFO)) break block59;
                    LOGGER.log(Level.INFO, "Cannot parse imposed bbox.", e);
                }
            }
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("AuxiliaryFile")) {
            retValue.setAuxiliaryFilePath(properties.getProperty("AuxiliaryFile"));
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("AuxiliaryDatastoreFile")) {
            retValue.setAuxiliaryDatastorePath(properties.getProperty("AuxiliaryDatastoreFile"));
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("CheckAuxiliaryMetadata")) {
            boolean checkAuxiliaryMetadata = Boolean.valueOf(properties.getProperty("CheckAuxiliaryMetadata", "false").trim());
            retValue.setCheckAuxiliaryMetadata(checkAuxiliaryMetadata);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Levels")) {
            int levelsNumber = Integer.parseInt(properties.getProperty("LevelsNum", "1").trim());
            retValue.setLevelsNum(levelsNumber);
            if (!properties.containsKey("Levels")) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Required key Levels not found.");
                }
                return null;
            }
            String levels = properties.getProperty("Levels").trim();
            pairs = levels.split(" ");
            if (pairs.length != levelsNumber) {
                if (LOGGER.isLoggable(Level.INFO)) {
                    LOGGER.info("Levels number is different from the provided number of levels resoltion.");
                }
                return null;
            }
            double[][] resolutions = new double[levelsNumber][2];
            for (int i = 0; i < levelsNumber; ++i) {
                pair = pairs[i].split(",");
                if (pair == null || pair.length != 2) {
                    if (LOGGER.isLoggable(Level.INFO)) {
                        LOGGER.info("OverviewLevel number is different from the provided number of levels resoltion.");
                    }
                    return null;
                }
                resolutions[i][0] = Double.parseDouble(pair[0]);
                resolutions[i][1] = Double.parseDouble(pair[1]);
            }
            retValue.setLevels(resolutions);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("TypeName")) {
            String typeName = properties.getProperty("TypeName", null);
            catalogConfigurationBean.setTypeName(typeName);
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("SuggestedSPI") || !properties.containsKey("SuggestedSPI"))) {
            String suggestedSPI = properties.getProperty("SuggestedSPI").trim();
            catalogConfigurationBean.setSuggestedSPI(suggestedSPI);
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("SuggestedFormat") || !properties.containsKey("SuggestedFormat"))) {
            String suggestedFormat = properties.getProperty("SuggestedFormat").trim();
            catalogConfigurationBean.setSuggestedFormat(suggestedFormat);
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("SuggestedIsSPI") || !properties.containsKey("SuggestedIsSPI"))) {
            String suggestedIsSpi = properties.getProperty("SuggestedIsSPI").trim();
            catalogConfigurationBean.setSuggestedIsSPI(suggestedIsSpi);
        }
        if (properties.containsKey("TimeAttribute")) {
            String timeAttribute = properties.getProperty("TimeAttribute").trim();
            retValue.setTimeAttribute(timeAttribute);
        }
        if (properties.containsKey("ElevationAttribute")) {
            String elevationAttribute = properties.getProperty("ElevationAttribute").trim();
            retValue.setElevationAttribute(elevationAttribute);
        }
        if (properties.containsKey("CrsAttribute")) {
            String crsAttribute = properties.getProperty("CrsAttribute").trim();
            retValue.setCRSAttribute(crsAttribute);
        }
        if (properties.containsKey("ResolutionAttribute")) {
            attribute = properties.getProperty("ResolutionAttribute").trim();
            retValue.setResolutionAttribute(attribute);
        }
        if (properties.containsKey("ResolutionXAttribute")) {
            attribute = properties.getProperty("ResolutionXAttribute").trim();
            retValue.setResolutionXAttribute(attribute);
        }
        if (properties.containsKey("ResolutionYAttribute")) {
            attribute = properties.getProperty("ResolutionYAttribute").trim();
            retValue.setResolutionYAttribute(attribute);
        }
        if (properties.containsKey("AdditionalDomainAttributes")) {
            String additionalDomainAttributes = properties.getProperty("AdditionalDomainAttributes").trim();
            retValue.setAdditionalDomainAttributes(additionalDomainAttributes);
        }
        if (properties.containsKey("Caching")) {
            String caching = properties.getProperty("Caching").trim();
            try {
                catalogConfigurationBean.setCaching(Boolean.valueOf(caching));
            }
            catch (Throwable e) {
                catalogConfigurationBean.setCaching(false);
            }
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Name")) {
            if (!properties.containsKey("Name")) {
                if (LOGGER.isLoggable(Level.SEVERE)) {
                    LOGGER.severe("Required key Name not found.");
                }
                return null;
            }
            String coverageName = properties.getProperty("Name").trim();
            retValue.setName(coverageName);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("ExpandToRGB")) {
            boolean expandMe = Boolean.valueOf(properties.getProperty("ExpandToRGB", "false").trim());
            retValue.setExpandToRGB(expandMe);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("WrapStore")) {
            boolean wrapStore = Boolean.valueOf(properties.getProperty("WrapStore", "false").trim());
            catalogConfigurationBean.setWrapStore(wrapStore);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("Heterogeneous")) {
            boolean heterogeneous = Boolean.valueOf(properties.getProperty("Heterogeneous", "false").trim());
            catalogConfigurationBean.setHeterogeneous(heterogeneous);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("HeterogeneousCRS")) {
            boolean heterogeneousCRS = Boolean.valueOf(properties.getProperty("HeterogeneousCRS", "false").trim());
            if (!catalogConfigurationBean.isHeterogeneous()) {
                catalogConfigurationBean.setHeterogeneous(heterogeneousCRS);
            }
            catalogConfigurationBean.setHeterogeneousCRS(heterogeneousCRS);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("AbsolutePath")) {
            boolean absolutePath = Boolean.valueOf(properties.getProperty("AbsolutePath", Boolean.toString(false)).trim());
            if (absolutePath) {
                catalogConfigurationBean.setPathType(PathType.ABSOLUTE);
            } else {
                catalogConfigurationBean.setPathType(PathType.RELATIVE);
            }
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("PathType") || (pathType = properties.getProperty("PathType")) == null)) {
            catalogConfigurationBean.setPathType(PathType.valueOf(pathType.trim()));
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("FootprintManagement")) {
            boolean footprintManagement = Boolean.valueOf(properties.getProperty("FootprintManagement", "false").trim());
            retValue.setFootprintManagement(footprintManagement);
        }
        if (!ignoreSome || !ignorePropertiesSet.contains("LocationAttribute")) {
            catalogConfigurationBean.setLocationAttribute(properties.getProperty("LocationAttribute", DEFAULT_LOCATION_ATTRIBUTE).trim());
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("CoverageNameCollectorSPI") || (coverageNameCollectorSpi = properties.getProperty("CoverageNameCollectorSPI")) == null || (coverageNameCollectorSpi = coverageNameCollectorSpi.trim()) == null)) {
            retValue.setCoverageNameCollectorSpi(coverageNameCollectorSpi);
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("MosaicCRS") || (crsCode = properties.getProperty("MosaicCRS")) == null || crsCode.isEmpty())) {
            try {
                retValue.setCrs(Utils.decodeSrs(crsCode));
            }
            catch (FactoryException e) {
                LOGGER.log(Level.FINE, "Unable to decode CRS of mosaic properties file. Configured CRS code was: " + crsCode, e);
            }
        }
        if (!(ignoreSome && ignorePropertiesSet.contains("NoData") || (noDataStr = properties.getProperty("NoData")) == null || noDataStr.isEmpty())) {
            try {
                double noData = Double.parseDouble(noDataStr);
                retValue.setNoData(noData);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.FINE, "Unable to decode NoData of mosaic properties file. Configured NoData code was: " + noDataStr, e);
            }
        }
        if ((indexer = Utils.loadIndexer(mosaicParentFolder = URLs.urlToFile(sourceURL).getParentFile())) != null) {
            boolean isHeterogeneousCRS;
            retValue.setIndexer(indexer);
            String granuleCollectorFactorySPI = IndexerUtils.getParameter("GranuleCollectorFactory", indexer);
            if ((granuleCollectorFactorySPI == null || granuleCollectorFactorySPI.length() <= 0) && (isHeterogeneousCRS = Boolean.parseBoolean(IndexerUtils.getParameter("HeterogeneousCRS", indexer)))) {
                IndexerUtils.setParam(indexer, "GranuleCollectorFactory", ReprojectingSubmosaicProducerFactory.class.getName());
            }
        }
        return retValue;
    }

    private static CoordinateReferenceSystem decodeSrs(String property) throws FactoryException {
        return CRS.decode(property, true);
    }

    private static Indexer loadIndexer(File parentFolder) {
        Indexer defaultIndexer = IndexerUtils.createDefaultIndexer();
        Indexer configuredIndexer = IndexerUtils.initializeIndexer(defaultIndexer.getParameters(), parentFolder);
        return configuredIndexer;
    }

    public static ReferencedEnvelope parseEnvelope(String bboxString) {
        if (bboxString == null || bboxString.length() == 0) {
            return null;
        }
        String[] pairs = bboxString.split(" ");
        if (pairs != null && pairs.length == 2) {
            String[] pair1 = pairs[0].split(",");
            String[] pair2 = pairs[1].split(",");
            if (pair1 != null && pair1.length == 2 && pair2 != null && pair2.length == 2) {
                return new ReferencedEnvelope(Double.parseDouble(pair1[0]), Double.parseDouble(pair2[0]), Double.parseDouble(pair1[1]), Double.parseDouble(pair2[1]), null);
            }
        }
        return null;
    }

    public static IOFileFilter excludeFilters(IOFileFilter inputFilter, IOFileFilter ... filters) {
        IOFileFilter retFilter = inputFilter;
        for (IOFileFilter filter : filters) {
            retFilter = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{retFilter, FileFilterUtils.notFileFilter((IOFileFilter)filter)});
        }
        return retFilter;
    }

    static ImageReader getReader(ImageInputStream inStream) {
        Utilities.ensureNonNull("inStream", inStream);
        inStream.mark();
        Iterator<ImageReader> readersIt = ImageIO.getImageReaders(inStream);
        if (!readersIt.hasNext()) {
            return null;
        }
        return readersIt.next();
    }

    static Rectangle getDimension(int imageIndex, ImageReader reader) throws IOException {
        Utilities.ensureNonNull("reader", reader);
        if (imageIndex < 0) {
            throw new IllegalArgumentException(Errors.format(79, imageIndex));
        }
        return new Rectangle(0, 0, reader.getWidth(imageIndex), reader.getHeight(imageIndex));
    }

    public static boolean checkFileReadable(File file) {
        if (LOGGER.isLoggable(Level.FINE)) {
            String message = Utils.getFileInfo(file);
            LOGGER.fine(message);
        }
        return file.exists() && file.canRead() && file.isFile();
    }

    public static String getFileInfo(File file) {
        StringBuilder builder = new StringBuilder();
        builder.append("Checking file:").append(FilenameUtils.getFullPath((String)file.getAbsolutePath())).append("\n");
        builder.append("isHidden:").append(file.isHidden()).append("\n");
        builder.append("exists:").append(file.exists()).append("\n");
        builder.append("isFile").append(file.isFile()).append("\n");
        builder.append("canRead:").append(file.canRead()).append("\n");
        builder.append("canWrite").append(file.canWrite()).append("\n");
        builder.append("canExecute:").append(file.canExecute()).append("\n");
        builder.append("isAbsolute:").append(file.isAbsolute()).append("\n");
        builder.append("lastModified:").append(file.lastModified()).append("\n");
        builder.append("length:").append(file.length());
        String message = builder.toString();
        return message;
    }

    public static String checkDirectory(String testingDirectory, boolean writable) throws IllegalArgumentException {
        boolean failure;
        File inDir = new File(testingDirectory);
        boolean bl = failure = !inDir.exists() || !inDir.isDirectory() || inDir.isHidden() || !inDir.canRead();
        if (writable) {
            failure |= !inDir.canWrite();
        }
        if (failure) {
            String message = "Unable to create the mosaic\nlocation is:" + testingDirectory + "\nlocation exists:" + inDir.exists() + "\nlocation is a directory:" + inDir.isDirectory() + "\nlocation is writable:" + inDir.canWrite() + "\nlocation is readable:" + inDir.canRead() + "\nlocation is hidden:" + inDir.isHidden() + "\n";
            LOGGER.severe(message);
            throw new IllegalArgumentException(message);
        }
        try {
            testingDirectory = inDir.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        testingDirectory = FilenameUtils.normalize((String)testingDirectory);
        if (!testingDirectory.endsWith(File.separator)) {
            testingDirectory = testingDirectory + File.separator;
        }
        boolean bl2 = failure = !(inDir = new File(testingDirectory)).exists() || !inDir.isDirectory() || inDir.isHidden() || !inDir.canRead();
        if (writable) {
            failure |= !inDir.canWrite();
        }
        if (failure) {
            String message = "Unable to create the mosaic\nlocation is:" + testingDirectory + "\nlocation exists:" + inDir.exists() + "\nlocation is a directory:" + inDir.isDirectory() + "\nlocation is writable:" + inDir.canWrite() + "\nlocation is readable:" + inDir.canRead() + "\nlocation is hidden:" + inDir.isHidden() + "\n";
            LOGGER.severe(message);
            throw new IllegalArgumentException(message);
        }
        return testingDirectory;
    }

    static boolean checkURLReadable(URL url) {
        try {
            url.openStream().close();
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static Map<String, Serializable> createDataStoreParamsFromPropertiesFile(URL datastoreProperties) throws IOException {
        Properties properties = CoverageUtilities.loadPropertiesFromURL(datastoreProperties);
        if (properties == null) {
            return null;
        }
        String SPIClass = properties.getProperty("SPI");
        try {
            DataStoreFactorySpi spi = (DataStoreFactorySpi)Class.forName(SPIClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            return Utils.createDataStoreParamsFromPropertiesFile(properties, spi);
        }
        catch (Exception e) {
            IOException ioe = new IOException();
            throw (IOException)ioe.initCause(e);
        }
    }

    public static void storeSampleImage(File sampleImageFile, SampleModel defaultSM, ColorModel defaultCM) throws IOException {
        SampleImage sampleImage = new SampleImage(defaultSM, defaultCM);
        try (ObjectOutputStream ooStream = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(sampleImageFile)));){
            ooStream.writeObject(sampleImage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RenderedImage loadSampleImage(File sampleImageFile) {
        InputStream inStream = null;
        ObjectInputStream oiStream = null;
        try {
            if (Utils.checkFileReadable(sampleImageFile)) {
                inStream = new BufferedInputStream(new FileInputStream(sampleImageFile));
                oiStream = new ObjectInputStream(inStream);
                Object object = oiStream.readObject();
                if (object instanceof SampleImage) {
                    SampleImage si = (SampleImage)object;
                    BufferedImage bufferedImage = si.toBufferedImage();
                    return bufferedImage;
                }
                if (object instanceof SerializableRenderedImage) {
                    SerializableRenderedImage sri;
                    block57: {
                        sri = (SerializableRenderedImage)object;
                        if (sampleImageFile.canWrite()) {
                            try {
                                Utils.storeSampleImage(sampleImageFile, sri.getSampleModel(), sri.getColorModel());
                            }
                            catch (Exception e) {
                                if (!LOGGER.isLoggable(Level.WARNING)) break block57;
                                LOGGER.log(Level.WARNING, "Failed to upgrade the sample image to the new storage format", e);
                            }
                        }
                    }
                    BufferedImage e = new SampleImage(sri.getSampleModel(), sri.getColorModel()).toBufferedImage();
                    return e;
                }
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("Unrecognized sample_image content: " + object);
                }
                RenderedImage sri = null;
                return sri;
            }
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Unable to find sample image for path " + sampleImageFile);
            }
            RenderedImage object = null;
            return object;
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        catch (ClassNotFoundException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            RenderedImage renderedImage = null;
            return renderedImage;
        }
        finally {
            block59: {
                block58: {
                    try {
                        if (inStream != null) {
                            inStream.close();
                        }
                    }
                    catch (Throwable e) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block58;
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    if (oiStream != null) {
                        oiStream.close();
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block59;
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public static Map<String, Serializable> createDataStoreParamsFromPropertiesFile(Properties properties, DataStoreFactorySpi spi) throws IOException {
        DataAccessFactory.Param[] paramsInfo;
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
            if (properties.containsKey(p.key)) {
                params.put(p.key, (Serializable)Converters.convert(properties.getProperty(p.key), p.type));
                continue;
            }
            if (!p.required || p.sample != null) continue;
            throw new IOException("Required parameter missing: " + p.toString());
        }
        return params;
    }

    public static Map<String, Serializable> filterDataStoreParams(Properties properties, DataStoreFactorySpi spi) throws IOException {
        DataAccessFactory.Param[] paramsInfo;
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        for (DataAccessFactory.Param p : paramsInfo = spi.getParametersInfo()) {
            if (properties.containsKey(p.key)) {
                params.put(p.key, (Serializable)Converters.convert(properties.get(p.key), p.type));
                continue;
            }
            if (!p.required || p.sample != null) continue;
            throw new IOException("Required parameter missing: " + p.toString());
        }
        return params;
    }

    static URL checkSource(Object source, Hints hints) {
        SourceGetter sourceGetter = new SourceGetter(source);
        URL sourceURL = sourceGetter.getUrl();
        File sourceFile = sourceGetter.getFile();
        if (sourceFile != null) {
            if (!sourceFile.isDirectory()) {
                sourceURL = URLs.fileToUrl(sourceFile);
            } else {
                String locationPath = sourceFile.getAbsolutePath();
                String defaultIndexName = Utils.getDefaultIndexName(locationPath);
                boolean datastoreFound = false;
                boolean buildMosaic = false;
                File dataStoreProperties = new File(locationPath, "datastore.properties");
                File[] properties = sourceFile.listFiles((FilenameFilter)FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{FileFilterUtils.notFileFilter((IOFileFilter)FileFilterUtils.nameFileFilter((String)"datastore.properties")), FileFilterUtils.makeFileOnly((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".properties"))}));
                if (Utils.checkFileReadable(dataStoreProperties)) {
                    datastoreFound = true;
                    boolean found = false;
                    for (File propFile : properties) {
                        if (!Utils.checkFileReadable(propFile) || null == Utils.loadMosaicProperties(URLs.fileToUrl(propFile))) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        buildMosaic = true;
                    }
                } else {
                    buildMosaic = true;
                    datastoreFound = false;
                }
                File shapeFile = null;
                if (!datastoreFound) {
                    for (File propFile : properties) {
                        if (null == Utils.loadMosaicProperties(URLs.fileToUrl(propFile))) continue;
                        shapeFile = new File(locationPath, FilenameUtils.getBaseName((String)propFile.getName()) + ".shp");
                        if (!Utils.checkFileReadable(shapeFile) && Utils.checkFileReadable(propFile)) {
                            buildMosaic = true;
                            continue;
                        }
                        buildMosaic = false;
                        break;
                    }
                }
                if (buildMosaic) {
                    File mosaicDirectory = new File(locationPath);
                    if (!mosaicDirectory.exists() || mosaicDirectory.isFile() || !mosaicDirectory.canWrite()) {
                        if (LOGGER.isLoggable(Level.SEVERE)) {
                            LOGGER.log(Level.SEVERE, "Unable to create the mosaic, check the location:\nlocation is:" + locationPath + "\nlocation exists:" + mosaicDirectory.exists() + "\nlocation is a directory:" + mosaicDirectory.isDirectory() + "\nlocation is writable:" + mosaicDirectory.canWrite() + "\nlocation is readable:" + mosaicDirectory.canRead() + "\nlocation is hidden:" + mosaicDirectory.isHidden() + "\n");
                        }
                        return null;
                    }
                    Utils.createMosaic(locationPath, defaultIndexName, DEFAULT_WILCARD, false, hints);
                    File propertiesFile = new File(locationPath, defaultIndexName + ".properties");
                    if (!Utils.checkFileReadable(propertiesFile) && !Utils.checkMosaicHasBeenInitialized(locationPath, defaultIndexName)) {
                        sourceURL = null;
                        return sourceURL;
                    }
                    sourceURL = Utils.updateSourceURL(sourceURL, datastoreFound, locationPath, defaultIndexName);
                } else {
                    sourceURL = datastoreFound ? URLs.fileToUrl(dataStoreProperties) : URLs.fileToUrl(shapeFile);
                }
            }
        }
        return sourceURL;
    }

    private static String getDefaultIndexName(String locationPath) {
        String name = Utils.getIndexerProperty(locationPath, "Name");
        if (name != null) {
            return name;
        }
        return FilenameUtils.getName((String)locationPath);
    }

    public static String getIndexerProperty(String locationPath, String propertyName) {
        if (locationPath == null) {
            return null;
        }
        File file = new File(locationPath);
        if (file.isDirectory()) {
            URL indexerUrl;
            Properties config;
            File indexer = new File(file, "indexer.properties");
            if (indexer.exists() && (config = CoverageUtilities.loadPropertiesFromURL(indexerUrl = URLs.fileToUrl(indexer))) != null && config.get("Name") != null) {
                return (String)config.get(propertyName);
            }
            indexer = new File(file, "indexer.xml");
            String name = IndexerUtils.getParameter("Name", indexer);
            if (name != null) {
                return name;
            }
        }
        return null;
    }

    private static URL updateSourceURL(URL sourceURL, boolean datastoreFound, String locationPath, String defaultIndexName) {
        File dataStoreProperties;
        File shapeFile;
        sourceURL = !datastoreFound ? (!Utils.checkFileReadable(shapeFile = new File(locationPath, defaultIndexName + ".shp")) ? null : URLs.fileToUrl(shapeFile)) : (!Utils.checkFileReadable(dataStoreProperties = new File(locationPath, "datastore.properties")) ? null : URLs.fileToUrl(dataStoreProperties));
        return sourceURL;
    }

    private static boolean checkMosaicHasBeenInitialized(String locationPath, String defaultIndexName) {
        String canBeEmpty;
        URL url;
        Properties properties;
        String canBeEmpty2;
        File mosaicFile = new File(locationPath, defaultIndexName + ".xml");
        if (Utils.checkFileReadable(mosaicFile)) {
            return true;
        }
        mosaicFile = new File(locationPath, defaultIndexName + ".properties");
        if (Utils.checkFileReadable(mosaicFile)) {
            return true;
        }
        File indexFile = new File(locationPath, "indexer.xml");
        if (Utils.checkFileReadable(indexFile) && (canBeEmpty2 = IndexerUtils.getParameter("CanBeEmpty", indexFile)) != null && Boolean.parseBoolean(canBeEmpty2)) {
            return true;
        }
        indexFile = new File(locationPath, "indexer.properties");
        return Utils.checkFileReadable(indexFile) && (properties = CoverageUtilities.loadPropertiesFromURL(url = URLs.fileToUrl(indexFile))) != null && (canBeEmpty = properties.getProperty("CanBeEmpty", null)) != null && Boolean.parseBoolean(canBeEmpty);
    }

    private Utils(Cache ehcache) {
        Utils.ehcache = ehcache;
    }

    public static Histogram getHistogram(String file) {
        Histogram histogram;
        block21: {
            Object value;
            Element element;
            Utilities.ensureNonNull("file", file);
            histogram = null;
            if (ehcache != null && ehcache.isKeyInCache((Object)file) && ehcache.isElementInMemory((Serializable)((Object)file)) && (element = ehcache.get((Serializable)((Object)file))) != null && (value = element.getObjectValue()) != null && value instanceof Histogram) {
                histogram = (Histogram)value;
                return histogram;
            }
            if (histogram == null) {
                try (ObjectInputStream objectStream = new ObjectInputStream(new FileInputStream(file));){
                    histogram = (Histogram)objectStream.readObject();
                    if (ehcache != null) {
                        ehcache.put(new Element((Serializable)((Object)file), (Serializable)histogram));
                    }
                }
                catch (FileNotFoundException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Unable to parse Histogram:" + e.getLocalizedMessage());
                    }
                }
                catch (IOException e) {
                    if (LOGGER.isLoggable(Level.FINE)) {
                        LOGGER.fine("Unable to parse Histogram:" + e.getLocalizedMessage());
                    }
                }
                catch (ClassNotFoundException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) break block21;
                    LOGGER.fine("Unable to parse Histogram:" + e.getLocalizedMessage());
                }
            }
        }
        return histogram;
    }

    static boolean areaIsDifferent(Geometry granuleFootprint, AffineTransform baseGridToWorld, ReferencedEnvelope granuleBBOX) {
        double bboxArea;
        org.locationtech.jts.geom.Envelope envelope = granuleFootprint.getEnvelope().getEnvelopeInternal();
        double deltaMinX = Math.abs(envelope.getMinX() - granuleBBOX.getMinX());
        double deltaMinY = Math.abs(envelope.getMinY() - granuleBBOX.getMinY());
        double deltaMaxX = Math.abs(envelope.getMaxX() - granuleBBOX.getMaxX());
        double deltaMaxY = Math.abs(envelope.getMaxY() - granuleBBOX.getMaxY());
        double resX = XAffineTransform.getScaleX0(baseGridToWorld);
        double resY = XAffineTransform.getScaleY0(baseGridToWorld);
        double toleranceX = resX / 20.0;
        double toleranceY = resY / 20.0;
        double cellArea = resX * resY;
        if (deltaMinX > toleranceX || deltaMaxX > toleranceX || deltaMinY > toleranceY || deltaMaxY > toleranceY) {
            return true;
        }
        double footprintArea = granuleFootprint.getArea();
        return Math.abs(footprintArea - (bboxArea = granuleBBOX.getHeight() * granuleBBOX.getWidth())) > cellArea;
    }

    static Rectangle toRectangle(Shape shape) {
        int i;
        if (shape instanceof Rectangle) {
            return (Rectangle)shape;
        }
        if (shape == null) {
            return null;
        }
        PathIterator iter = shape.getPathIterator(new AffineTransform());
        double[] coords = new double[2];
        if (iter.isDone()) {
            return null;
        }
        iter.next();
        int action = iter.currentSegment(coords);
        if (action != 0 && action != 1) {
            return null;
        }
        double minx = coords[0];
        double miny = coords[1];
        double maxx = minx;
        double maxy = miny;
        double prevx = minx;
        double prevy = miny;
        for (i = 0; i < 4 && !iter.isDone(); ++i) {
            iter.next();
            action = iter.currentSegment(coords);
            if (action == 4) break;
            if (action != 1) {
                return null;
            }
            double x = coords[0];
            double y = coords[1];
            if (!(prevx == x && prevy != y || prevx != x && prevy == y)) {
                return null;
            }
            if (x < minx) {
                minx = x;
            } else if (x > maxx) {
                maxx = x;
            }
            if (y < miny) {
                miny = y;
            } else if (y > maxy) {
                maxy = y;
            }
            prevx = x;
            prevy = y;
        }
        iter.next();
        if (!iter.isDone() || i != 3) {
            return null;
        }
        return new Rectangle2D.Double(minx, miny, maxx - minx, maxy - miny).getBounds();
    }

    public static ImageLayout getImageLayoutHint(RenderingHints renderHints) {
        if (renderHints == null || !renderHints.containsKey(JAI.KEY_IMAGE_LAYOUT)) {
            return null;
        }
        return (ImageLayout)renderHints.get(JAI.KEY_IMAGE_LAYOUT);
    }

    public static TileCache getTileCacheHint(RenderingHints renderHints) {
        if (renderHints == null || !renderHints.containsKey(JAI.KEY_TILE_CACHE)) {
            return null;
        }
        return (TileCache)renderHints.get(JAI.KEY_TILE_CACHE);
    }

    public static BorderExtender getBorderExtenderHint(RenderingHints renderHints) {
        if (renderHints == null || !renderHints.containsKey(JAI.KEY_BORDER_EXTENDER)) {
            return null;
        }
        return (BorderExtender)renderHints.get(JAI.KEY_BORDER_EXTENDER);
    }

    public static TileScheduler getTileSchedulerHint(RenderingHints renderHints) {
        if (renderHints == null || !renderHints.containsKey(JAI.KEY_TILE_SCHEDULER)) {
            return null;
        }
        return (TileScheduler)renderHints.get(JAI.KEY_TILE_SCHEDULER);
    }

    public static Hints setupJAIHints(RenderingHints inputHints) {
        Hints hints = new Hints();
        if (inputHints != null) {
            TileScheduler tileScheduler;
            TileCache tc = Utils.getTileCacheHint(inputHints);
            if (tc != null) {
                hints.add(new RenderingHints(JAI.KEY_TILE_CACHE, tc));
            }
            if ((tileScheduler = Utils.getTileSchedulerHint(inputHints)) != null) {
                hints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, tileScheduler));
            }
        }
        return hints;
    }

    public static Range<? extends Number> createRange(Object firstValue, Object secondValue) {
        Class<?> target2Class;
        Class<?> targetClass = firstValue.getClass();
        if (targetClass != (target2Class = secondValue.getClass())) {
            throw new IllegalArgumentException("The 2 values need to belong to the same class:\nfirstClass = " + targetClass.toString() + "; secondClass = " + targetClass.toString());
        }
        if (targetClass == Byte.class) {
            return new Range<Byte>(Byte.class, (Byte)firstValue, (Byte)secondValue);
        }
        if (targetClass == Short.class) {
            return new Range<Short>(Short.class, (Short)firstValue, (Short)secondValue);
        }
        if (targetClass == Integer.class) {
            return new Range<Integer>(Integer.class, (Integer)firstValue, (Integer)secondValue);
        }
        if (targetClass == Long.class) {
            return new Range<Long>(Long.class, (Long)firstValue, (Long)secondValue);
        }
        if (targetClass == Float.class) {
            return new Range<Float>(Float.class, (Float)firstValue, (Float)secondValue);
        }
        if (targetClass == Double.class) {
            return new Range<Double>(Double.class, (Double)firstValue, (Double)secondValue);
        }
        return null;
    }

    public static boolean minimalIndexCheck(Object source) {
        File sourceFile = null;
        URL sourceURL = null;
        if (source instanceof File) {
            sourceFile = (File)source;
        } else if (source instanceof URL) {
            sourceURL = (URL)source;
            if (sourceURL.getProtocol().equals("file")) {
                sourceFile = URLs.urlToFile(sourceURL);
            }
        } else if (source instanceof String) {
            String tempSource = (String)source;
            File tempFile = new File(tempSource);
            if (!tempFile.exists()) {
                return false;
            }
            sourceFile = tempFile;
        }
        File indexerProperties = new File(sourceFile, "indexer.properties");
        if (Utils.checkFileReadable(indexerProperties)) {
            return true;
        }
        File indexerXML = new File(sourceFile, "indexer.xml");
        return Utils.checkFileReadable(indexerXML);
    }

    public static boolean homogeneousCheck(int numberOfLevels, double[][] resolutionLevels, double[][] compareLevels) {
        for (int k = 0; k < numberOfLevels; ++k) {
            if (!(Math.abs(resolutionLevels[k][0] - compareLevels[k][0]) > 0.01 * compareLevels[k][0]) && !(Math.abs(resolutionLevels[k][1] - compareLevels[k][1]) > 0.01 * compareLevels[k][1])) continue;
            return false;
        }
        return true;
    }

    public static Indexer unmarshal(File indexerFile) throws JAXBException {
        Unmarshaller unmarshaller = null;
        Indexer indexer = null;
        if (indexerFile != null) {
            unmarshaller = CONTEXT.createUnmarshaller();
            indexer = (Indexer)unmarshaller.unmarshal(indexerFile);
        }
        return indexer;
    }

    public static void marshal(Indexer indexer, File indexerFile) throws JAXBException {
        Marshaller marshaller = CONTEXT.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.marshal((Object)indexer, indexerFile);
    }

    public static boolean checkColorModels(ColorModel defaultCM, byte[][] defaultPalette, ColorModel actualCM) {
        int actualNumComponents;
        int defNumComponents = defaultCM.getNumColorComponents();
        int colorComponentsDifference = Math.abs(defNumComponents - (actualNumComponents = actualCM.getNumColorComponents()));
        if (colorComponentsDifference != 0) {
            return (defNumComponents != 1 || !(defaultCM instanceof ComponentColorModel)) && (actualNumComponents != 1 || !(actualCM instanceof ComponentColorModel));
        }
        return false;
    }

    public static boolean isH2Store(DataStoreFactorySpi spi) {
        String spiName = spi == null ? null : spi.getClass().getName();
        return "org.geotools.data.h2.H2DataStoreFactory".equals(spiName) || "org.geotools.data.h2.H2JNDIDataStoreFactory".equals(spiName);
    }

    public static void fixH2DatabaseLocation(Map<String, Serializable> params, String parentLocation) throws MalformedURLException {
        if (params.containsKey(DATABASE_KEY)) {
            String dbname = (String)((Object)params.get(DATABASE_KEY));
            params.put(DATABASE_KEY, (Serializable)((Object)("file:" + new File(URLs.urlToFile(new URL(parentLocation)), dbname).getPath())));
        }
    }

    public static boolean isOracleStore(DataStoreFactorySpi spi) {
        String spiName = spi == null ? null : spi.getClass().getName();
        return "org.geotools.data.oracle.OracleNGOCIDataStoreFactory".equals(spiName) || "org.geotools.data.oracle.OracleNGJNDIDataStoreFactory".equals(spiName) || "org.geotools.data.oracle.OracleNGDataStoreFactory".equals(spiName);
    }

    public static boolean isPostgisStore(DataStoreFactorySpi spi) {
        String spiName = spi == null ? null : spi.getClass().getName();
        return "org.geotools.data.postgis.PostgisNGJNDIDataStoreFactory".equals(spiName) || "org.geotools.data.postgis.PostgisNGDataStoreFactory".equals(spiName);
    }

    public static PAMDataset mergePamDatasets(PAMDataset[] pamDatasets) {
        PAMDataset merged = pamDatasets[0];
        if (pamDatasets.length > 1 && (merged = Utils.initRasterBands(pamDatasets[0])) != null) {
            for (PAMDataset pamDataset : pamDatasets) {
                Utils.updatePamDatasets(pamDataset, merged);
            }
        }
        return merged;
    }

    private static void updatePamDatasets(PAMDataset inputPamDataset, PAMDataset outputPamDataset) {
        List<PAMDataset.PAMRasterBand> inputRasterBands = inputPamDataset.getPAMRasterBand();
        List<PAMDataset.PAMRasterBand> outputRasterBands = outputPamDataset.getPAMRasterBand();
        for (int i = 0; i < inputRasterBands.size(); ++i) {
            Utils.updateRasterBand(inputRasterBands.get(i), outputRasterBands.get(i));
        }
    }

    private static void updateRasterBand(PAMDataset.PAMRasterBand inputPamRasterBand, PAMDataset.PAMRasterBand outputPamRasterBand) {
        List<PAMDataset.PAMRasterBand.Metadata.MDI> mdiInputs = inputPamRasterBand.getMetadata().getMDI();
        List<PAMDataset.PAMRasterBand.Metadata.MDI> mdiOutputs = outputPamRasterBand.getMetadata().getMDI();
        for (int i = 0; i < mdiInputs.size(); ++i) {
            PAMDataset.PAMRasterBand.Metadata.MDI mdiInput = mdiInputs.get(i);
            PAMDataset.PAMRasterBand.Metadata.MDI mdiOutput = mdiOutputs.get(i);
            Utils.updateMDI(mdiInput, mdiOutput);
        }
    }

    private static void updateMDI(PAMDataset.PAMRasterBand.Metadata.MDI mdiInput, PAMDataset.PAMRasterBand.Metadata.MDI mdiOutput) {
        Double current = Double.parseDouble(mdiInput.getValue());
        String value = mdiOutput.getValue();
        if (value != null) {
            Double output = Double.parseDouble(value);
            if (mdiInput.getKey().toUpperCase().endsWith("_MAXIMUM")) {
                if (current < output) {
                    current = output;
                }
            } else if (output < current) {
                current = output;
            }
        }
        mdiOutput.setValue(Double.toString(current));
    }

    private static PAMDataset initRasterBands(PAMDataset samplePam) {
        PAMDataset merged = null;
        if (samplePam != null) {
            merged = new PAMDataset();
            List<PAMDataset.PAMRasterBand> samplePamRasterBands = samplePam.getPAMRasterBand();
            int numBands = samplePamRasterBands.size();
            List<PAMDataset.PAMRasterBand> pamRasterBands = merged.getPAMRasterBand();
            PAMDataset.PAMRasterBand sampleBand = samplePamRasterBands.get(0);
            List<PAMDataset.PAMRasterBand.Metadata.MDI> sampleMetadata = sampleBand.getMetadata().getMDI();
            for (int i = 0; i < numBands; ++i) {
                PAMDataset.PAMRasterBand band = new PAMDataset.PAMRasterBand();
                PAMDataset.PAMRasterBand.Metadata metadata = new PAMDataset.PAMRasterBand.Metadata();
                List<PAMDataset.PAMRasterBand.Metadata.MDI> mdiList = metadata.getMDI();
                for (PAMDataset.PAMRasterBand.Metadata.MDI mdi : sampleMetadata) {
                    PAMDataset.PAMRasterBand.Metadata.MDI addedMdi = new PAMDataset.PAMRasterBand.Metadata.MDI();
                    addedMdi.setKey(mdi.getKey());
                    mdiList.add(addedMdi);
                }
                band.setMetadata(metadata);
                pamRasterBands.add(band);
            }
        }
        return merged;
    }

    public static IOFileFilter getCleanupFilter() {
        return CLEANUP_FILTER;
    }

    public static void fixH2MVCCParam(Map<String, Serializable> params) {
        if (params != null) {
            params.put(MVCC_KEY, Boolean.valueOf(true));
        }
    }

    public static void fixPostgisDBCreationParams(Map<String, Serializable> datastoreParams) {
        datastoreParams.put("create database", Boolean.valueOf(true));
    }

    public static ImageReaderSpi getReaderSpiFromStream(ImageReaderSpi suggestedSPI, ImageInputStream inStream) throws IOException {
        ImageReaderSpi readerSPI = null;
        inStream.mark();
        if (suggestedSPI != null && suggestedSPI.canDecodeInput(inStream)) {
            readerSPI = suggestedSPI;
            inStream.reset();
        } else {
            inStream.mark();
            ImageReader reader = ImageIOExt.getImageioReader(inStream);
            if (reader != null) {
                readerSPI = reader.getOriginatingProvider();
            }
            inStream.reset();
        }
        return readerSPI;
    }

    public static ImageInputStreamSpi getInputStreamSPIFromURL(URL granuleUrl) throws IOException {
        ImageInputStreamSpi streamSPI = ImageIOExt.getImageInputStreamSPI(granuleUrl, true);
        if (streamSPI == null) {
            File file = URLs.urlToFile(granuleUrl);
            if (file != null && LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, Utils.getFileInfo(file));
            }
            throw new IllegalArgumentException("Unable to get an input stream for the provided granule " + granuleUrl.toString());
        }
        return streamSPI;
    }

    public static byte[][] extractPalette(IndexColorModel indexColorModel) {
        Utilities.ensureNonNull("indexColorModel", indexColorModel);
        byte[][] palette = new byte[3][indexColorModel.getMapSize()];
        int numBands = indexColorModel.getNumColorComponents();
        indexColorModel.getReds(palette[0]);
        indexColorModel.getGreens(palette[0]);
        indexColorModel.getBlues(palette[0]);
        if (numBands == 4) {
            indexColorModel.getAlphas(palette[0]);
        }
        return palette;
    }

    public static boolean isValidMosaicSchema(SimpleFeatureType schema, String locationAttributeName) {
        if (schema == null || schema.getGeometryDescriptor() == null) {
            return false;
        }
        AttributeDescriptor location = schema.getDescriptor(locationAttributeName);
        return location != null && CharSequence.class.isAssignableFrom(location.getType().getBinding());
    }

    public static ReferencedEnvelope reprojectEnvelope(ReferencedEnvelope sourceEnvelope, CoordinateReferenceSystem targetCRS, ReferencedEnvelope targetReferenceEnvelope) throws FactoryException, TransformException {
        Geometry reprojected = Utils.reprojectEnvelopeToGeometry(sourceEnvelope, targetCRS, targetReferenceEnvelope);
        if (reprojected == null) {
            return new ReferencedEnvelope(targetCRS);
        }
        if (reprojected.getNumGeometries() > 1) {
            return new ReferencedEnvelope(reprojected.getGeometryN(0).getEnvelopeInternal(), targetCRS);
        }
        return new ReferencedEnvelope(reprojected.getEnvelopeInternal(), targetCRS);
    }

    public static Geometry reprojectEnvelopeToGeometry(ReferencedEnvelope sourceEnvelope, CoordinateReferenceSystem targetCRS, ReferencedEnvelope targetReferenceEnvelope) throws FactoryException, TransformException {
        ProjectionHandler handler;
        CoordinateReferenceSystem sourceCRS = sourceEnvelope.getCoordinateReferenceSystem();
        if (targetReferenceEnvelope == null) {
            targetReferenceEnvelope = ReferencedEnvelope.reference(Utils.getCRSEnvelope(targetCRS));
        }
        if (targetReferenceEnvelope != null) {
            handler = ProjectionHandlerFinder.getHandler(targetReferenceEnvelope, sourceCRS, true);
        } else {
            ReferencedEnvelope reference = new ReferencedEnvelope(targetCRS);
            handler = ProjectionHandlerFinder.getHandler(reference, sourceCRS, false);
        }
        if (handler != null) {
            MathTransform transform = CRS.findMathTransform(sourceCRS, targetCRS);
            Polygon footprint = JTS.toGeometry(sourceEnvelope);
            Geometry preProcessed = handler.preProcess((Geometry)footprint);
            if (preProcessed == null) {
                return null;
            }
            Geometry transformed = JTS.transform(preProcessed, transform);
            Geometry postProcessed = handler.postProcess(transform.inverse(), transformed);
            if (postProcessed == null) {
                return null;
            }
            return postProcessed;
        }
        sourceEnvelope = new ReferencedEnvelope(CRS.transform(sourceEnvelope, targetCRS));
        return JTS.toGeometry(sourceEnvelope);
    }

    private static Envelope getCRSEnvelope(CoordinateReferenceSystem targetCRS) throws FactoryException, NoSuchAuthorityCodeException {
        Integer code;
        if (targetCRS.getDomainOfValidity() == null && (code = CRS.lookupEpsgCode(targetCRS, true)) != null) {
            CRS.decode("EPSG:" + code, CRS.getAxisOrder(targetCRS) != CRS.AxisOrder.NORTH_EAST);
        }
        Envelope envelope = CRS.getEnvelope(targetCRS);
        return envelope;
    }

    public static File getFile(String strValue, File rootFolder) throws IOException {
        File file = new File(strValue);
        if (!file.isAbsolute()) {
            file = new File(rootFolder, strValue);
        }
        return file;
    }

    public static Geometry decimate(Geometry geometry) {
        Coordinate[] coordinates = geometry.getCoordinates();
        if (coordinates.length <= COORDS_DECIMATION_THRESHOLD) {
            return geometry;
        }
        Geometry g2 = LiteCoordinateSequence.cloneGeometry(geometry, 2);
        Decimator decimator = new Decimator(0.8, 0.8);
        decimator.decimate(g2);
        g2.geometryChanged();
        return g2;
    }

    public static ROI roiIntersect(ROI roi, ROIGeometry roiGeometry, RenderingHints hints) {
        block4: {
            try {
                roi = roi.intersect(roiGeometry);
            }
            catch (TopologyException tpe) {
                Geometry g;
                boolean isValid;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Topology Exception occurred while producing the intersecting ROI\nTrying with a GeometrySnapper approach. " + tpe.getLocalizedMessage());
                }
                if (!(isValid = (g = roiGeometry.getAsGeometry()).isValid())) {
                    double tol = GeometrySnapper.computeOverlaySnapTolerance((Geometry)g);
                    g = new GeometrySnapper(g).snapTo(g, tol).buffer(0.0);
                    roiGeometry = new ROIGeometry(g, Utils.setupJAIHints(hints));
                    roi = roi.intersect(roiGeometry);
                }
                if (!(roi instanceof ROIGeometry) || (isValid = (g = ((ROIGeometry)roi).getAsGeometry()).isValid())) break block4;
                double tol = GeometrySnapper.computeOverlaySnapTolerance((Geometry)g);
                g = new GeometrySnapper(g).snapTo(g, tol).buffer(0.0);
                roi = new ROIGeometry(g, Utils.setupJAIHints(hints));
                roi = roi.intersect(roiGeometry);
            }
        }
        return roi;
    }

    static {
        RGB_TO_GRAY_MATRIX = new double[][]{{0.114, 0.587, 0.299, 0.0}};
        LOGGER = Logging.getLogger(Utils.class);
        String prop = System.getProperty("org.geotools.imagemosaic.optimizecrop");
        OPTIMIZE_CROP = prop == null || !prop.equalsIgnoreCase("FALSE");
        try {
            CONTEXT = JAXBContext.newInstance((String)"org.geotools.gce.imagemosaic.catalog.index");
        }
        catch (JAXBException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
        }
        COORDS_DECIMATION_THRESHOLD = Integer.getInteger("org.geotools.gce.imagemosaic.decimationthreshold", 200);
        CLEANUP_FILTER = Utils.initCleanUpFilter();
        MOSAIC_SUPPORT_FILES_FILTER = Utils.initMosaicSupportFilesFilter();
        SHAPE_SPI = new ShapefileDataStoreFactory();
        TRANSPARENT = new Color(0, 0, 0, 0);
        UTC_TIME_ZONE = TimeZone.getTimeZone("UTC");
        OBJECT_FACTORY = new ObjectFactory();
    }

    public static class SourceGetter {
        private File file;
        private URL url;
        private Object source;

        public SourceGetter(Object inputSource) {
            this.source = inputSource;
            if (this.source instanceof File) {
                this.file = (File)this.source;
                this.url = URLs.fileToUrl(this.file);
            } else if (this.source instanceof URL) {
                this.url = (URL)this.source;
                if (this.url.getProtocol().equals("file")) {
                    this.file = URLs.urlToFile(this.url);
                }
            } else if (this.source instanceof String) {
                String tempSource = (String)this.source;
                File tempFile = new File(tempSource);
                if (!tempFile.exists()) {
                    try {
                        this.url = new URL(tempSource);
                        this.file = URLs.urlToFile(this.url);
                        this.source = this.file;
                    }
                    catch (MalformedURLException e) {
                        this.url = null;
                        this.source = null;
                    }
                } else {
                    this.url = URLs.fileToUrl(tempFile);
                    this.file = tempFile;
                }
            }
        }

        public File getFile() {
            return this.file;
        }

        public URL getUrl() {
            return this.url;
        }

        public Object getSource() {
            return this.source;
        }
    }

    public static class BBOXFilterExtractor
    extends DefaultFilterVisitor {
        private ReferencedEnvelope bbox;

        public ReferencedEnvelope getBBox() {
            return this.bbox;
        }

        @Override
        public Object visit(BBOX filter, Object data) {
            ReferencedEnvelope bbox = ReferencedEnvelope.reference(filter.getBounds());
            this.bbox = this.bbox != null ? this.bbox.intersection(bbox) : bbox;
            return super.visit(filter, data);
        }
    }

    public static class Prop {
        public static final String LOCATION_ATTRIBUTE = "LocationAttribute";
        public static final String ENVELOPE2D = "Envelope2D";
        public static final String LEVELS_NUM = "LevelsNum";
        public static final String LEVELS = "Levels";
        public static final String SUGGESTED_SPI = "SuggestedSPI";
        public static final String EXP_RGB = "ExpandToRGB";
        public static final String ABSOLUTE_PATH = "AbsolutePath";
        public static final String AUXILIARY_FILE = "AuxiliaryFile";
        public static final String AUXILIARY_DATASTORE_FILE = "AuxiliaryDatastoreFile";
        public static final String NAME = "Name";
        public static final String INDEX_NAME = "Name";
        public static final String INPUT_COVERAGE_NAME = "InputCoverageName";
        public static final String FOOTPRINT_MANAGEMENT = "FootprintManagement";
        public static final String HETEROGENEOUS = "Heterogeneous";
        public static final String TIME_ATTRIBUTE = "TimeAttribute";
        public static final String ELEVATION_ATTRIBUTE = "ElevationAttribute";
        public static final String ADDITIONAL_DOMAIN_ATTRIBUTES = "AdditionalDomainAttributes";
        public static final String CRS_ATTRIBUTE = "CrsAttribute";
        public static final String RESOLUTION_ATTRIBUTE = "ResolutionAttribute";
        public static final String RESOLUTION_X_ATTRIBUTE = "ResolutionXAttribute";
        public static final String RESOLUTION_Y_ATTRIBUTE = "ResolutionYAttribute";
        public static final String SUGGESTED_IS_SPI = "SuggestedIsSPI";
        public static final String SUGGESTED_FORMAT = "SuggestedFormat";
        public static final String USE_EXISTING_SCHEMA = "UseExistingSchema";
        public static final String TYPENAME = "TypeName";
        public static final String STORE_NAME = "StoreName";
        public static final String PATH_TYPE = "PathType";
        public static final String PARENT_LOCATION = "ParentLocation";
        public static final String ROOT_MOSAIC_DIR = "RootMosaicDirectory";
        public static final String INDEXING_DIRECTORIES = "IndexingDirectories";
        public static final String HARVEST_DIRECTORY = "HarvestingDirectory";
        public static final String CAN_BE_EMPTY = "CanBeEmpty";
        public static final String CHECK_AUXILIARY_METADATA = "CheckAuxiliaryMetadata";
        public static final String RECURSIVE = "Recursive";
        public static final String WILDCARD = "Wildcard";
        public static final String SCHEMA = "Schema";
        public static final String RESOLUTION_LEVELS = "ResolutionLevels";
        public static final String PROPERTY_COLLECTORS = "PropertyCollectors";
        public static final String CACHING = "Caching";
        public static final String WRAP_STORE = "WrapStore";
        public static final String GRANULE_ACCEPTORS = "GranuleAcceptors";
        public static final String GEOMETRY_HANDLER = "GranuleHandler";
        public static final String COVERAGE_NAME_COLLECTOR_SPI = "CoverageNameCollectorSPI";
        public static final String MOSAIC_CRS = "MosaicCRS";
        public static final String HETEROGENEOUS_CRS = "HeterogeneousCRS";
        public static final String GRANULE_COLLECTOR_FACTORY = "GranuleCollectorFactory";
        public static final String NO_DATA = "NoData";
    }
}

