/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import org.geotools.coverage.grid.io.DecimationPolicy;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.referencing.operation.TransformException;

public class ReadParamsController {
    private static final Logger LOGGER = Logging.getLogger(ReadParamsController.class);

    private static void performDecimation(RasterManager.SpatialDomainManager spatialDomainManager, double[] requestedResolution, int levelIndex, ImageReadParam readParameters, OverviewsController overviewsController, double[] virtualNativeResolution) {
        int subSamplingFactorX;
        int rasterHeight;
        int rasterWidth;
        Utilities.ensureNonNull("readParameters", readParameters);
        Utilities.ensureNonNull("spatialDomainManager", spatialDomainManager);
        Utilities.ensureNonNull("overviewsController", overviewsController);
        if (requestedResolution == null) {
            readParameters.setSourceSubsampling(1, 1, 0, 0);
            return;
        }
        boolean useVirtual = false;
        if (virtualNativeResolution != null && !Double.isNaN(virtualNativeResolution[0]) && !Double.isNaN(virtualNativeResolution[1])) {
            useVirtual = true;
        }
        double[] selectedRes = new double[2];
        double[] requestedRes = new double[2];
        OverviewsController.OverviewLevel level = overviewsController.resolutionsLevels.get(levelIndex);
        selectedRes[0] = level.resolutionX;
        selectedRes[1] = level.resolutionY;
        requestedRes[0] = requestedResolution[0];
        requestedRes[1] = requestedResolution[1];
        if (levelIndex == 0) {
            rasterWidth = spatialDomainManager.coverageRasterArea.width;
            rasterHeight = spatialDomainManager.coverageRasterArea.height;
            if (useVirtual) {
                if (virtualNativeResolution[0] > requestedResolution[0] && virtualNativeResolution[1] > requestedResolution[1]) {
                    requestedRes[0] = virtualNativeResolution[0];
                    requestedRes[1] = virtualNativeResolution[1];
                } else {
                    virtualNativeResolution[0] = Double.NaN;
                    virtualNativeResolution[1] = Double.NaN;
                }
            }
        } else {
            rasterWidth = (int)Math.round(spatialDomainManager.coverageBBox.getSpan(0) / selectedRes[0]);
            rasterHeight = (int)Math.round(spatialDomainManager.coverageBBox.getSpan(1) / selectedRes[1]);
        }
        int n = subSamplingFactorX = (subSamplingFactorX = (int)Math.floor(requestedRes[0] / selectedRes[0])) == 0 ? 1 : subSamplingFactorX;
        while (subSamplingFactorX > 0 && rasterWidth / subSamplingFactorX <= 0) {
            --subSamplingFactorX;
        }
        subSamplingFactorX = subSamplingFactorX <= 0 ? 1 : subSamplingFactorX;
        int subSamplingFactorY = (int)Math.floor(requestedRes[1] / selectedRes[1]);
        int n2 = subSamplingFactorY = subSamplingFactorY == 0 ? 1 : subSamplingFactorY;
        while (subSamplingFactorY > 0 && rasterHeight / subSamplingFactorY <= 0) {
            --subSamplingFactorY;
        }
        subSamplingFactorY = subSamplingFactorY <= 0 ? 1 : subSamplingFactorY;
        readParameters.setSourceSubsampling(subSamplingFactorX, subSamplingFactorY, 0, 0);
    }

    static int setReadParams(double[] requestedResolution, OverviewPolicy overviewPolicy, DecimationPolicy decimationPolicy, ImageReadParam readParams, RasterManager rasterManager, OverviewsController overviewController, double[] virtualNativeResolution) throws IOException, TransformException {
        Utilities.ensureNonNull("readParams", readParams);
        Utilities.ensureNonNull("RasterManager", rasterManager);
        Utilities.ensureNonNull("overviewsController", overviewController);
        if (overviewPolicy == null) {
            overviewPolicy = OverviewPolicy.getDefaultPolicy();
        }
        if (decimationPolicy == null) {
            decimationPolicy = DecimationPolicy.getDefaultPolicy();
        }
        int imageChoice = 0;
        readParams.setSourceSubsampling(1, 1, 0, 0);
        if (overviewPolicy.equals((Object)OverviewPolicy.IGNORE) && decimationPolicy.equals((Object)DecimationPolicy.DISALLOW) && virtualNativeResolution == null) {
            return imageChoice;
        }
        if (!overviewPolicy.equals((Object)OverviewPolicy.IGNORE)) {
            imageChoice = overviewController.pickOverviewLevel(overviewPolicy, requestedResolution, virtualNativeResolution);
            if (virtualNativeResolution != null && !Double.isNaN(virtualNativeResolution[0]) && !Double.isNaN(virtualNativeResolution[1]) && LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Specified Resolution is: resX=" + virtualNativeResolution[0] + " ; resY=" + virtualNativeResolution[1] + " . Choosing imageIndex = " + imageChoice);
            }
        }
        if (!decimationPolicy.equals((Object)DecimationPolicy.DISALLOW)) {
            ReadParamsController.performDecimation(rasterManager.spatialDomainManager, requestedResolution, imageChoice, readParams, overviewController, virtualNativeResolution);
        }
        return imageChoice;
    }
}

