/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.visitor.AbstractCalcResult;
import org.geotools.feature.visitor.CalcResult;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.util.Converters;
import org.geotools.util.DateRange;
import org.geotools.util.Range;
import org.geotools.util.Utilities;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;

class RangeVisitor
implements FeatureCalc {
    protected Expression expr1;
    protected Expression expr2;
    private Comparator comparator;
    Set<Range> set = null;
    Set<String> minimalRanges = null;

    public RangeVisitor(String attributeTypeName1, String attributeTypeName2) {
        this(attributeTypeName1, attributeTypeName2, RangeType.NUMBER);
    }

    public RangeVisitor(String attributeTypeName1, String attributeTypeName2, RangeType rangeType) {
        FilterFactory factory = CommonFactoryFinder.getFilterFactory(null);
        this.expr1 = factory.property(attributeTypeName1);
        this.expr2 = factory.property(attributeTypeName2);
        this.comparator = rangeType == RangeType.NUMBER ? new NumberRangeComparator() : new DateRangeComparator();
        this.set = new TreeSet<Range>(this.comparator);
    }

    public void init(SimpleFeatureCollection collection) {
    }

    public void visit(SimpleFeature feature) {
        this.visit((Feature)feature);
    }

    @Override
    public void visit(Feature feature) {
        Object firstValue = this.expr1.evaluate(feature);
        Object secondValue = this.expr2.evaluate(feature);
        if (firstValue != null && secondValue != null) {
            this.set.add(Utils.createRange(firstValue, secondValue));
        }
    }

    public void setValue(Object newSet) {
        Collection collection;
        this.set = newSet instanceof Collection ? new HashSet<Range>((Collection)newSet) : ((collection = (Collection)Converters.convert(newSet, List.class)) != null ? new HashSet<Range>(collection) : new HashSet<Object>(Collections.singleton(newSet)));
    }

    public void reset() {
        this.set = new TreeSet<Range>(this.comparator);
        this.minimalRanges = null;
    }

    public Set<String> getRange() {
        if (this.minimalRanges == null) {
            this.minimalRanges = new LinkedHashSet<String>();
            this.populateRange();
        }
        return this.minimalRanges;
    }

    protected void populateRange() {
        for (Range range : this.set) {
            this.minimalRanges.add(range.getMinValue() + "/" + range.getMaxValue());
        }
    }

    @Override
    public CalcResult getResult() {
        if (this.set.size() < 1) {
            return CalcResult.NULL_RESULT;
        }
        return new RangeResult(this.set);
    }

    static class RangeResult
    extends AbstractCalcResult {
        private Set ranges;

        public RangeResult(Set newSet) {
            this.ranges = newSet;
        }

        @Override
        public Object getValue() {
            return new HashSet(this.ranges);
        }

        @Override
        public boolean isCompatible(CalcResult targetResults) {
            return targetResults instanceof RangeResult || targetResults == CalcResult.NULL_RESULT;
        }

        @Override
        public CalcResult merge(CalcResult resultsToAdd) {
            if (!this.isCompatible(resultsToAdd)) {
                throw new IllegalArgumentException("Parameter is not a compatible type");
            }
            if (resultsToAdd == CalcResult.NULL_RESULT) {
                return this;
            }
            if (resultsToAdd instanceof RangeResult) {
                HashSet newSet = new HashSet(this.ranges);
                newSet.addAll((Set)resultsToAdd.getValue());
                return new RangeResult(newSet);
            }
            throw new IllegalArgumentException("The CalcResults claim to be compatible, but the appropriate merge method has not been implemented.");
        }
    }

    static class NumberRangeComparator
    implements Comparator<Range<? extends Number>> {
        NumberRangeComparator() {
        }

        @Override
        public int compare(Range<? extends Number> firstRange, Range<? extends Number> secondRange) {
            Utilities.ensureNonNull("firstRange", firstRange);
            Utilities.ensureNonNull("secondRange", secondRange);
            Number firstRangeMin = firstRange.getMinValue();
            Number firstRangeMax = firstRange.getMaxValue();
            Number secondRangeMin = secondRange.getMinValue();
            Number secondRangeMax = secondRange.getMaxValue();
            return NumberRangeComparator.doubleCompare(firstRangeMin.doubleValue(), firstRangeMax.doubleValue(), secondRangeMin.doubleValue(), secondRangeMax.doubleValue());
        }

        public static int doubleCompare(double firstRangeMin, double firstRangeMax, double secondRangeMin, double secondRangeMax) {
            if (firstRangeMin == secondRangeMin && firstRangeMax == secondRangeMax) {
                return 0;
            }
            if (firstRangeMin > secondRangeMin) {
                if (firstRangeMax > secondRangeMax) {
                    return 2;
                }
                return 1;
            }
            if (firstRangeMax <= secondRangeMax) {
                return -2;
            }
            return -1;
        }
    }

    class DateRangeComparator
    implements Comparator<DateRange> {
        DateRangeComparator() {
        }

        @Override
        public int compare(DateRange firstDateRange, DateRange secondDateRange) {
            Utilities.ensureNonNull("firstDateRange", firstDateRange);
            Utilities.ensureNonNull("secondDateRange", secondDateRange);
            long beginFirst = firstDateRange.getMinValue().getTime();
            long endFirst = firstDateRange.getMaxValue().getTime();
            long beginSecond = secondDateRange.getMinValue().getTime();
            long endSecond = secondDateRange.getMaxValue().getTime();
            return NumberRangeComparator.doubleCompare(beginFirst, endFirst, beginSecond, endSecond);
        }
    }

    static enum RangeType {
        NUMBER,
        DATE;

    }
}

