/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.MosaicDescriptor;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.gce.imagemosaic.MergeBehavior;
import org.geotools.gce.imagemosaic.MosaicElement;
import org.geotools.gce.imagemosaic.MosaicInputs;
import org.geotools.gce.imagemosaic.RasterLayerResponse;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.image.ImageWorker;
import org.geotools.image.util.ImageUtilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class Mosaicker {
    private static final Logger LOGGER = Logging.getLogger(Mosaicker.class);
    private final List<MosaicElement> inputs;
    private final double[][] sourceThreshold;
    private final boolean doInputTransparency;
    private final boolean hasAlpha;
    private final MergeBehavior mergeBehavior;
    private RasterLayerResponse rasterLayerResponse;

    public Mosaicker(RasterLayerResponse rasterLayerResponse, MosaicInputs inputs, MergeBehavior mergeBehavior) {
        this.inputs = new ArrayList<MosaicElement>(inputs.getSources());
        this.sourceThreshold = inputs.getSourceThreshold();
        this.doInputTransparency = inputs.isDoInputTransparency();
        this.hasAlpha = inputs.isHasAlpha();
        this.mergeBehavior = mergeBehavior;
        this.rasterLayerResponse = rasterLayerResponse;
    }

    private RenderingHints prepareHints(boolean useFinalImageLayout) {
        Hints responseHints;
        RenderingHints localHints = new RenderingHints(null);
        if (useFinalImageLayout) {
            ImageLayout layout = new ImageLayout(this.rasterLayerResponse.getRasterBounds().x, this.rasterLayerResponse.getRasterBounds().y, this.rasterLayerResponse.getRasterBounds().width, this.rasterLayerResponse.getRasterBounds().height);
            Dimension tileDimensions = this.rasterLayerResponse.getRequest().getTileDimensions();
            if (tileDimensions == null) {
                tileDimensions = (Dimension)JAI.getDefaultTileSize().clone();
            }
            layout.setTileGridXOffset(0).setTileGridYOffset(0);
            layout.setTileHeight(tileDimensions.height).setTileWidth(tileDimensions.width);
            localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
        }
        if ((responseHints = this.rasterLayerResponse.getHints()) != null && !responseHints.isEmpty()) {
            Hints jaiHints;
            localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
            BorderExtender be = Utils.getBorderExtenderHint(responseHints);
            if (be != null) {
                localHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, be));
            }
            if ((jaiHints = Utils.setupJAIHints(responseHints)) != null && !jaiHints.isEmpty()) {
                localHints.add(jaiHints);
            }
        }
        if (this.rasterLayerResponse.getGeometryMask() != null && this.rasterLayerResponse.isSetRoiProperty()) {
            localHints.add(new RenderingHints(ImageWorker.FORCE_MOSAIC_ROI_PROPERTY, true));
        }
        return localHints;
    }

    public MosaicElement createMosaic() throws IOException {
        return this.createMosaic(true);
    }

    public MosaicElement createMosaic(boolean useFinalImageLayout) throws IOException {
        return this.createMosaic(useFinalImageLayout, false);
    }

    public MosaicElement createMosaic(boolean useFinalImageLayout, boolean skipSingleElementOptimization) throws IOException {
        FootprintBehavior footprintBehavior;
        ROI overallROI;
        int size = this.inputs.size();
        if (size <= 0) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Unable to load any granuleDescriptor ");
            }
            return null;
        }
        Hints responseHints = this.rasterLayerResponse.getHints();
        RenderingHints localHints = this.prepareHints(useFinalImageLayout);
        ROIGeometry rasterMask = this.getRasterMask();
        if (!skipSingleElementOptimization && size == 1 && Utils.OPTIMIZE_CROP) {
            RenderedImage mosaic;
            Rectangle imageBounds;
            Rectangle bounds;
            MosaicElement in = this.inputs.get(0);
            if (in == null) {
                throw new NullPointerException("The list of MosaicElements contains one element but it's null");
            }
            PAMDataset pamDataset = in.pamDataset;
            ROI roi = in.roi;
            if (roi != null && (bounds = Utils.toRectangle(roi.getAsShape())) != null && (imageBounds = PlanarImage.wrapRenderedImage(mosaic = in.source).getBounds()).equals(bounds) && rasterMask == null) {
                if (!this.rasterLayerResponse.getRasterBounds().contains(imageBounds)) {
                    XRectangle2D.intersect(imageBounds, this.rasterLayerResponse.getRasterBounds(), imageBounds);
                    if (imageBounds.isEmpty()) {
                        return null;
                    }
                    ImageWorker iw = new ImageWorker(mosaic);
                    iw.setRenderingHints(localHints);
                    iw.crop(imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height);
                    mosaic = iw.getRenderedImage();
                    PlanarImage t = PlanarImage.wrapRenderedImage(mosaic);
                    if (iw.getNoData() != null) {
                        t.setProperty("GC_NODATA", new NoDataContainer(iw.getNoData()));
                        mosaic = t;
                    }
                    imageBounds = t.getBounds();
                }
                if (!imageBounds.contains(this.rasterLayerResponse.getRasterBounds())) {
                    PlanarImage[] planarImageArray;
                    RenderedImage[] renderedImageArray = new RenderedImage[]{mosaic};
                    double[] dArray = this.rasterLayerResponse.getBackgroundValues();
                    if (this.hasAlpha || this.doInputTransparency) {
                        PlanarImage[] planarImageArray2 = new PlanarImage[1];
                        planarImageArray = planarImageArray2;
                        planarImageArray2[0] = in.alphaChannel;
                    } else {
                        PlanarImage[] planarImageArray3 = new PlanarImage[1];
                        planarImageArray = planarImageArray3;
                        planarImageArray3[0] = null;
                    }
                    mosaic = MergeBehavior.FLAT.process(renderedImageArray, dArray, this.sourceThreshold, planarImageArray, new ROI[]{in.roi}, this.rasterLayerResponse.getRequest().isBlend() ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY, localHints);
                    roi = roi.add(new ROIGeometry((Geometry)JTS.toGeometry(new ReferencedEnvelope(this.rasterLayerResponse.getRasterBounds(), null))));
                    if (this.rasterLayerResponse.getFootprintBehavior() != FootprintBehavior.None) {
                        RenderedOp rop = (RenderedOp)mosaic;
                        rop.setProperty("ROI", in.roi);
                        mosaic = this.rasterLayerResponse.getFootprintBehavior().postProcessMosaic(mosaic, in.roi, localHints);
                    }
                }
                return new MosaicElement(in.alphaChannel, roi, mosaic, pamDataset);
            }
        }
        RenderedImage[] sources = new RenderedImage[size];
        PlanarImage[] alphas = new PlanarImage[size];
        ROI[] rois = new ROI[size];
        PAMDataset[] pams = new PAMDataset[size];
        int realROIs = 0;
        for (int i = 0; i < size; ++i) {
            MosaicElement mosaicElement = this.inputs.get(i);
            sources[i] = mosaicElement.source;
            alphas[i] = mosaicElement.alphaChannel;
            rois[i] = mosaicElement.roi;
            pams[i] = mosaicElement.pamDataset;
            if (alphas[i] != null && rois[i] != null) {
                ImageWorker roi = new ImageWorker(rois[i].getAsImage());
                roi.forceComponentColorModel();
                ImageWorker alpha = new ImageWorker(alphas[i]);
                alpha.multiply(roi.getRenderedImage());
                alphas[i] = alpha.getPlanarImage();
            }
            if (mosaicElement.roi == null) continue;
            ++realROIs;
        }
        if (realROIs == 0) {
            rois = null;
        }
        RenderedImage mosaic = this.mergeBehavior.process(sources, this.rasterLayerResponse.getBackgroundValues(), this.sourceThreshold, (PlanarImage[])(this.hasAlpha || this.doInputTransparency ? alphas : null), rois, this.rasterLayerResponse.getRequest().isBlend() ? MosaicDescriptor.MOSAIC_TYPE_BLEND : MosaicDescriptor.MOSAIC_TYPE_OVERLAY, localHints);
        Object property = mosaic.getProperty("ROI");
        ROI rOI = overallROI = property instanceof ROI ? (ROI)property : null;
        if (rasterMask != null) {
            overallROI = overallROI == null ? rasterMask : Utils.roiIntersect(overallROI, rasterMask, responseHints);
            RenderedOp rop = (RenderedOp)mosaic;
            assert (overallROI != null);
            rop.setProperty("ROI", overallROI);
        }
        if ((footprintBehavior = this.rasterLayerResponse.getFootprintBehavior()) == FootprintBehavior.None && rasterMask != null) {
            double[] bg = this.rasterLayerResponse.getBackgroundValues();
            footprintBehavior = bg != null ? FootprintBehavior.Cut : FootprintBehavior.Transparent;
        }
        RenderedImage postProcessed = footprintBehavior.postProcessMosaic(mosaic, overallROI, localHints);
        if (this.hasAlpha || this.doInputTransparency) {
            return new MosaicElement(new ImageWorker(postProcessed).retainLastBand().getPlanarImage(), overallROI, postProcessed, Utils.mergePamDatasets(pams));
        }
        return new MosaicElement(null, overallROI, postProcessed, Utils.mergePamDatasets(pams));
    }

    private ROIGeometry getRasterMask() throws IOException {
        Geometry geometryMask = this.rasterLayerResponse.getGeometryMask();
        ROIGeometry rasterMask = null;
        if (geometryMask != null) {
            if (this.rasterLayerResponse.isHeterogeneousCRS()) {
                LOGGER.warning("Geometry Mask is not currently supported with heterogeneous CRS mosaics. Ignoring it");
                return null;
            }
            Geometry mappedMask = null;
            try {
                mappedMask = JTS.transform(geometryMask, (MathTransform)this.rasterLayerResponse.getFinalWorldToGridCorner());
            }
            catch (MismatchedDimensionException | TransformException e) {
                throw new IOException("Exception occurred while transforming the provided geometryMask", e);
            }
            double maskingBuffer = this.rasterLayerResponse.getMaskingBufferPixels();
            if (maskingBuffer > 0.0) {
                Geometry mappedMaskBox = mappedMask.getEnvelope();
                mappedMask = Utils.decimate(mappedMask);
                mappedMask = mappedMask.buffer(maskingBuffer);
                mappedMaskBox = mappedMaskBox.buffer(maskingBuffer);
                mappedMask = mappedMask.intersection(mappedMaskBox);
            }
            rasterMask = new ROIGeometry(mappedMask, Utils.setupJAIHints(this.rasterLayerResponse.getHints()));
        }
        return rasterMask;
    }
}

