/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.ImageMosaicWalker;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

class ImageMosaicDatastoreWalker
extends ImageMosaicWalker {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicDatastoreWalker.class);

    public ImageMosaicDatastoreWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler) {
        super(configHandler, eventHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        FeatureIterator it = null;
        GranuleCatalog catalog = null;
        try {
            this.configHandler.indexingPreamble();
            this.startTransaction();
            catalog = this.configHandler.getCatalog();
            String locationAttrName = this.configHandler.getRunConfiguration().getParameter("LocationAttribute");
            String requestedTypeName = this.configHandler.getRunConfiguration().getParameter("TypeName");
            String location = this.configHandler.getRunConfiguration().getParameter("LocationAttribute");
            String[] stringArray = catalog.getTypeNames();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                block51: {
                    block56: {
                        String message;
                        block50: {
                            SimpleFeatureCollection coll;
                            block55: {
                                SimpleFeatureType schema;
                                String typeName;
                                block54: {
                                    int numFiles;
                                    Query query;
                                    block53: {
                                        block52: {
                                            if (n2 >= n) break block50;
                                            typeName = stringArray[n2];
                                            if (requestedTypeName != null && !requestedTypeName.equals(typeName)) break block51;
                                            if (Utils.isValidMosaicSchema(catalog.getType(typeName), location)) break block52;
                                            LOGGER.log(Level.FINE, "Skipping invalid mosaic index table " + typeName);
                                            break block51;
                                        }
                                        query = new Query(typeName);
                                        numFiles = catalog.getGranulesCount(query);
                                        if (numFiles > 0) break block53;
                                        LOGGER.log(Level.FINE, "No rows in the typeName: " + typeName);
                                        break block51;
                                    }
                                    this.setNumFiles(numFiles);
                                    coll = catalog.getGranules(query);
                                    schema = (SimpleFeatureType)coll.getSchema();
                                    if (schema.getDescriptor(locationAttrName) != null) break block54;
                                    LOGGER.fine("Skipping feature type " + typeName + " as the location attribute " + locationAttrName + " is not part of the schema");
                                    break block51;
                                }
                                if (schema.getGeometryDescriptor() != null) break block55;
                                LOGGER.fine("Skipping feature type " + typeName + " as it does not have a footprint column");
                                break block51;
                            }
                            it = coll.features();
                            break block56;
                        }
                        if (this.getStop()) {
                            this.rollbackTransaction();
                        } else {
                            this.commitTransaction();
                        }
                        if (it != null) {
                            try {
                                it.close();
                            }
                            catch (Exception e) {
                                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                            }
                        }
                        try {
                            this.closeTransaction();
                        }
                        catch (Exception e) {
                            message = "Unable to close indexing" + e.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message, e);
                            }
                            this.eventHandler.fireException(e);
                        }
                        try {
                            this.configHandler.indexingPostamble(!this.getStop());
                        }
                        catch (Exception e) {
                            message = "Unable to close indexing" + e.getLocalizedMessage();
                            if (LOGGER.isLoggable(Level.WARNING)) {
                                LOGGER.log(Level.WARNING, message, e);
                            }
                            this.eventHandler.fireException(e);
                        }
                        try {
                            if (catalog == null) return;
                            catalog.dispose();
                            return;
                        }
                        catch (RuntimeException e) {
                            message = "Failed to dispose harvesting catalog";
                            if (!LOGGER.isLoggable(Level.WARNING)) return;
                            LOGGER.log(Level.WARNING, message, e);
                            return;
                        }
                    }
                    while (it.hasNext()) {
                        SimpleFeature feature = (SimpleFeature)it.next();
                        Object locationAttrObj = feature.getAttribute(locationAttrName);
                        File file = null;
                        if (locationAttrObj instanceof String) {
                            String path = (String)locationAttrObj;
                            if (Boolean.getBoolean(this.configHandler.getRunConfiguration().getParameter("AbsolutePath")) && !this.checkFile(file = new File(path))) {
                                file = null;
                            }
                            if (!(file != null || (file = new File(this.configHandler.getRunConfiguration().getParameter("RootMosaicDirectory"), path)).exists() && file.canRead() && file.isFile() || this.checkFile(file = new File(path)))) {
                                file = null;
                            }
                            if (file == null) {
                                super.skipFile(path);
                                continue;
                            }
                        } else if (locationAttrObj instanceof File) {
                            file = (File)locationAttrObj;
                        } else {
                            this.eventHandler.fireException(new IOException("Location attribute type not recognized for column name: " + locationAttrName));
                            this.stop();
                            break;
                        }
                        this.handleFile(file);
                    }
                }
                ++n2;
            }
        }
        catch (Exception e) {
            block49: {
                try {
                    LOGGER.log(Level.WARNING, "Failure occurred while collecting the granules", e);
                    try {
                        this.rollbackTransaction();
                    }
                    catch (IOException e1) {
                        throw new IllegalStateException(e1);
                    }
                    if (it == null) break block49;
                }
                catch (Throwable throwable) {
                    if (it != null) {
                        try {
                            it.close();
                        }
                        catch (Exception e2) {
                            LOGGER.log(Level.FINE, e2.getLocalizedMessage(), e2);
                        }
                    }
                    try {
                        this.closeTransaction();
                    }
                    catch (Exception e3) {
                        String message32 = "Unable to close indexing" + e3.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message32, e3);
                        }
                        this.eventHandler.fireException(e3);
                    }
                    try {
                        this.configHandler.indexingPostamble(!this.getStop());
                    }
                    catch (Exception e4) {
                        String message3 = "Unable to close indexing" + e4.getLocalizedMessage();
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, message3, e4);
                        }
                        this.eventHandler.fireException(e4);
                    }
                    try {
                        if (catalog == null) throw throwable;
                        catalog.dispose();
                        throw throwable;
                    }
                    catch (RuntimeException e5) {
                        String message2 = "Failed to dispose harvesting catalog";
                        if (!LOGGER.isLoggable(Level.WARNING)) throw throwable;
                        LOGGER.log(Level.WARNING, message2, e5);
                    }
                    throw throwable;
                }
                try {
                    it.close();
                }
                catch (Exception e6) {
                    LOGGER.log(Level.FINE, e6.getLocalizedMessage(), e6);
                }
            }
            try {
                this.closeTransaction();
            }
            catch (Exception e7) {
                String message22 = "Unable to close indexing" + e7.getLocalizedMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message22, e7);
                }
                this.eventHandler.fireException(e7);
            }
            try {
                this.configHandler.indexingPostamble(!this.getStop());
            }
            catch (Exception e8) {
                String message2 = "Unable to close indexing" + e8.getLocalizedMessage();
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.log(Level.WARNING, message2, e8);
                }
                this.eventHandler.fireException(e8);
            }
            try {
                if (catalog == null) return;
                catalog.dispose();
                return;
            }
            catch (RuntimeException e9) {
                String message3 = "Failed to dispose harvesting catalog";
                if (!LOGGER.isLoggable(Level.WARNING)) return;
                LOGGER.log(Level.WARNING, message3, e9);
                return;
            }
        }
    }
}

