/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import it.geosolutions.imageio.core.CoreCommonImageMetadata;
import it.geosolutions.imageio.imageioimpl.EnhancedImageReadParam;
import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.imageio.pam.PAMDataset;
import it.geosolutions.imageio.pam.PAMParser;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import it.geosolutions.jaiext.range.NoDataContainer;
import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import it.geosolutions.jaiext.vectorbin.VectorBinarizeDescriptor;
import it.geosolutions.jaiext.vectorbin.VectorBinarizeRIF;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JAI;
import javax.media.jai.OperationDescriptor;
import javax.media.jai.PlanarImage;
import javax.media.jai.ROI;
import javax.media.jai.RenderedOp;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;
import org.apache.commons.beanutils.MethodUtils;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.footprint.FootprintBehavior;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.imageio.MaskOverviewProvider;
import org.geotools.coverage.grid.io.imageio.ReadType;
import org.geotools.coverage.util.CoverageUtilities;
import org.geotools.data.Repository;
import org.geotools.gce.imagemosaic.OverviewsController;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.RasterLayerRequest;
import org.geotools.gce.imagemosaic.ReadParamsController;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.util.XRectangle2D;
import org.geotools.image.ImageWorker;
import org.geotools.image.io.ImageIOExt;
import org.geotools.image.jai.Registry;
import org.geotools.image.util.ImageUtilities;
import org.geotools.metadata.i18n.Errors;
import org.geotools.referencing.CRS;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.referencing.operation.matrix.XAffineTransform;
import org.geotools.referencing.operation.transform.AffineTransform2D;
import org.geotools.util.URLs;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.geom.Geometry;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.geometry.BoundingBox;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform2D;
import org.opengis.referencing.operation.TransformException;

public class GranuleDescriptor {
    private static final Logger LOGGER;
    private static final String AUXFILE_EXT = ".aux.xml";
    public static final Hints EXCLUDE_MOSAIC;
    OverviewsController overviewsController;
    private GeneralEnvelope granuleEnvelope;
    private AbstractGridFormat format;
    private Hints hints;
    private static PAMParser pamParser;
    ReferencedEnvelope granuleBBOX;
    MultiLevelROI roiProvider;
    URL granuleUrl;
    int maxDecimationFactor = -1;
    final Map<Integer, GranuleOverviewLevelDescriptor> granuleLevels = Collections.synchronizedMap(new HashMap());
    AffineTransform baseGridToWorld;
    ImageReaderSpi cachedReaderSPI;
    private SimpleFeature originator;
    PAMDataset pamDataset;
    boolean handleArtifactsFiltering = false;
    boolean filterMe = false;
    ImageInputStreamSpi cachedStreamSPI;
    private DatasetLayout layout;
    private MaskOverviewProvider ovrProvider;
    private NoDataContainer noData;
    private Double[] scales;
    private Double[] offsets;

    public GeneralEnvelope getGranuleEnvelope() {
        return this.granuleEnvelope;
    }

    public void setGranuleEnvelope(GeneralEnvelope granuleEnvelope) {
        this.granuleEnvelope = granuleEnvelope;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void init(BoundingBox granuleBBOX, URL granuleUrl, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, boolean heterogeneousGranules, boolean handleArtifactsFiltering, Hints hints) {
        this.granuleBBOX = ReferencedEnvelope.reference(granuleBBOX);
        this.granuleUrl = granuleUrl;
        this.roiProvider = roiProvider;
        this.handleArtifactsFiltering = handleArtifactsFiltering;
        this.hints = new Hints(hints);
        this.filterMe = handleArtifactsFiltering && roiProvider != null;
        this.format = suggestedFormat == null ? GridFormatFinder.findFormat(granuleUrl, EXCLUDE_MOSAIC) : suggestedFormat;
        AbstractGridCoverage2DReader gcReader = null;
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            boolean checkAuxiliaryMetadata;
            MaskOverviewProvider.SpiHelper spiProvider;
            boolean isMultidim;
            gcReader = this.format.getReader(granuleUrl, hints);
            this.layout = gcReader.getDatasetLayout();
            if (heterogeneousGranules) {
                this.granuleBBOX = ReferencedEnvelope.reference(gcReader.getOriginalEnvelope());
            }
            if (!(isMultidim = (spiProvider = new MaskOverviewProvider.SpiHelper(granuleUrl, suggestedSPI, suggestedIsSPI)).isMultidim())) {
                this.granuleEnvelope = gcReader.getOriginalEnvelope();
            }
            this.ovrProvider = new MaskOverviewProvider(this.layout, granuleUrl, spiProvider);
            if (this.cachedStreamSPI == null) {
                this.cachedStreamSPI = this.ovrProvider.getInputStreamSpi();
            }
            assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
            if (inStream == null && (inStream = this.cachedStreamSPI.createInputStreamInstance(granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory())) == null) {
                File file = URLs.urlToFile(granuleUrl);
                if (file == null) throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
                if (!LOGGER.isLoggable(Level.WARNING)) throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
                LOGGER.log(Level.WARNING, Utils.getFileInfo(file));
                throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
            }
            if (this.cachedReaderSPI == null) {
                this.cachedReaderSPI = this.ovrProvider.getImageReaderSpi();
            }
            if (reader == null) {
                if (this.cachedReaderSPI == null) {
                    throw new IllegalArgumentException("Unable to get a ReaderSPI for the provided input: " + granuleUrl.toString());
                }
                reader = this.cachedReaderSPI.createReaderInstance();
            }
            if (reader == null) {
                throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + granuleUrl.toString());
            }
            boolean ignoreMetadata = isMultidim ? this.customizeReaderInitialization(reader, hints) : false;
            reader.setInput(inStream, false, ignoreMetadata);
            Rectangle originalDimension = Utils.getDimension(0, reader);
            GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(new GridEnvelope2D(originalDimension), this.granuleBBOX);
            geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
            this.baseGridToWorld = geMapper.createAffineTransform();
            this.granuleLevels.put(0, new GranuleOverviewLevelDescriptor(1.0, 1.0, originalDimension.width, originalDimension.height));
            if (heterogeneousGranules) {
                GranuleOverviewLevelDescriptor baseOverviewLevelDescriptor = this.granuleLevels.get(0);
                int numberOfOvervies = this.ovrProvider.getNumOverviews();
                AffineTransform2D baseG2W = baseOverviewLevelDescriptor.getGridToWorldTransform();
                int width = baseOverviewLevelDescriptor.getWidth();
                int height = baseOverviewLevelDescriptor.getHeight();
                double resX = AffineTransform2D.getScaleX0(baseG2W);
                double resY = AffineTransform2D.getScaleY0(baseG2W);
                double[] highestRes = new double[]{resX, resY};
                double[][] overviewsResolution = this.ovrProvider.getOverviewResolutions(highestRes[0] * (double)width, highestRes[1] * (double)height);
                this.overviewsController = new OverviewsController(highestRes, numberOfOvervies, overviewsResolution);
            }
            if (hints != null && hints.containsKey(Utils.CHECK_AUXILIARY_METADATA) && (checkAuxiliaryMetadata = ((Boolean)hints.get(Utils.CHECK_AUXILIARY_METADATA)).booleanValue())) {
                this.checkPamDataset();
            }
            this.initFromImageMetadata(reader);
            return;
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        finally {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable e) {
                throw new IllegalArgumentException(e);
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
            if (gcReader != null) {
                try {
                    gcReader.dispose();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private void initFromImageMetadata(ImageReader reader) throws IOException {
        block5: {
            Object imageIndex;
            int index = 0;
            if (this.originator != null && (imageIndex = this.originator.getAttribute("imageindex")) instanceof Integer) {
                index = (Integer)imageIndex;
            }
            try {
                IIOMetadata metadata = reader.getImageMetadata(index);
                if (metadata instanceof CoreCommonImageMetadata) {
                    CoreCommonImageMetadata ccm = (CoreCommonImageMetadata)metadata;
                    double[] noData = ccm.getNoData();
                    if (noData != null) {
                        this.noData = new NoDataContainer(noData);
                    }
                    this.scales = ccm.getScales();
                    this.offsets = ccm.getOffsets();
                }
            }
            catch (UnsupportedOperationException e) {
                if (!LOGGER.isLoggable(Level.FINER)) break block5;
                LOGGER.log(Level.FINER, "Failed to gather metadata, might not be fatal, some readers do not support it", e);
            }
        }
    }

    public OverviewsController getOverviewsController() {
        return this.overviewsController;
    }

    private void checkPamDataset() throws IOException {
        File file = URLs.urlToFile(this.granuleUrl);
        String path = file.getCanonicalPath();
        String auxFile = path + AUXFILE_EXT;
        this.pamDataset = pamParser.parsePAM(auxFile);
    }

    private boolean customizeReaderInitialization(ImageReader reader, Hints hints) {
        if (hints != null && (hints.containsKey(Utils.AUXILIARY_FILES_PATH) || hints.containsKey(Utils.AUXILIARY_DATASTORE_PATH))) {
            try {
                this.updateReaderWithAuxiliaryPath(hints, reader, Utils.AUXILIARY_FILES_PATH, "setAuxiliaryFilesPath");
                this.updateReaderWithAuxiliaryPath(hints, reader, Utils.AUXILIARY_DATASTORE_PATH, "setAuxiliaryDatastorePath");
                if (hints.get(Hints.REPOSITORY) != null && MethodUtils.getAccessibleMethod(reader.getClass(), "setRepository", new Class[]{Repository.class}) != null) {
                    MethodUtils.invokeMethod((Object)reader, "setRepository", hints.get(Hints.REPOSITORY));
                }
                return true;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
        return false;
    }

    private void updateReaderWithAuxiliaryPath(Hints hints, ImageReader reader, Hints.Key key, String method) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        String filePath = (String)hints.get(key);
        if (filePath != null && hints.containsKey(Utils.PARENT_DIR)) {
            String parentDir = (String)hints.get(Utils.PARENT_DIR);
            if (!new File(filePath).isAbsolute()) {
                filePath = parentDir + File.separatorChar + filePath;
            }
        }
        if (filePath != null) {
            MethodUtils.invokeMethod((Object)reader, method, filePath);
        }
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, -1, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, boolean heterogeneousGranules) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, -1, heterogeneousGranules);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, int maxDecimationFactor) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, maxDecimationFactor, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, int maxDecimationFactor, boolean heterogeneousGranules) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, maxDecimationFactor, heterogeneousGranules, false);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, int maxDecimationFactor, boolean heterogeneousGranules, boolean handleArtifactsFiltering) {
        this(granuleLocation, granuleBBox, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, maxDecimationFactor, heterogeneousGranules, handleArtifactsFiltering, null);
    }

    public GranuleDescriptor(String granuleLocation, BoundingBox granuleBBox, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, MultiLevelROI roiProvider, int maxDecimationFactor, boolean heterogeneousGranules, boolean handleArtifactsFiltering, Hints hints) {
        this.maxDecimationFactor = maxDecimationFactor;
        URL rasterFile = URLs.fileToUrl(new File(granuleLocation));
        if (rasterFile == null) {
            return;
        }
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("File found " + granuleLocation);
        }
        this.originator = null;
        this.init(granuleBBox, rasterFile, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, heterogeneousGranules, handleArtifactsFiltering, hints);
    }

    public GranuleDescriptor(SimpleFeature feature, ImageReaderSpi suggestedSPI, AbstractGridFormat suggestedFormat, ImageInputStreamSpi suggestedIsSPI, PathType pathType, String locationAttribute, String parentLocation) {
        this(feature, suggestedFormat, suggestedSPI, suggestedIsSPI, pathType, locationAttribute, parentLocation, false);
    }

    public GranuleDescriptor(SimpleFeature feature, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, PathType pathType, String locationAttribute, String parentLocation, boolean heterogeneousGranules, Hints hints) {
        this(feature, suggestedFormat, suggestedSPI, suggestedIsSPI, pathType, locationAttribute, parentLocation, null, heterogeneousGranules, hints);
    }

    public GranuleDescriptor(SimpleFeature feature, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, PathType pathType, String locationAttribute, String parentLocation, boolean heterogeneousGranules) {
        this(feature, suggestedFormat, suggestedSPI, suggestedIsSPI, pathType, locationAttribute, parentLocation, heterogeneousGranules, null);
    }

    public GranuleDescriptor(SimpleFeature feature, ImageReaderSpi suggestedSPI, PathType pathType, AbstractGridFormat suggestedFormat, ImageInputStreamSpi suggestedIsSPI, String locationAttribute, String parentLocation, MultiLevelROI roiProvider) {
        this(feature, suggestedFormat, suggestedSPI, suggestedIsSPI, pathType, locationAttribute, parentLocation, roiProvider, false, null);
    }

    public GranuleDescriptor(SimpleFeature feature, AbstractGridFormat suggestedFormat, ImageReaderSpi suggestedSPI, ImageInputStreamSpi suggestedIsSPI, PathType pathType, String locationAttribute, String parentLocation, MultiLevelROI roiProvider, boolean heterogeneousGranules, Hints hints) {
        String granuleLocation = (String)feature.getAttribute(locationAttribute);
        ReferencedEnvelope granuleBBox = this.getFeatureBounds(feature);
        URL rasterFile = pathType.resolvePath(parentLocation, granuleLocation);
        if (rasterFile == null) {
            throw new IllegalArgumentException(Errors.format(58, "granuleLocation", granuleLocation));
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("File found " + granuleLocation);
        }
        this.originator = feature;
        this.init(granuleBBox, rasterFile, suggestedFormat, suggestedSPI, suggestedIsSPI, roiProvider, heterogeneousGranules, false, hints);
    }

    private ReferencedEnvelope getFeatureBounds(SimpleFeature feature) {
        Geometry g = (Geometry)feature.getDefaultGeometry();
        if (g == null) {
            return null;
        }
        CoordinateReferenceSystem crs = feature.getFeatureType().getCoordinateReferenceSystem();
        ReferencedEnvelope granuleBBox = new ReferencedEnvelope(g.getEnvelopeInternal(), crs);
        return granuleBBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GranuleLoadingResult loadRaster(ImageReadParam imageReadParameters, int index, ReferencedEnvelope cropBBox, MathTransform2D mosaicWorldToGrid, RasterLayerRequest request, Hints hints) throws IOException {
        ReferencedEnvelope intersection;
        if (LOGGER.isLoggable(Level.FINER)) {
            String name = Thread.currentThread().getName();
            LOGGER.finer("Thread:" + name + " Loading raster data for granuleDescriptor " + this.toString());
        }
        ImageReadParam readParameters = null;
        double[] virtualNativeResolution = request.getVirtualNativeResolution();
        boolean useFootprint = this.roiProvider != null && request.getFootprintBehavior() != FootprintBehavior.None;
        Geometry inclusionGeometry = useFootprint ? this.roiProvider.getFootprint() : null;
        ReferencedEnvelope bbox = useFootprint ? new ReferencedEnvelope(this.granuleBBOX.intersection(inclusionGeometry.getEnvelopeInternal()), this.granuleBBOX.getCoordinateReferenceSystem()) : this.granuleBBOX;
        boolean doFiltering = false;
        if (this.filterMe && useFootprint) {
            doFiltering = Utils.areaIsDifferent(inclusionGeometry, this.baseGridToWorld, this.granuleBBOX);
        }
        if ((intersection = new ReferencedEnvelope(bbox.intersection(cropBBox), cropBBox.getCoordinateReferenceSystem())).isEmpty()) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Got empty intersection for granule " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
            }
            return null;
        }
        if (useFootprint && inclusionGeometry != null && !JTS.toGeometry(cropBBox).intersects(inclusionGeometry)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Got empty intersection for granule " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
            }
            return null;
        }
        ImageInputStream inStream = null;
        ImageReader reader = null;
        boolean cleanupInFinally = request.getReadType() != ReadType.JAI_IMAGEREAD;
        try {
            PlanarImage t;
            Object extender;
            Object scheduler;
            Object cache;
            Object layout;
            PlanarImage pi;
            RenderedImage raster;
            int ssy;
            int ssx;
            int imageIndex;
            if (request.isHeterogeneousGranules() && (this.originator == null || this.originator.getAttribute("imageindex") == null)) {
                readParameters = new ImageReadParam();
                imageIndex = ReadParamsController.setReadParams(request.spatialRequestHelper.getComputedResolution(), request.getOverviewPolicy(), request.getDecimationPolicy(), readParameters, request.rasterManager, this.overviewsController, virtualNativeResolution);
            } else {
                imageIndex = index;
                readParameters = imageReadParameters;
            }
            int ovrIndex = imageIndex;
            boolean isExternal = this.ovrProvider.isExternalOverview(imageIndex);
            URL granuleURLUpdated = this.granuleUrl;
            if (isExternal) {
                granuleURLUpdated = this.ovrProvider.getOvrURL();
                assert (this.ovrProvider.getExternalOverviewInputStreamSpi() != null) : "no cachedStreamSPI available for external overview!";
                inStream = this.ovrProvider.getExternalOverviewInputStreamSpi().createInputStreamInstance(granuleURLUpdated, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                reader = this.ovrProvider.getExternalOverviewReaderSpi().createReaderInstance();
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get s reader for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
                    }
                    GranuleLoadingResult granuleLoadingResult = null;
                    return granuleLoadingResult;
                }
                reader.setInput(inStream, false, false);
                ovrIndex = this.ovrProvider.getOverviewIndex(imageIndex);
            } else {
                ovrIndex = this.ovrProvider.getOverviewIndex(imageIndex);
                assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
                inStream = this.cachedStreamSPI.createInputStreamInstance(this.granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                if (inStream == null) {
                    GranuleLoadingResult granuleLoadingResult = null;
                    return granuleLoadingResult;
                }
                if (this.cachedReaderSPI == null) {
                    reader = ImageIOExt.getImageioReader(inStream);
                    if (reader != null) {
                        this.cachedReaderSPI = reader.getOriginatingProvider();
                    }
                } else {
                    reader = this.cachedReaderSPI.createReaderInstance();
                }
                if (reader == null) {
                    if (LOGGER.isLoggable(Level.WARNING)) {
                        LOGGER.warning("Unable to get s reader for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
                    }
                    GranuleLoadingResult granuleLoadingResult = null;
                    return granuleLoadingResult;
                }
            }
            this.customizeReaderInitialization(reader, hints);
            reader.setInput(inStream);
            if (MethodUtils.getAccessibleMethod(reader.getClass(), "setRasterLayerRequest", RasterLayerRequest.class) != null) {
                try {
                    MethodUtils.invokeMethod((Object)reader, "setRasterLayerRequest", request);
                }
                catch (Exception exception) {
                    throw new RuntimeException("Error setting raster layer request on reader.", exception);
                }
            }
            GranuleOverviewLevelDescriptor selectedlevel = this.getLevel(ovrIndex, reader, imageIndex, isExternal);
            AffineTransform2D cropGridToWorld = new AffineTransform2D(selectedlevel.gridToWorldTransformCorner);
            AffineTransform2D cropWorldToGrid = (AffineTransform2D)cropGridToWorld.inverse();
            Rectangle2D r2d = CRS.transform(cropWorldToGrid, (Envelope)intersection).toRectangle2D();
            if (r2d.getWidth() < 0.1 || r2d.getHeight() < 0.1) {
                cleanupInFinally = true;
                GranuleLoadingResult granuleLoadingResult = null;
                return granuleLoadingResult;
            }
            Rectangle sourceArea = r2d.getBounds();
            if (selectedlevel.baseToLevelTransform.isIdentity()) {
                sourceArea.grow(2, 2);
            }
            XRectangle2D.intersect(sourceArea, selectedlevel.rasterDimensions, sourceArea);
            if (sourceArea.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Got empty area for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result");
                }
                GranuleLoadingResult granuleLoadingResult = null;
                return granuleLoadingResult;
            }
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("Loading level " + imageIndex + " with source region: " + sourceArea + " subsampling: " + readParameters.getSourceXSubsampling() + "," + readParameters.getSourceYSubsampling() + " for granule:" + this.granuleUrl);
            }
            int newSubSamplingFactor = 0;
            String pluginName = this.cachedReaderSPI.getPluginClassName();
            if (pluginName != null && pluginName.equals("it.geosolutions.imageio.plugins.jp2k.JP2KKakaduImageReader") && (newSubSamplingFactor = ImageIOUtilities.getSubSamplingFactor2(ssx = readParameters.getSourceXSubsampling(), ssy = readParameters.getSourceYSubsampling())) != 0) {
                if (newSubSamplingFactor > this.maxDecimationFactor && this.maxDecimationFactor != -1) {
                    newSubSamplingFactor = this.maxDecimationFactor;
                }
                readParameters.setSourceSubsampling(newSubSamplingFactor, newSubSamplingFactor, 0, 0);
            }
            readParameters.setSourceRegion(sourceArea);
            boolean expandToRGB = request.getRasterManager().isExpandMe();
            if (expandToRGB && this.getRawColorModel(reader, ovrIndex) instanceof IndexColorModel && readParameters instanceof EnhancedImageReadParam) {
                EnhancedImageReadParam erp = (EnhancedImageReadParam)readParameters;
                erp.setBands(null);
            }
            try {
                raster = request.getReadType().read(readParameters, ovrIndex, granuleURLUpdated, selectedlevel.rasterDimensions, reader, hints, false);
            }
            catch (Throwable e) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.log(Level.FINE, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
                }
                GranuleLoadingResult granuleLoadingResult = null;
                try {
                    if (cleanupInFinally && inStream != null) {
                        inStream.close();
                    }
                }
                finally {
                    if (cleanupInFinally && reader != null) {
                        reader.dispose();
                    }
                }
                return granuleLoadingResult;
            }
            if (request.getBands() != null && !reader.getFormatName().equalsIgnoreCase("netcdf")) {
                int[] bands;
                ColorModel colorModel;
                if (raster.getColorModel() instanceof IndexColorModel && expandToRGB) {
                    raster = new ImageWorker(raster).forceComponentColorModel().getRenderedImage();
                }
                if ((colorModel = (raster = new ImageWorker(raster).retainBands(bands = request.getBands()).getRenderedImage()).getColorModel()) == null) {
                    ColorModel newColorModel;
                    ImageLayout layout2 = (ImageLayout)hints.get(JAI.KEY_IMAGE_LAYOUT);
                    if (layout2 == null) {
                        layout2 = new ImageLayout();
                    }
                    if ((newColorModel = ImageIOUtilities.createColorModel(raster.getSampleModel())) != null) {
                        layout2.setColorModel(newColorModel);
                        raster = new ImageWorker(raster).setRenderingHints(hints).format(raster.getSampleModel().getDataType()).getRenderedImage();
                    }
                }
            }
            if (request.isRescalingEnabled()) {
                if (this.noData != null && request.getReadType() == ReadType.JAI_IMAGEREAD) {
                    PlanarImage t2 = PlanarImage.wrapRenderedImage(raster);
                    t2.setProperty("GC_NODATA", this.noData);
                    raster = t2;
                }
                raster = ImageUtilities.applyRescaling(this.scales, this.offsets, raster, hints);
            }
            sourceArea.setRect(readParameters.getSourceRegion());
            if (virtualNativeResolution != null && !Double.isNaN(virtualNativeResolution[0]) && !Double.isNaN(virtualNativeResolution[1])) {
                raster = this.forceVirtualNativeResolution(raster, request, virtualNativeResolution, selectedlevel, hints);
            }
            double decimationScaleX = 1.0 * (double)sourceArea.width / (double)raster.getWidth();
            double decimationScaleY = 1.0 * (double)sourceArea.height / (double)raster.getHeight();
            AffineTransform decimationScaleTranform = XAffineTransform.getScaleInstance(decimationScaleX, decimationScaleY);
            AffineTransform afterDecimationTranslateTranform = XAffineTransform.getTranslateInstance(sourceArea.x, sourceArea.y);
            AffineTransform2D backToBaseLevelScaleTransform = selectedlevel.baseToLevelTransform;
            AffineTransform finalRaster2Model = new AffineTransform(this.baseGridToWorld);
            finalRaster2Model.concatenate(CoverageUtilities.CENTER_TO_CORNER);
            if (!XAffineTransform.isIdentity(backToBaseLevelScaleTransform, 1.0E-6)) {
                finalRaster2Model.concatenate(backToBaseLevelScaleTransform);
            }
            if (!XAffineTransform.isIdentity(afterDecimationTranslateTranform, 1.0E-6)) {
                finalRaster2Model.concatenate(afterDecimationTranslateTranform);
            }
            if (!XAffineTransform.isIdentity(decimationScaleTranform, 1.0E-6)) {
                finalRaster2Model.concatenate(decimationScaleTranform);
            }
            if (useFootprint) {
                ROI transformed;
                block139: {
                    try {
                        Rectangle imgBounds = new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
                        transformed = this.roiProvider.getTransformedROI(finalRaster2Model.createInverse(), imageIndex, imgBounds, readParameters, request.getReadType());
                        if (transformed instanceof ROIGeometry && ((ROIGeometry)transformed).getAsGeometry().isEmpty()) {
                            GranuleLoadingResult granuleLoadingResult = null;
                            return granuleLoadingResult;
                        }
                        if (transformed != null && !transformed.getBounds().isEmpty()) break block139;
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.fine("Unable to create a granuleDescriptor " + this.toString() + " due to a problem when managing the ROI");
                        }
                        GranuleLoadingResult granuleLoadingResult = null;
                        return granuleLoadingResult;
                    }
                    catch (NoninvertibleTransformException e) {
                        if (LOGGER.isLoggable(Level.INFO)) {
                            LOGGER.info("Unable to create a granuleDescriptor " + this.toString() + " due to a problem when managing the ROI");
                        }
                        pi = null;
                        return pi;
                    }
                }
                pi = PlanarImage.wrapRenderedImage(raster);
                if (!transformed.intersects(pi.getBounds())) {
                    GranuleLoadingResult granuleLoadingResult = null;
                    return granuleLoadingResult;
                }
                pi.setProperty("ROI", transformed);
                if (pi instanceof RenderedOp) {
                    PlanarImage theImage = ((RenderedOp)pi).getRendering();
                    theImage.setProperty("ROI", transformed);
                }
                raster = pi;
            }
            finalRaster2Model.preConcatenate((AffineTransform)((Object)mosaicWorldToGrid));
            Interpolation interpolation = request.getInterpolation();
            Rectangle2D finalLayout = ImageUtilities.layoutHelper(raster, (float)finalRaster2Model.getScaleX(), (float)finalRaster2Model.getScaleY(), (float)finalRaster2Model.getTranslateX(), (float)finalRaster2Model.getTranslateY(), interpolation);
            if (finalLayout.isEmpty()) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Unable to create a granuleDescriptor " + this.toString() + " due to jai scale bug creating a null source area");
                }
                pi = null;
                return pi;
            }
            RenderingHints localHints = new RenderingHints(JAI.KEY_REPLACE_INDEX_COLOR_MODEL, interpolation instanceof InterpolationNearest ? Boolean.FALSE : Boolean.TRUE);
            if (XAffineTransform.isIdentity(finalRaster2Model, 1.0E-6)) {
                Object t3;
                if (this.noData != null) {
                    t3 = PlanarImage.wrapRenderedImage(raster);
                    ((PlanarImage)t3).setProperty("GC_NODATA", this.noData);
                    raster = t3;
                }
                t3 = new GranuleLoadingResult(raster, null, granuleURLUpdated, doFiltering, this.pamDataset, this);
                return t3;
            }
            Dimension tileDimensions = request.getTileDimensions();
            if (tileDimensions != null && request.getReadType().equals((Object)ReadType.DIRECT_READ)) {
                layout = new ImageLayout();
                ((ImageLayout)layout).setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
                localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout));
            } else if (hints != null && hints.containsKey(JAI.KEY_IMAGE_LAYOUT) && (layout = hints.get(JAI.KEY_IMAGE_LAYOUT)) != null && layout instanceof ImageLayout) {
                localHints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, ((ImageLayout)layout).clone()));
            }
            if (hints != null && hints.containsKey(JAI.KEY_TILE_CACHE) && (cache = hints.get(JAI.KEY_TILE_CACHE)) != null && cache instanceof TileCache) {
                localHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, cache));
            }
            if (hints != null && hints.containsKey(JAI.KEY_TILE_SCHEDULER) && (scheduler = hints.get(JAI.KEY_TILE_SCHEDULER)) != null && scheduler instanceof TileScheduler) {
                localHints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, scheduler));
            }
            boolean addBorderExtender = true;
            if (hints != null && hints.containsKey(JAI.KEY_BORDER_EXTENDER) && (extender = hints.get(JAI.KEY_BORDER_EXTENDER)) != null && extender instanceof BorderExtender) {
                localHints.add(new RenderingHints(JAI.KEY_BORDER_EXTENDER, extender));
                addBorderExtender = false;
            }
            if (addBorderExtender) {
                localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
            }
            ImageWorker iw = new ImageWorker(raster);
            if (virtualNativeResolution != null && !Double.isNaN(virtualNativeResolution[0]) && !Double.isNaN(virtualNativeResolution[1])) {
                localHints.add(new RenderingHints(ImageWorker.PRESERVE_CHAINED_AFFINES, true));
            }
            iw.setRenderingHints(localHints);
            if (iw.getNoData() == null && this.noData != null) {
                iw.setNoData(this.noData.getAsRange());
            }
            iw.affine(finalRaster2Model, interpolation, request.getBackgroundValues());
            RenderedImage renderedImage = iw.getRenderedImage();
            Object roi = renderedImage.getProperty("ROI");
            if (useFootprint && roi instanceof ROIGeometry && ((ROIGeometry)roi).getAsGeometry().isEmpty() || roi instanceof ROI && ((ROI)roi).getBounds().isEmpty()) {
                GranuleLoadingResult granuleLoadingResult = null;
                return granuleLoadingResult;
            }
            if (iw.getNoData() != null) {
                t = PlanarImage.wrapRenderedImage(renderedImage);
                t.setProperty("GC_NODATA", new NoDataContainer(iw.getNoData()));
                renderedImage = t;
            } else if (this.noData != null) {
                t = PlanarImage.wrapRenderedImage(renderedImage);
                t.setProperty("GC_NODATA", this.noData);
                renderedImage = t;
            }
            GranuleLoadingResult granuleLoadingResult = new GranuleLoadingResult(renderedImage, null, granuleURLUpdated, doFiltering, this.pamDataset, this);
            return granuleLoadingResult;
        }
        catch (IllegalStateException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
            }
            GranuleLoadingResult granuleLoadingResult = null;
            return granuleLoadingResult;
        }
        catch (org.opengis.referencing.operation.NoninvertibleTransformException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
            }
            GranuleLoadingResult granuleLoadingResult = null;
            return granuleLoadingResult;
        }
        catch (TransformException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Unable to load raster for granuleDescriptor " + this.toString() + " with request " + request.toString() + " Resulting in no granule loaded: Empty result", e);
            }
            GranuleLoadingResult granuleLoadingResult = null;
            return granuleLoadingResult;
        }
        finally {
            try {
                if (cleanupInFinally && inStream != null) {
                    inStream.close();
                }
            }
            finally {
                if (cleanupInFinally && reader != null) {
                    reader.dispose();
                }
            }
        }
    }

    private RenderedImage forceVirtualNativeResolution(RenderedImage raster, RasterLayerRequest request, double[] virtualNativeResolution, GranuleOverviewLevelDescriptor selectedlevel, Hints hints) {
        Object layout;
        AffineTransform virtualTransform = XAffineTransform.getScaleInstance(XAffineTransform.getScaleX0(selectedlevel.gridToWorldTransformCorner) / virtualNativeResolution[0], XAffineTransform.getScaleY0(selectedlevel.gridToWorldTransformCorner) / virtualNativeResolution[1]);
        Dimension tileDimensions = request.getTileDimensions();
        RenderingHints localHints = null;
        if (tileDimensions != null && request.getReadType().equals((Object)ReadType.DIRECT_READ)) {
            layout = new ImageLayout();
            ((ImageLayout)layout).setTileHeight(tileDimensions.width).setTileWidth(tileDimensions.height);
            localHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, layout);
        } else if (hints != null && hints.containsKey(JAI.KEY_IMAGE_LAYOUT) && (layout = hints.get(JAI.KEY_IMAGE_LAYOUT)) != null && layout instanceof ImageLayout) {
            ImageLayout originalLayout = (ImageLayout)layout;
            ImageLayout localLayout = new ImageLayout();
            localLayout.setTileHeight(originalLayout.getTileHeight(null));
            localLayout.setTileWidth(originalLayout.getTileWidth(null));
            localHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, localLayout);
        }
        if (localHints == null) {
            localHints = new RenderingHints(null);
        }
        this.updateLocalHints(hints, localHints);
        localHints.add(ImageUtilities.BORDER_EXTENDER_HINTS);
        ImageWorker worker = new ImageWorker(raster).setRenderingHints(localHints);
        return worker.affine(virtualTransform, request.getInterpolation(), request.getBackgroundValues()).getRenderedImage();
    }

    private void updateLocalHints(Hints hints, RenderingHints localHints) {
        Object scheduler;
        Object cache;
        if (hints != null && hints.containsKey(JAI.KEY_TILE_CACHE) && (cache = hints.get(JAI.KEY_TILE_CACHE)) != null && cache instanceof TileCache) {
            localHints.add(new RenderingHints(JAI.KEY_TILE_CACHE, (TileCache)cache));
        }
        if (hints != null && hints.containsKey(JAI.KEY_TILE_SCHEDULER) && (scheduler = hints.get(JAI.KEY_TILE_SCHEDULER)) != null && scheduler instanceof TileScheduler) {
            localHints.add(new RenderingHints(JAI.KEY_TILE_SCHEDULER, (TileScheduler)scheduler));
        }
    }

    private ColorModel getRawColorModel(ImageReader reader, int imageIndex) {
        try {
            ImageTypeSpecifier imageType = reader.getRawImageType(imageIndex);
            if (imageType == null) {
                return null;
            }
            ColorModel cm = imageType.getColorModel();
            return cm;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Failed to determine the native color model of the reader", e);
            return null;
        }
    }

    private GranuleOverviewLevelDescriptor getLevel(int index, ImageReader reader, int imageIndex, boolean external) {
        int indexValue;
        int n = indexValue = external ? imageIndex : index;
        if (reader == null) {
            throw new NullPointerException("Null reader passed to the internal GranuleOverviewLevelDescriptor method");
        }
        Map<Integer, GranuleOverviewLevelDescriptor> map = this.granuleLevels;
        synchronized (map) {
            if (this.granuleLevels.containsKey(indexValue)) {
                return this.granuleLevels.get(indexValue);
            }
            try {
                Rectangle levelDimension = Utils.getDimension(index, reader);
                GranuleOverviewLevelDescriptor baseLevel = this.granuleLevels.get(0);
                double scaleX = (double)baseLevel.width / (1.0 * (double)levelDimension.width);
                double scaleY = (double)baseLevel.height / (1.0 * (double)levelDimension.height);
                GranuleOverviewLevelDescriptor newLevel = new GranuleOverviewLevelDescriptor(scaleX, scaleY, levelDimension.width, levelDimension.height);
                this.granuleLevels.put(indexValue, newLevel);
                return newLevel;
            }
            catch (IllegalStateException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GranuleOverviewLevelDescriptor getLevel(int index) {
        ImageInputStream inStream = null;
        ImageReader reader = null;
        try {
            assert (this.cachedStreamSPI != null) : "no cachedStreamSPI available!";
            inStream = this.cachedStreamSPI.createInputStreamInstance(this.granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
            if (inStream == null) {
                throw new IllegalArgumentException("Unable to create an inputstream for the granuleurl:" + (this.granuleUrl != null ? this.granuleUrl : "null"));
            }
            if (this.cachedReaderSPI == null) {
                reader = ImageIOExt.getImageioReader(inStream);
                if (reader != null) {
                    this.cachedReaderSPI = reader.getOriginatingProvider();
                }
            } else {
                reader = this.cachedReaderSPI.createReaderInstance();
            }
            if (reader == null) {
                throw new IllegalArgumentException("Unable to get an ImageReader for the provided file " + this.granuleUrl.toString());
            }
            boolean ignoreMetadata = this.customizeReaderInitialization(reader, null);
            reader.setInput(inStream, false, ignoreMetadata);
            return this.getLevel(index, reader, index, false);
        }
        catch (IllegalStateException e) {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
            throw new IllegalArgumentException(e);
        }
        catch (IOException e) {
            try {
                if (inStream != null) {
                    inStream.close();
                }
            }
            catch (Throwable throwable) {
            }
            finally {
                if (reader != null) {
                    reader.dispose();
                }
            }
            throw new IllegalArgumentException(e);
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Description of a granuleDescriptor ").append("\n");
        buffer.append("BBOX:\t\t").append(this.granuleBBOX.toString()).append("\n");
        buffer.append("file:\t\t").append(this.granuleUrl).append("\n");
        buffer.append("gridToWorld:\t\t").append(this.baseGridToWorld).append("\n");
        int i = 1;
        for (GranuleOverviewLevelDescriptor granuleOverviewLevelDescriptor : this.granuleLevels.values()) {
            int n = ++i;
            ++i;
            buffer.append("Description of level ").append(n).append("\n");
            buffer.append(granuleOverviewLevelDescriptor.toString()).append("\n");
        }
        return buffer.toString();
    }

    public BoundingBox getGranuleBBOX() {
        return this.granuleBBOX;
    }

    public URL getGranuleUrl() {
        return this.granuleUrl;
    }

    public SimpleFeature getOriginator() {
        return this.originator;
    }

    public Geometry getFootprint() {
        if (this.roiProvider == null) {
            return null;
        }
        return this.roiProvider.getFootprint();
    }

    public AbstractGridCoverage2DReader getReader() {
        return this.format.getReader(this.granuleUrl, this.hints);
    }

    public MultiLevelROI getRoiProvider() {
        return this.roiProvider;
    }

    static {
        block2: {
            LOGGER = Logging.getLogger(GranuleDescriptor.class);
            EXCLUDE_MOSAIC = new Hints(Utils.EXCLUDE_MOSAIC, true);
            try {
                Registry.registerRIF(JAI.getDefaultInstance(), (OperationDescriptor)new VectorBinarizeDescriptor(), new VectorBinarizeRIF(), "org.jaitools.media.jai");
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINE)) break block2;
                LOGGER.log(Level.FINE, e.getLocalizedMessage());
            }
        }
        pamParser = PAMParser.getInstance();
    }

    public static class GranuleLoadingResult {
        RenderedImage loadedImage;
        ROI footprint;
        URL granuleUrl;
        boolean doFiltering;
        PAMDataset pamDataset;
        GranuleDescriptor granuleDescriptor;

        public ROI getFootprint() {
            return this.footprint;
        }

        public RenderedImage getRaster() {
            return this.loadedImage;
        }

        public URL getGranuleUrl() {
            return this.granuleUrl;
        }

        public PAMDataset getPamDataset() {
            return this.pamDataset;
        }

        public void setPamDataset(PAMDataset pamDataset) {
            this.pamDataset = pamDataset;
        }

        public boolean isDoFiltering() {
            return this.doFiltering;
        }

        public GranuleDescriptor getGranuleDescriptor() {
            return this.granuleDescriptor;
        }

        GranuleLoadingResult(RenderedImage loadedImage, ROI footprint, URL granuleUrl, boolean doFiltering, PAMDataset pamDataset, GranuleDescriptor granuleDescriptor) {
            this.loadedImage = loadedImage;
            Object roi = loadedImage.getProperty("ROI");
            if (roi instanceof ROI) {
                this.footprint = (ROI)roi;
            }
            this.granuleUrl = granuleUrl;
            this.doFiltering = doFiltering;
            this.pamDataset = pamDataset;
            this.granuleDescriptor = granuleDescriptor;
        }
    }

    class GranuleOverviewLevelDescriptor {
        final double scaleX;
        final double scaleY;
        final int width;
        final int height;
        final AffineTransform2D baseToLevelTransform;
        final AffineTransform2D gridToWorldTransformCorner;
        final Rectangle rasterDimensions;

        public AffineTransform getBaseToLevelTransform() {
            return this.baseToLevelTransform;
        }

        public double getScaleX() {
            return this.scaleX;
        }

        public double getScaleY() {
            return this.scaleY;
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public GranuleOverviewLevelDescriptor(double scaleX, double scaleY, int width, int height) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.baseToLevelTransform = new AffineTransform2D(XAffineTransform.getScaleInstance(scaleX, scaleY, 0.0, 0.0));
            AffineTransform gridToWorldTransform_ = new AffineTransform(this.baseToLevelTransform);
            gridToWorldTransform_.preConcatenate(CoverageUtilities.CENTER_TO_CORNER);
            gridToWorldTransform_.preConcatenate(GranuleDescriptor.this.baseGridToWorld);
            this.gridToWorldTransformCorner = new AffineTransform2D(gridToWorldTransform_);
            this.width = width;
            this.height = height;
            this.rasterDimensions = new Rectangle(0, 0, width, height);
        }

        public Rectangle getBounds() {
            return (Rectangle)this.rasterDimensions.clone();
        }

        public AffineTransform2D getGridToWorldTransform() {
            return this.gridToWorldTransformCorner;
        }

        public String toString() {
            StringBuilder buffer = new StringBuilder();
            buffer.append("Description of a granuleDescriptor level").append("\n").append("width:\t\t").append(this.width).append("\n").append("height:\t\t").append(this.height).append("\n").append("scaleX:\t\t").append(this.scaleX).append("\n").append("scaleY:\t\t").append(this.scaleY).append("\n").append("baseToLevelTransform:\t\t").append(this.baseToLevelTransform.toString()).append("\n").append("gridToWorldTransform:\t\t").append(this.gridToWorldTransformCorner.toString()).append("\n");
            return buffer.toString();
        }
    }
}

