/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.HashMap;
import java.util.Map;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollector;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollectorSPI;
import org.geotools.gce.imagemosaic.namecollector.CoverageNameCollectorSpiFinder;

class CoverageNameHandler {
    private CoverageNameCollectorSPI spi;
    private Map<String, String> properties;

    CoverageNameHandler(CoverageNameCollectorSPI spi) {
        this.spi = spi;
    }

    CoverageNameHandler(String coverageNameCollectors) {
        if (coverageNameCollectors != null && coverageNameCollectors.length() > 0) {
            CoverageNameCollectorSPI spi;
            if (coverageNameCollectors.contains(":")) {
                int indexOf = coverageNameCollectors.indexOf(":");
                String properties = coverageNameCollectors.substring(indexOf + 1);
                coverageNameCollectors = coverageNameCollectors.substring(0, indexOf);
                this.initializeProperties(properties);
            }
            if ((spi = CoverageNameCollectorSpiFinder.getCoverageNameCollectorSPI().get(coverageNameCollectors)) != null) {
                this.spi = spi;
            }
        }
    }

    CoverageNameHandler(CoverageNameCollectorSPI spi, Map<String, String> properties) {
        this.spi = spi;
        this.properties = properties;
    }

    private void initializeProperties(String propertiesString) {
        if (propertiesString != null && !propertiesString.trim().isEmpty()) {
            String[] propertiesKVP = propertiesString.split(";");
            this.properties = new HashMap<String, String>();
            for (String property : propertiesKVP) {
                String[] kvp = property.split("=");
                this.properties.put(kvp[0], kvp[1]);
            }
        }
    }

    String getTargetCoverageName(GridCoverage2DReader inputCoverageReader, Map<String, String> map) {
        CoverageNameCollector collector = this.spi.create(inputCoverageReader, this.properties);
        return collector.getName(inputCoverageReader, map);
    }
}

