/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.data.util.BooleanConverterFactory;
import org.geotools.data.util.NumericConverterFactory;
import org.geotools.gce.imagemosaic.TemporalConverterFactoryHack;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

final class ConvertersHack {
    private static final Logger LOGGER = Logging.getLogger(ConvertersHack.class);
    static final ConverterFactory[] factories = new ConverterFactory[]{new NumericConverterFactory(), new BooleanConverterFactory(), new TemporalConverterFactoryHack()};

    ConvertersHack() {
    }

    public static <T> T convert(Object source, Class<T> target) {
        return ConvertersHack.convert(source, target, null);
    }

    public static <T> T convert(Object source, Class<T> target, Hints hints) {
        if (source == null) {
            return null;
        }
        Class<?> sourceClass = source.getClass();
        if (sourceClass == target || sourceClass.equals(target) || target.isAssignableFrom(sourceClass)) {
            return target.cast(source);
        }
        for (ConverterFactory factory : factories) {
            Converter converter = factory.createConverter(sourceClass, target, hints);
            if (converter == null) continue;
            try {
                T converted = converter.convert(source, target);
                if (converted == null) continue;
                return converted;
            }
            catch (Exception e) {
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.log(Level.FINER, "Error applying the converter " + converter.getClass() + " on (" + source + "," + target + ")", e);
            }
        }
        if (String.class.equals(target)) {
            return target.cast(source.toString());
        }
        return null;
    }
}

