/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.h2;

import java.io.Reader;
import org.geotools.util.Converter;
import org.geotools.util.ConverterFactory;
import org.geotools.util.factory.Hints;
import org.h2.jdbc.JdbcClob;

public class H2ClobConverterFactory
implements ConverterFactory {
    H2ClobConverter converter = new H2ClobConverter();

    @Override
    public Converter createConverter(Class<?> source, Class<?> target, Hints hints) {
        if (!String.class.equals(target)) {
            return null;
        }
        if (!JdbcClob.class.isAssignableFrom(source)) {
            return null;
        }
        return this.converter;
    }

    class H2ClobConverter
    implements Converter {
        H2ClobConverter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T convert(Object source, Class<T> target) throws Exception {
            JdbcClob clob = (JdbcClob)source;
            try (Reader r = null;){
                int read;
                StringBuilder sb = new StringBuilder();
                char[] cbuf = new char[4096];
                r = clob.getCharacterStream();
                while ((read = r.read(cbuf)) > 0) {
                    sb.append(cbuf, 0, read);
                }
                String string = sb.toString();
                return (T)string;
            }
        }
    }
}

