/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.egr;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.RenderedImage;
import java.util.ArrayList;
import java.util.List;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.egr.Binarizator;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ROIExcessGranuleRemover {
    public static final int DEFAULT_TILE_SIZE = 256;
    Binarizator binarizator;
    Rectangle rasterBounds;
    int tileWidth;
    int tileHeight;
    CoordinateReferenceSystem targetCRS;
    List<ROI> roiBuffer = new ArrayList<ROI>();

    public ROIExcessGranuleRemover(Rectangle rasterBounds, int tileWidth, int tileHeight, CoordinateReferenceSystem targetCRS) {
        this.rasterBounds = rasterBounds;
        this.tileWidth = tileWidth;
        this.tileHeight = tileHeight;
        this.targetCRS = targetCRS;
    }

    public boolean addGranule(GranuleDescriptor.GranuleLoadingResult result) {
        boolean essential;
        CoordinateReferenceSystem granuleCRS = result.getGranuleDescriptor().getGranuleEnvelope().getCoordinateReferenceSystem();
        if (granuleCRS != null && this.targetCRS != null && !CRS.equalsIgnoreMetadata((Object)granuleCRS, (Object)this.targetCRS)) {
            throw new UnsupportedOperationException("Excess granule removal not yet supported with heterogeneous CRS");
        }
        if (this.binarizator != null && this.binarizator.isComplete()) {
            return false;
        }
        ROI roi = result.getFootprint();
        if (roi == null) {
            RenderedImage raster = result.getRaster();
            Rectangle bounds = new Rectangle(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
            roi = new ROIShape((Shape)bounds);
        }
        if (!roi.getBounds().intersects(this.rasterBounds)) {
            essential = false;
        } else {
            if (this.binarizator == null) {
                this.binarizator = new Binarizator(JTS.toPolygon((Rectangle)this.rasterBounds), this.rasterBounds.width, this.rasterBounds.height, this.tileWidth, this.tileHeight);
            }
            essential = this.binarizator.add(roi);
        }
        return essential;
    }

    public boolean isRenderingAreaComplete() {
        return this.binarizator != null && this.binarizator.isComplete();
    }
}

