/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import it.geosolutions.jaiext.vectorbin.ROIGeometry;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.media.jai.ROI;
import javax.media.jai.ROIShape;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.coverage.grid.io.imageio.ReadType;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.util.SoftValueHashMap;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.locationtech.jts.awt.ShapeReader;
import org.locationtech.jts.geom.CoordinateSequenceFilter;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.util.AffineTransformation;
import org.locationtech.jts.simplify.TopologyPreservingSimplifier;

public class MultiLevelROIGeometryOverviews
implements MultiLevelROI {
    private static final Logger LOGGER = Logging.getLogger(MultiLevelROIGeometryOverviews.class);
    private static final AffineTransformation Y_INVERSION = new AffineTransformation(1.0, 0.0, 0.0, 0.0, -1.0, 0.0);
    private Geometry originalFootprint;
    private List<Geometry> multilevelFootprints;
    private SoftValueHashMap<AffineTransform, ROIGeometry> roiCache = new SoftValueHashMap(10);
    private boolean empty;
    private int numOverviews;
    private Hints hints;
    private boolean overviewsRoiInRasterSpace;

    public MultiLevelROIGeometryOverviews(Geometry footprint, List<Geometry> multilevelFootprints, boolean overviewsInRasterSpace, Hints hints) {
        this.originalFootprint = footprint;
        this.multilevelFootprints = multilevelFootprints;
        this.numOverviews = multilevelFootprints != null ? multilevelFootprints.size() : 0;
        this.overviewsRoiInRasterSpace = overviewsInRasterSpace;
        this.empty = this.originalFootprint.isEmpty();
        this.hints = hints;
    }

    public ROIGeometry getTransformedROI(AffineTransform at, int imageIndex, Rectangle imgBounds, ImageReadParam params, ReadType readType) {
        ROIGeometry roiGeometry;
        if (this.empty) {
            return null;
        }
        if (at == null) {
            at = new AffineTransform();
        }
        if ((roiGeometry = (ROIGeometry)this.roiCache.get((Object)at)) == null) {
            Geometry rescaled;
            boolean useOverviews = imageIndex != 0 && this.numOverviews > 0;
            Geometry geometry = rescaled = useOverviews ? this.multilevelFootprints.get(imageIndex - 1).copy() : this.originalFootprint.copy();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Using footprint's overview: " + useOverviews);
            }
            AffineTransformation geometryAT = null;
            if (useOverviews && this.overviewsRoiInRasterSpace) {
                Rectangle sourceRegion = params.getSourceRegion();
                double xScale = imgBounds.getWidth() / sourceRegion.getWidth() * 1.0;
                double yScale = imgBounds.getHeight() / sourceRegion.getHeight() * 1.0;
                geometryAT = new AffineTransformation(1.0, 0.0, (double)(-sourceRegion.x), 0.0, 1.0, (double)(-sourceRegion.y));
                geometryAT.scale(xScale, yScale);
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("Adapting overview's geometry to current image, using transformation: " + geometryAT.toString());
                }
                rescaled.apply((CoordinateSequenceFilter)geometryAT);
            } else {
                geometryAT = new AffineTransformation(at.getScaleX(), at.getShearX(), at.getTranslateX(), at.getShearY(), at.getScaleY(), at.getTranslateY());
                rescaled.apply((CoordinateSequenceFilter)geometryAT);
            }
            if (!rescaled.isEmpty()) {
                Geometry simplified = TopologyPreservingSimplifier.simplify((Geometry)rescaled, (double)0.333);
                roiGeometry = new FastClipROIGeometry(simplified, this.hints);
                this.roiCache.put((Object)at, (Object)roiGeometry);
            } else {
                return null;
            }
        }
        return roiGeometry;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Geometry getFootprint() {
        return this.originalFootprint;
    }

    static class FastClipROIGeometry
    extends ROIGeometry {
        private static final long serialVersionUID = -4283288388988174306L;
        private Hints hints;

        public FastClipROIGeometry(Geometry geom, Hints hints) {
            super(geom, (RenderingHints)hints);
            this.hints = hints;
        }

        public ROI intersect(ROI roi) {
            Geometry geom = this.getGeometry(roi);
            if (geom != null && geom.equalsExact(geom.getEnvelope())) {
                GeometryClipper clipper = new GeometryClipper(geom.getEnvelopeInternal());
                Geometry intersect = clipper.clip(this.getAsGeometry(), true);
                return new ROIGeometry(intersect, (RenderingHints)this.hints);
            }
            return super.intersect(roi);
        }

        private Geometry getGeometry(ROI roi) {
            if (roi instanceof ROIGeometry) {
                return ((ROIGeometry)roi).getAsGeometry();
            }
            if (roi instanceof ROIShape) {
                Shape shape = ((ROIShape)roi).getAsShape();
                Geometry geom = ShapeReader.read((Shape)shape, (double)0.0, (GeometryFactory)new GeometryFactory());
                geom.apply((CoordinateSequenceFilter)Y_INVERSION);
                return geom;
            }
            return null;
        }
    }
}

