/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.GranuleStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogSource;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;

public class GranuleCatalogStore
extends GranuleCatalogSource
implements GranuleStore {
    static final Logger LOGGER = Logging.getLogger(GranuleCatalogStore.class);
    static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private Transaction transaction;
    private RasterManager manager;

    public GranuleCatalogStore(RasterManager manager, GranuleCatalog catalog, String typeName, Hints hints) {
        super(catalog, typeName, hints);
        this.manager = manager;
    }

    public void addGranules(SimpleFeatureCollection granules) {
        this.checkTransaction();
        SimpleFeatureIterator features = granules.features();
        boolean firstSchemaCompatibilityCheck = false;
        while (features.hasNext()) {
            SimpleFeature feature = (SimpleFeature)features.next();
            if (!firstSchemaCompatibilityCheck) {
                firstSchemaCompatibilityCheck = true;
                this.checkSchemaCompatibility(feature);
            }
            try {
                this.catalog.addGranule(this.typeName, feature, this.transaction);
            }
            catch (IOException e) {
                throw new RuntimeException("Exception occurred while adding granules to the catalog", e);
            }
        }
    }

    private void checkTransaction() {
        if (this.transaction == null) {
            throw new IllegalArgumentException("No transaction available for this store");
        }
    }

    private void checkSchemaCompatibility(SimpleFeature feature) {
        try {
            if (!feature.getType().equals(this.catalog.getType(this.typeName))) {
                throw new IllegalArgumentException("The schema of the provided collection is not the same of the underlying catalog");
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Exception occurred while getting the underlying catalog schema");
        }
    }

    public int removeGranules(Filter filter) {
        return this.removeGranules(filter, null);
    }

    public int removeGranules(Filter filter, Hints hints) {
        try {
            int removed = this.catalog.removeGranules(new Query(this.typeName, filter));
            Query q = new Query(this.manager.getTypeName());
            q.setMaxFeatures(1);
            if (DataUtilities.count((FeatureCollection)this.catalog.getGranules(q)) > 0) {
                this.manager.initialize(true);
            }
            return removed;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to remove granules matching " + filter, e);
        }
    }

    public void updateGranules(String[] attributeNames, Object[] attributeValues, Filter filter) {
        throw new UnsupportedOperationException("Operation not supported");
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        if (transaction == null) {
            throw new IllegalArgumentException("Transaction cannot be null");
        }
        this.transaction = transaction;
    }
}

