/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.footprint.MultiLevelROI;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.Transaction;
import org.geotools.data.collection.ListFeatureCollection;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.SchemaException;
import org.geotools.feature.visitor.FeatureCalc;
import org.geotools.gce.imagemosaic.GranuleDescriptor;
import org.geotools.gce.imagemosaic.PathType;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalog;
import org.geotools.gce.imagemosaic.catalog.GranuleCatalogVisitor;
import org.geotools.util.Utilities;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.identity.FeatureId;
import org.opengis.geometry.BoundingBox;

abstract class AbstractGTDataStoreGranuleCatalog
extends GranuleCatalog {
    protected static final Boolean TRACE_ENABLED = "true".equalsIgnoreCase(System.getProperty("gt2.mosaic.index.trace"));
    static final Logger LOGGER = Logging.getLogger(AbstractGTDataStoreGranuleCatalog.class);
    static final FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2((Hints)GeoTools.getDefaultHints());
    private Throwable tracer;
    private String geometryPropertyName;
    PathType pathType;
    String locationAttribute;
    ImageReaderSpi suggestedRasterSPI;
    AbstractGridFormat suggestedFormat;
    ImageInputStreamSpi suggestedIsSPI;
    String parentLocation;
    boolean heterogeneous;
    boolean wrapstore = false;
    protected Properties params;
    private DataStoreFactorySpi spi;

    public AbstractGTDataStoreGranuleCatalog(Properties params, boolean create, DataStoreFactorySpi spi, Hints hints) {
        super(hints);
        Utilities.ensureNonNull((String)"params", (Object)params);
        this.spi = spi;
        this.params = params;
        try {
            this.pathType = (PathType)((Object)params.get("PathType"));
            this.locationAttribute = (String)params.get("LocationAttribute");
            String temp = (String)params.get("SuggestedSPI");
            this.suggestedRasterSPI = temp != null ? (ImageReaderSpi)Class.forName(temp).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
            String temp2 = (String)params.get("SuggestedFormat");
            this.suggestedFormat = temp2 != null ? (AbstractGridFormat)Class.forName(temp2).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
            String temp3 = (String)params.get("SuggestedIsSPI");
            this.suggestedIsSPI = temp3 != null ? (ImageInputStreamSpi)Class.forName(temp3).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]) : null;
            this.parentLocation = (String)params.get("ParentLocation");
            if (params.containsKey("Heterogeneous")) {
                this.heterogeneous = (Boolean)params.get("Heterogeneous");
            }
            if (params.containsKey("WrapStore")) {
                this.wrapstore = (Boolean)params.get("WrapStore");
            }
            this.initTileIndexStore(params, create, spi);
        }
        catch (Throwable e) {
            this.handleInitializationException(e);
            throw new IllegalArgumentException(e);
        }
        if (TRACE_ENABLED.booleanValue()) {
            this.tracer = new Throwable();
            this.tracer.fillInStackTrace();
        }
    }

    protected void initializeTypeNames(Properties params) throws IOException {
        Object typeNames;
        String typeName = null;
        boolean scanForTypeNames = false;
        if (params.containsKey("TypeName")) {
            typeName = (String)params.get("TypeName");
        }
        if (params.containsKey("TypeNames")) {
            scanForTypeNames = Boolean.valueOf(params.get("TypeNames").toString());
        }
        if (scanForTypeNames) {
            typeNames = this.getTileIndexStore().getTypeNames();
            if (typeNames != null) {
                for (Object tn : typeNames) {
                    this.getValidTypeNames().add((String)tn);
                }
            }
        } else if (typeName != null) {
            this.checkMosaicSchema(typeName);
            this.addTypeName(typeName, false);
        } else {
            typeNames = this.getTileIndexStore().getTypeNames();
            if (typeNames != null) {
                for (Object tn : typeNames) {
                    if (!this.isValidMosaicSchema((String)tn)) continue;
                    this.addTypeName((String)tn, false);
                    break;
                }
            }
        }
        if (this.getValidTypeNames().size() == 0) {
            throw new IllegalArgumentException("Could not find a suitable mosaic type (with a footprint and a location attribute named " + this.getLocationAttributeName() + " in the store");
        }
        if (this.getValidTypeNames().size() > 0) {
            for (String string : this.getValidTypeNames()) {
                if (!this.isValidMosaicSchema(string)) continue;
                this.extractBasicProperties(string);
                break;
            }
        } else if (typeName != null && typeName.contains(",")) {
            for (Object tn : typeNames = typeName.split(",")) {
                this.extractBasicProperties((String)tn);
            }
        } else if (typeName != null) {
            this.extractBasicProperties(typeName);
        } else {
            this.extractBasicProperties(typeName);
        }
    }

    protected abstract void handleInitializationException(Throwable var1);

    protected abstract void initTileIndexStore(Properties var1, boolean var2, DataStoreFactorySpi var3) throws IOException, MalformedURLException;

    private boolean isValidMosaicSchema(String typeName) throws IOException {
        SimpleFeatureType schema = this.getTileIndexStore().getSchema(typeName);
        return Utils.isValidMosaicSchema(schema, this.getLocationAttributeName());
    }

    private String getLocationAttributeName() {
        if (this.locationAttribute == null) {
            return "location";
        }
        return this.locationAttribute;
    }

    private void checkMosaicSchema(String typeName) throws IOException {
        SimpleFeatureType schema = this.getTileIndexStore().getSchema(typeName);
        if (schema == null) {
            throw new IllegalArgumentException("Could not find typename " + schema);
        }
        this.checkMosaicSchema(schema);
    }

    private void checkMosaicSchema(SimpleFeatureType schema) {
        if (!Utils.isValidMosaicSchema(schema, this.getLocationAttributeName())) {
            throw new IllegalArgumentException("Invalid mosaic schema " + schema + ", it should have a geometry and a location property of name " + this.locationAttribute);
        }
    }

    private void checkStore() throws IllegalStateException {
        if (this.getTileIndexStore() == null) {
            throw new IllegalStateException("The index store has been disposed already.");
        }
    }

    private void extractBasicProperties(String typeName) throws IOException {
        SimpleFeatureSource featureSource;
        if (typeName == null) {
            String[] typeNames = this.getTileIndexStore().getTypeNames();
            if (typeNames == null || typeNames.length <= 0) {
                throw new IllegalArgumentException("BBOXFilterExtractor::extractBasicProperties(): Problems when opening the index, no typenames for the schema are defined");
            }
            if (typeName == null) {
                typeName = typeNames[0];
                this.addTypeName(typeName, false);
                if (LOGGER.isLoggable(Level.WARNING)) {
                    LOGGER.warning("BBOXFilterExtractor::extractBasicProperties(): passed typename is null, using: " + typeName);
                }
            }
            for (String type : typeNames) {
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): Looking for type '" + typeName + "' in DataStore:getTypeNames(). Testing: '" + type + "'.");
                }
                if (!type.equalsIgnoreCase(typeName)) continue;
                if (LOGGER.isLoggable(Level.FINE)) {
                    LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): SUCCESS -> type '" + typeName + "' is equalsIgnoreCase() to '" + type + "'.");
                }
                typeName = type;
                this.addTypeName(typeName, false);
                break;
            }
        }
        if ((featureSource = this.getTileIndexStore().getFeatureSource(typeName)) == null) {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a featureSource for the qualified name" + typeName);
        }
        FeatureType schema = featureSource.getSchema();
        if (schema != null && schema.getGeometryDescriptor() != null) {
            this.geometryPropertyName = schema.getGeometryDescriptor().getLocalName();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("BBOXFilterExtractor::extractBasicProperties(): geometryPropertyName is set to '" + this.geometryPropertyName + "'.");
            }
        } else {
            throw new IOException("BBOXFilterExtractor::extractBasicProperties(): unable to get a schema from the featureSource");
        }
    }

    @Override
    public void dispose() {
        try {
            if (this.multiScaleROIProvider != null) {
                this.multiScaleROIProvider.dispose();
            }
        }
        catch (Throwable e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
        }
        finally {
            this.multiScaleROIProvider = null;
            this.disposeTileIndexStore();
        }
    }

    protected abstract void disposeTileIndexStore();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int removeGranules(Query query) {
        int n;
        DefaultTransaction t;
        block8: {
            Utilities.ensureNonNull((String)"query", (Object)query);
            query = this.mergeHints(query);
            this.checkStore();
            String typeName = query.getTypeName();
            SimpleFeatureStore fs = null;
            fs = (SimpleFeatureStore)this.getTileIndexStore().getFeatureSource(typeName);
            boolean rollback = true;
            t = new DefaultTransaction();
            try {
                int retVal = fs.getFeatures(query).size();
                if (retVal > 0) {
                    fs.setTransaction((Transaction)t);
                    fs.removeFeatures(query.getFilter());
                    t.commit();
                }
                rollback = false;
                n = retVal;
                if (!rollback) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (rollback) {
                        t.rollback();
                    }
                    t.close();
                    throw throwable;
                }
                catch (Throwable e) {
                    if (LOGGER.isLoggable(Level.SEVERE)) {
                        LOGGER.log(Level.SEVERE, e.getLocalizedMessage(), e);
                    }
                    return -1;
                }
            }
            t.rollback();
        }
        t.close();
        return n;
    }

    @Override
    public void addGranules(String typeName, Collection<SimpleFeature> granules, Transaction transaction) throws IOException {
        Utilities.ensureNonNull((String)"granuleMetadata", granules);
        this.checkStore();
        SimpleFeatureStore store = (SimpleFeatureStore)this.getTileIndexStore().getFeatureSource(typeName);
        store.setTransaction(transaction);
        ListFeatureCollection featureCollection = new ListFeatureCollection(this.getTileIndexStore().getSchema(typeName));
        HashSet<FeatureId> fids = new HashSet<FeatureId>();
        for (SimpleFeature f : granules) {
            featureCollection.add(f);
            fids.add(ff.featureId(f.getID()));
        }
        store.addFeatures((FeatureCollection)featureCollection);
        store.setTransaction(null);
    }

    @Override
    public void getGranuleDescriptors(Query query, GranuleCatalogVisitor visitor) throws IOException {
        block19: {
            Utilities.ensureNonNull((String)"query", (Object)query);
            Query q = this.mergeHints(query);
            String typeName = q.getTypeName();
            this.checkStore();
            SimpleFeatureSource featureSource = this.getTileIndexStore().getFeatureSource(typeName);
            if (featureSource == null) {
                throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
            }
            SimpleFeatureCollection features = featureSource.getFeatures(q);
            if (features == null) {
                throw new NullPointerException("The provided SimpleFeatureCollection is null, it's impossible to create an index!");
            }
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Index Loaded");
            }
            SimpleFeatureIterator fi = features.features();
            Throwable throwable = null;
            block11: while (true) {
                try {
                    while (fi.hasNext() && !visitor.isVisitComplete()) {
                        SimpleFeature sf = (SimpleFeature)fi.next();
                        MultiLevelROI footprint = this.getGranuleFootprint(sf);
                        if (footprint != null && footprint.isEmpty()) continue;
                        try {
                            GranuleDescriptor granule = new GranuleDescriptor(sf, this.suggestedFormat, this.suggestedRasterSPI, this.suggestedIsSPI, this.pathType, this.locationAttribute, this.parentLocation, footprint, this.heterogeneous, q.getHints());
                            visitor.visit(granule, sf);
                            continue block11;
                        }
                        catch (Exception e) {
                            LOGGER.log(Level.FINE, "Skipping invalid granule", e);
                        }
                    }
                    break block19;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            finally {
                if (fi != null) {
                    if (throwable != null) {
                        try {
                            fi.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        fi.close();
                    }
                }
            }
        }
    }

    @Override
    public SimpleFeatureCollection getGranules(Query q) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)q);
        q = this.mergeHints(q);
        String typeName = q.getTypeName();
        this.checkStore();
        SimpleFeatureSource featureSource = this.getTileIndexStore().getFeatureSource(typeName);
        if (featureSource == null) {
            throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
        }
        return featureSource.getFeatures(q);
    }

    @Override
    public BoundingBox getBounds(String typeName) {
        try {
            this.checkStore();
            return this.getTileIndexStore().getFeatureSource(typeName).getBounds();
        }
        catch (IOException e) {
            LOGGER.log(Level.FINER, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public void createType(String namespace, String typeName, String typeSpec) throws IOException, SchemaException {
        Utilities.ensureNonNull((String)"typeName", (Object)typeName);
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        this.checkStore();
        SimpleFeatureType featureType = DataUtilities.createType((String)namespace, (String)typeName, (String)typeSpec);
        this.checkMosaicSchema(featureType);
        this.getTileIndexStore().createSchema((FeatureType)featureType);
        String type = featureType.getTypeName();
        if (typeName != null) {
            this.addTypeName(typeName, true);
        }
        this.extractBasicProperties(type);
    }

    private void addTypeName(String typeName, boolean check) {
        if (check && this.getValidTypeNames().contains(typeName)) {
            throw new IllegalArgumentException("This typeName already exists: " + typeName);
        }
        this.getValidTypeNames().add(typeName);
    }

    private void removeTypeName(String typeName) {
        if (this.getValidTypeNames().contains(typeName)) {
            this.getValidTypeNames().remove(typeName);
        }
    }

    @Override
    public String[] getTypeNames() {
        Set<String> validTypeNames = this.getValidTypeNames();
        if (validTypeNames != null && !validTypeNames.isEmpty()) {
            return validTypeNames.toArray(new String[0]);
        }
        return null;
    }

    @Override
    public void createType(SimpleFeatureType featureType) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)featureType);
        this.checkMosaicSchema(featureType);
        this.checkStore();
        this.getTileIndexStore().createSchema((FeatureType)featureType);
        String typeName = featureType.getTypeName();
        if (typeName != null) {
            this.addTypeName(typeName, true);
        }
        this.extractBasicProperties(typeName);
    }

    @Override
    public void removeType(String typeName) throws IOException {
        Utilities.ensureNonNull((String)"featureType", (Object)typeName);
        this.checkStore();
        this.getTileIndexStore().removeSchema(typeName);
        this.removeTypeName(typeName);
    }

    @Override
    public void createType(String identification, String typeSpec) throws SchemaException, IOException {
        Utilities.ensureNonNull((String)"typeSpec", (Object)typeSpec);
        Utilities.ensureNonNull((String)"identification", (Object)identification);
        String typeName = null;
        this.checkStore();
        SimpleFeatureType featureType = DataUtilities.createType((String)identification, (String)typeSpec);
        this.checkMosaicSchema(featureType);
        this.getTileIndexStore().createSchema((FeatureType)featureType);
        typeName = featureType.getTypeName();
        if (typeName != null) {
            this.addTypeName(typeName, true);
        }
        this.extractBasicProperties(typeName);
    }

    @Override
    public SimpleFeatureType getType(String typeName) throws IOException {
        this.checkStore();
        if (this.getValidTypeNames().isEmpty() || !this.getValidTypeNames().contains(typeName)) {
            return null;
        }
        return this.getTileIndexStore().getSchema(typeName);
    }

    @Override
    public void computeAggregateFunction(Query query, FeatureCalc function) throws IOException {
        query = this.mergeHints(query);
        this.checkStore();
        SimpleFeatureSource fs = this.getTileIndexStore().getFeatureSource(query.getTypeName());
        if (fs instanceof ContentFeatureSource) {
            ((ContentFeatureSource)fs).accepts(query, (FeatureVisitor)function, null);
        } else {
            SimpleFeatureCollection collection = fs.getFeatures(query);
            collection.accepts((FeatureVisitor)function, null);
        }
    }

    @Override
    public QueryCapabilities getQueryCapabilities(String typeName) {
        try {
            this.checkStore();
            return this.getTileIndexStore().getFeatureSource(typeName).getQueryCapabilities();
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.INFO)) {
                LOGGER.log(Level.INFO, "Unable to collect QueryCapabilities", e);
            }
            return null;
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.getTileIndexStore() != null) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("This granule catalog was not properly dispose as it still points to:" + this.getTileIndexStore().getInfo().toString());
                if (TRACE_ENABLED.booleanValue()) {
                    LOGGER.log(Level.WARNING, "The un-disposed granule catalog originated on this stack trace", this.tracer);
                }
            }
            this.dispose();
        }
    }

    @Override
    public int getGranulesCount(Query q) throws IOException {
        Utilities.ensureNonNull((String)"query", (Object)q);
        q = this.mergeHints(q);
        String typeName = q.getTypeName();
        this.checkStore();
        SimpleFeatureSource featureSource = this.getTileIndexStore().getFeatureSource(typeName);
        if (featureSource == null) {
            throw new NullPointerException("The provided SimpleFeatureSource is null, it's impossible to create an index!");
        }
        int count = featureSource.getCount(q);
        if (count == -1) {
            return featureSource.getFeatures(q).size();
        }
        return count;
    }

    @Override
    public void drop() throws IOException {
        Map<String, Serializable> params = Utils.filterDataStoreParams(this.params, this.spi);
        Method[] methods = this.spi.getClass().getMethods();
        boolean dropped = false;
        for (Method method : methods) {
            if (!method.getName().equalsIgnoreCase("dropDatabase")) continue;
            try {
                method.invoke((Object)this.spi, params);
            }
            catch (Exception e) {
                throw new IOException("Unable to drop the database: ", e);
            }
            dropped = true;
            break;
        }
        if (!dropped && LOGGER.isLoggable(Level.WARNING)) {
            LOGGER.log(Level.WARNING, "Unable to drop catalog for SPI " + this.spi.getDisplayName());
        }
    }

    protected abstract DataStore getTileIndexStore();

    protected abstract Set<String> getValidTypeNames();
}

