/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.acceptors;

import java.io.File;
import java.io.IOException;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptor;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class HomogeneousCRSAcceptor
implements GranuleAcceptor {
    @Override
    public boolean accepts(GridCoverage2DReader coverage, String inputCoverageName, File fileBeingProcessed, ImageMosaicConfigHandler mosaicConfigHandler) throws IOException {
        String targetCoverageName = mosaicConfigHandler.getTargetCoverageName(coverage, inputCoverageName);
        MosaicConfigurationBean config = mosaicConfigHandler.getConfigurations().get(targetCoverageName);
        return config == null || this.checkCRS(coverage, config, inputCoverageName);
    }

    private boolean checkCRS(GridCoverage2DReader coverage, MosaicConfigurationBean config, String inputCoverageName) {
        CoordinateReferenceSystem expectedCRS = config.getCrs();
        CoordinateReferenceSystem actualCRS = coverage.getCoordinateReferenceSystem(inputCoverageName);
        return CRS.equalsIgnoreMetadata((Object)expectedCRS, (Object)actualCRS);
    }
}

