/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic.acceptors;

import java.awt.image.ColorModel;
import java.io.File;
import java.io.IOException;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.MosaicConfigurationBean;
import org.geotools.gce.imagemosaic.RasterManager;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptor;

public class ColorCheckAcceptor
implements GranuleAcceptor {
    @Override
    public boolean accepts(GridCoverage2DReader coverage, String inputCoverageName, File fileBeingProcessed, ImageMosaicConfigHandler mosaicConfigHandler) throws IOException {
        String targetCoverageName = mosaicConfigHandler.getTargetCoverageName(coverage, inputCoverageName);
        MosaicConfigurationBean config = mosaicConfigHandler.getConfigurations().get(targetCoverageName);
        if (config != null) {
            RasterManager rasterManager = mosaicConfigHandler.getRasterManagerForTargetCoverage(targetCoverageName);
            return this.checkColorModel(coverage, config, rasterManager, inputCoverageName);
        }
        return true;
    }

    private boolean checkColorModel(GridCoverage2DReader coverage, MosaicConfigurationBean config, RasterManager rasterManager, String inputCoverageName) throws IOException {
        byte[][] palette = config.getPalette();
        ColorModel colorModel = config.getColorModel();
        ColorModel actualCM = coverage.getImageLayout(inputCoverageName).getColorModel(null);
        if (colorModel == null) {
            colorModel = rasterManager.getDefaultCM();
        }
        if (palette == null) {
            palette = rasterManager.getDefaultPalette();
        }
        return !Utils.checkColorModels(colorModel, palette, actualCM);
    }
}

