/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.util.ArrayList;
import java.util.Collections;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.util.Utilities;

final class OverviewsController {
    final ArrayList<OverviewLevel> resolutionsLevels = new ArrayList();
    private int numberOfOverviews;

    public OverviewsController(double[] highestRes, int numberOfOverviews, double[][] overviewsResolution) {
        this.resolutionsLevels.add(new OverviewLevel(1.0, highestRes[0], highestRes[1], 0));
        this.numberOfOverviews = numberOfOverviews;
        if (numberOfOverviews > 0) {
            for (int i = 0; i < overviewsResolution.length; ++i) {
                this.resolutionsLevels.add(new OverviewLevel(overviewsResolution[i][0] / highestRes[0], overviewsResolution[i][0], overviewsResolution[i][1], i + 1));
            }
            Collections.sort(this.resolutionsLevels);
        }
    }

    int pickOverviewLevel(OverviewPolicy policy, double[] requestedResolution, double[] virtualNativeResolution) {
        double requestedScaleFactor;
        if (this.resolutionsLevels == null || this.resolutionsLevels.size() <= 0) {
            return 0;
        }
        OverviewLevel max = this.resolutionsLevels.get(0);
        boolean useVirtual = false;
        if (virtualNativeResolution != null) {
            useVirtual = true;
        }
        double virtualRequestedScaleFactor = Double.NaN;
        double reqx = 0.0;
        double reqy = 0.0;
        if (requestedResolution != null) {
            reqx = requestedResolution[0];
            reqy = requestedResolution[1];
            if (useVirtual) {
                double virtualRequestedScaleFactorX = virtualNativeResolution[0] / max.resolutionX;
                double virtualRequestedScaleFactorY = virtualNativeResolution[1] / max.resolutionY;
                double d = virtualRequestedScaleFactor = virtualRequestedScaleFactorX <= virtualRequestedScaleFactorY ? virtualRequestedScaleFactorX : virtualRequestedScaleFactorY;
            }
        }
        if (!useVirtual && requestedResolution == null) {
            return 0;
        }
        double requestedScaleFactorX = reqx / max.resolutionX;
        double requestedScaleFactorY = reqy / max.resolutionY;
        boolean leastReduceAxis = !(requestedScaleFactorX <= requestedScaleFactorY);
        double d = requestedScaleFactor = !leastReduceAxis ? requestedScaleFactorX : requestedScaleFactorY;
        if (requestedScaleFactor <= 1.0 && !useVirtual) {
            return max.imageChoice;
        }
        OverviewLevel min = this.resolutionsLevels.get(this.resolutionsLevels.size() - 1);
        if (requestedScaleFactor >= min.scaleFactor) {
            if (useVirtual && min.imageChoice != 0) {
                virtualNativeResolution[0] = Double.NaN;
                virtualNativeResolution[1] = Double.NaN;
            }
            return min.imageChoice;
        }
        OverviewLevel prev = max;
        int size = this.resolutionsLevels.size();
        for (int i = 1; i < size; ++i) {
            OverviewLevel curr = this.resolutionsLevels.get(i);
            if (curr.scaleFactor == requestedScaleFactor) {
                if (!useVirtual) {
                    return curr.imageChoice;
                }
                if (curr.scaleFactor == virtualRequestedScaleFactor) {
                    return curr.imageChoice;
                }
            }
            if (curr.scaleFactor > requestedScaleFactor || i == size - 1) {
                if (policy == OverviewPolicy.QUALITY || useVirtual) {
                    if (useVirtual) {
                        if (curr.scaleFactor > virtualRequestedScaleFactor) {
                            if (requestedScaleFactor > virtualRequestedScaleFactor) {
                                useVirtual = false;
                                virtualNativeResolution[0] = Double.NaN;
                                virtualNativeResolution[1] = Double.NaN;
                                return prev.imageChoice;
                            }
                            return prev.imageChoice;
                        }
                        prev = curr;
                        continue;
                    }
                    return prev.imageChoice;
                }
                if (policy == OverviewPolicy.SPEED) {
                    return curr.imageChoice;
                }
                if (requestedScaleFactor - prev.scaleFactor < curr.scaleFactor - requestedScaleFactor) {
                    return prev.imageChoice;
                }
                return curr.imageChoice;
            }
            prev = curr;
        }
        return max.imageChoice;
    }

    public int getNumberOfOverviews() {
        return this.numberOfOverviews;
    }

    public OverviewLevel getLevel(int overviewIndex) {
        if (overviewIndex < 0 || overviewIndex > this.numberOfOverviews) {
            throw new IllegalArgumentException("overviewIndex is out of range, it should be >= 0 and < " + this.numberOfOverviews);
        }
        return this.resolutionsLevels.get(overviewIndex);
    }

    static class OverviewLevel
    implements Comparable<OverviewLevel> {
        double scaleFactor;
        double resolutionX;
        double resolutionY;
        int imageChoice;

        public OverviewLevel(double scaleFactor, double resolutionX, double resolutionY, int imageChoice) {
            this.scaleFactor = scaleFactor;
            this.resolutionX = resolutionX;
            this.resolutionY = resolutionY;
            this.imageChoice = imageChoice;
        }

        @Override
        public int compareTo(OverviewLevel other) {
            if (this.scaleFactor > other.scaleFactor) {
                return 1;
            }
            if (this.scaleFactor < other.scaleFactor) {
                return -1;
            }
            return 0;
        }

        public String toString() {
            return "OverviewLevel[Choice=" + this.imageChoice + ",scaleFactor=" + this.scaleFactor + ",resX:" + this.resolutionX + ",resY:" + this.resolutionY + "]";
        }

        public int hashCode() {
            int hash = Utilities.hash((int)this.imageChoice, (int)31);
            hash = Utilities.hash((double)this.resolutionX, (int)hash);
            hash = Utilities.hash((double)this.resolutionY, (int)hash);
            hash = Utilities.hash((double)this.scaleFactor, (int)hash);
            return hash;
        }
    }
}

