/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.imagemosaic;

import java.awt.RenderingHints;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.io.FilenameUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.coverage.grid.io.UnknownFormat;
import org.geotools.data.DefaultTransaction;
import org.geotools.gce.imagemosaic.ImageMosaicConfigHandler;
import org.geotools.gce.imagemosaic.ImageMosaicEventHandlers;
import org.geotools.gce.imagemosaic.Utils;
import org.geotools.gce.imagemosaic.acceptors.GranuleAcceptor;
import org.geotools.util.URLs;
import org.geotools.util.Utilities;
import org.geotools.util.factory.Hints;
import org.geotools.util.logging.Logging;

abstract class ImageMosaicWalker
implements Runnable {
    static final Logger LOGGER = Logging.getLogger(ImageMosaicWalker.class);
    private DefaultTransaction transaction;
    private static Set<String> logExcludes = new HashSet<String>();
    private volatile boolean stop = false;
    protected final ImageMosaicConfigHandler configHandler;
    protected final Hints excludeMosaicHints = new Hints((RenderingHints.Key)Utils.EXCLUDE_MOSAIC, (Object)true);
    private AbstractGridFormat cachedFormat;
    private int fileIndex = 0;
    private int numFiles = 1;
    protected final ImageMosaicEventHandlers eventHandler;

    public ImageMosaicWalker(ImageMosaicConfigHandler configHandler, ImageMosaicEventHandlers eventHandler) {
        Utilities.ensureNonNull((String)"config handler", (Object)configHandler);
        Utilities.ensureNonNull((String)"event handler", (Object)eventHandler);
        this.configHandler = configHandler;
        this.eventHandler = eventHandler;
    }

    public boolean getStop() {
        return this.stop;
    }

    public void stop() {
        this.stop = true;
    }

    protected boolean checkFile(File fileBeingProcessed) {
        return fileBeingProcessed.exists() && fileBeingProcessed.canRead() && fileBeingProcessed.isFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFile(File fileBeingProcessed) throws IOException {
        String extension;
        String validFileName;
        ++this.fileIndex;
        if (!this.checkFile(fileBeingProcessed)) {
            return;
        }
        try {
            validFileName = fileBeingProcessed.getCanonicalPath();
            validFileName = FilenameUtils.normalize((String)validFileName);
            extension = FilenameUtils.getExtension((String)validFileName);
        }
        catch (IOException e) {
            this.eventHandler.fireFileEvent(Level.FINER, fileBeingProcessed, false, "Exception occurred while processing file " + fileBeingProcessed + ": " + e.getMessage(), (double)this.fileIndex * 100.0 / (double)this.numFiles);
            this.eventHandler.fireException(e);
            return;
        }
        validFileName = FilenameUtils.getName((String)validFileName);
        this.eventHandler.fireEvent(Level.INFO, "Now indexing file " + validFileName, (double)this.fileIndex * 100.0 / (double)this.numFiles);
        AbstractGridCoverage2DReader coverageReader = null;
        try {
            String[] coverageNames;
            AbstractGridFormat format = this.cachedFormat == null ? GridFormatFinder.findFormat((Object)fileBeingProcessed, (Hints)this.excludeMosaicHints) : (this.cachedFormat.accepts((Object)fileBeingProcessed) ? this.cachedFormat : GridFormatFinder.findFormat((Object)fileBeingProcessed, (Hints)this.excludeMosaicHints));
            if (format instanceof UnknownFormat || format == null) {
                if (!logExcludes.contains(extension)) {
                    this.eventHandler.fireFileEvent(Level.INFO, fileBeingProcessed, false, "Skipped file " + fileBeingProcessed + ": File format is not supported.", (double)this.fileIndex * 99.0 / (double)this.numFiles);
                }
                return;
            }
            Hints configurationHints = this.configHandler.getRunConfiguration().getHints();
            coverageReader = format.getReader((Object)fileBeingProcessed, configurationHints);
            if (this.configHandler.getCachedReaderSPI() == null) {
                URL granuleUrl = URLs.fileToUrl((File)fileBeingProcessed);
                ImageInputStreamSpi inStreamSpi = Utils.getInputStreamSPIFromURL(granuleUrl);
                if (inStreamSpi == null) {
                    throw new IllegalArgumentException("no inputStreamSPI available!");
                }
                try (ImageInputStream inStream = null;){
                    inStream = inStreamSpi.createInputStreamInstance(granuleUrl, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
                    if (inStream == null) {
                        if (LOGGER.isLoggable(Level.WARNING)) {
                            LOGGER.log(Level.WARNING, Utils.getFileInfo(fileBeingProcessed));
                        }
                        throw new IllegalArgumentException("Unable to get an input stream for the provided file " + granuleUrl.toString());
                    }
                    ImageReaderSpi spi = Utils.getReaderSpiFromStream(null, inStream);
                    this.configHandler.setCachedReaderSPI(spi);
                }
            }
            for (String cvName : coverageNames = coverageReader.getGridCoverageNames()) {
                boolean shouldAccept = true;
                try {
                    for (GranuleAcceptor acceptor : this.configHandler.getGranuleAcceptors()) {
                        if (acceptor.accepts((GridCoverage2DReader)coverageReader, cvName, fileBeingProcessed, this.configHandler)) continue;
                        shouldAccept = false;
                        this.eventHandler.fireFileEvent(Level.FINE, fileBeingProcessed, true, "Granule acceptor  " + acceptor.getClass().getName() + " rejected the granule being processed" + fileBeingProcessed, (double)(this.fileIndex + 1) * 99.0 / (double)this.numFiles);
                        break;
                    }
                    this.cachedFormat = format;
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, "Failure during potential granule evaluation, skipping it: " + fileBeingProcessed, e);
                    shouldAccept = false;
                }
                if (shouldAccept) {
                    this.configHandler.updateConfiguration((GridCoverage2DReader)coverageReader, cvName, fileBeingProcessed, this.fileIndex, this.numFiles, this.transaction);
                }
                this.eventHandler.fireFileEvent(Level.FINE, fileBeingProcessed, true, "Done with file " + fileBeingProcessed, (double)(this.fileIndex + 1) * 99.0 / (double)this.numFiles);
            }
        }
        catch (Exception e) {
            this.eventHandler.fireException(e);
            this.stop();
            return;
        }
        finally {
            block35: {
                try {
                    if (coverageReader != null) {
                        coverageReader.dispose();
                    }
                }
                catch (Throwable e) {
                    if (!LOGGER.isLoggable(Level.FINEST)) break block35;
                    LOGGER.log(Level.FINEST, e.getLocalizedMessage(), e);
                }
            }
        }
    }

    public void startTransaction() {
        if (this.transaction != null) {
            throw new IllegalStateException("Transaction already open!");
        }
        this.transaction = new DefaultTransaction("MosaicCreationTransaction" + System.nanoTime());
    }

    public void rollbackTransaction() throws IOException {
        this.transaction.rollback();
    }

    public void commitTransaction() throws IOException {
        this.transaction.commit();
    }

    public void closeTransaction() {
        this.transaction.close();
    }

    protected boolean checkStop() {
        if (this.getStop()) {
            this.eventHandler.fireEvent(Level.INFO, "Stopping requested at file  " + this.fileIndex + " of " + this.numFiles + " files", (double)this.fileIndex * 100.0 / (double)this.numFiles);
            return false;
        }
        return true;
    }

    public int getFileIndex() {
        return this.fileIndex;
    }

    public int getNumFiles() {
        return this.numFiles;
    }

    public void setFileIndex(int fileIndex) {
        this.fileIndex = fileIndex;
    }

    public void setNumFiles(int numFiles) {
        this.numFiles = numFiles;
    }

    public void skipFile(String path) {
        LOGGER.log(Level.INFO, "Unable to use path: " + path + " - skipping it.");
        ++this.fileIndex;
    }

    static {
        logExcludes.add("xml");
        logExcludes.add("properties");
    }
}

